/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQSubDomainBoundaryRef
implements SubDomainBoundaryRef {
    private int _id;
    private int _geometryId;
    private String _name;
    BoundaryType _type;
    int _jnctId;

    @JsonCreator
    public WQSubDomainBoundaryRef(@JsonProperty(value="id") int id, @JsonProperty(value="geometryId") int geometryId, @JsonProperty(value="name") String name, @JsonProperty(value="type") BoundaryType type, @JsonProperty(value="jnctId") int jnctId) {
        this._id = id;
        this._geometryId = geometryId;
        this._name = name;
        this._type = type;
        this._jnctId = jnctId;
    }

    public WQSubDomainBoundaryRef(WQSubDomainBoundaryRef b) {
        this._id = b.getId();
        this._geometryId = b.getGeometryId();
        this._name = b.getName();
        this._type = b.getType();
        this._jnctId = b.getJnctId();
    }

    public WQSubDomainBoundaryRef(int geoId, SubDomainBoundary b) {
        this._geometryId = geoId;
        this._id = b.getId();
        this._name = b.getName();
        this._type = b.getBoundaryType();
        this._jnctId = b.getJnctId();
    }

    public int getGeometryId() {
        return this._geometryId;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public BoundaryType getType() {
        return this._type;
    }

    public int getJnctId() {
        return this._jnctId;
    }

    @JsonIgnore
    public Comparator<? super SubDomainBoundary> getBoundaryComparator() {
        return (d1, d2) -> this.getSimilarity((SubDomainBoundary)d2).compareTo(this.getSimilarity((SubDomainBoundary)d1));
    }

    protected Long getSimilarity(SubDomainBoundary boundary) {
        Long retval = 0L;
        if (Objects.equals(this.getId(), boundary.getId())) {
            retval = retval + 50L;
        }
        if (Objects.equals(this.getName(), boundary.getName())) {
            retval = retval + 20L;
        }
        if (Objects.equals(this.getJnctId(), boundary.getJnctId())) {
            retval = retval + 8L;
        }
        return retval;
    }

    public SubDomainBoundary getBoundary(Geometry geometry) {
        SubDomainBoundary retval = null;
        Stream<SubDomainBoundary> boundaryStream = geometry.getBoundariesList().stream().filter(b -> Objects.equals(this.getType(), b.getBoundaryType()));
        retval = geometry.getId() == this.getGeometryId() ? (SubDomainBoundary)boundaryStream.filter(b -> Objects.equals(this.getId(), b.getId())).findFirst().orElse(null) : (SubDomainBoundary)boundaryStream.filter(b -> Objects.equals(this.getId(), b.getId()) || Objects.equals(this.getName(), b.getName())).sorted(this.getBoundaryComparator()).findFirst().orElse(null);
        return retval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WQSubDomainBoundaryRef that = (WQSubDomainBoundaryRef)o;
        return this._id == that._id && Objects.equals(this._name, that._name) && this._type == that._type;
    }

    public int hashCode() {
        return Objects.hash(this._id, this._name, this._type);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQSubDomainBoundaryRef.class);
        }
    }
}

