/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainJunctionRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQSubDomainJunctionRef
implements SubDomainJunctionRef {
    private int _id;
    private int _geometryId;
    private String _name;
    Object _jnctId;

    @JsonCreator
    public WQSubDomainJunctionRef(@JsonProperty(value="id") int id, @JsonProperty(value="geometryId") int geometryId, @JsonProperty(value="name") String name, @JsonProperty(value="jnctId") Object jnctId) {
        this._id = id;
        this._geometryId = geometryId;
        this._name = name;
        this._jnctId = jnctId;
    }

    public WQSubDomainJunctionRef(WQSubDomainJunctionRef b) {
        this._id = b.getId();
        this._geometryId = b.getGeometryId();
        this._name = b.getName();
        this._jnctId = b.getJnctId();
    }

    public WQSubDomainJunctionRef(int geoId, SubDomainJunction b) {
        this._geometryId = geoId;
        this._id = b.getId();
        this._name = b.getName();
        this._jnctId = b.getJnctId();
    }

    public int getGeometryId() {
        return this._geometryId;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public Object getJnctId() {
        return this._jnctId;
    }

    @JsonIgnore
    public Comparator<? super SubDomainJunction> getJunctionComparator() {
        return (d1, d2) -> this.getSimilarity((SubDomainJunction)d2).compareTo(this.getSimilarity((SubDomainJunction)d1));
    }

    protected Long getSimilarity(SubDomainJunction junction) {
        Long retval = 0L;
        if (Objects.equals(this.getId(), junction.getId())) {
            retval = retval + 50L;
        }
        if (Objects.equals(this.getName(), junction.getName())) {
            retval = retval + 20L;
        }
        if (Objects.equals(this.getJnctId(), junction.getJnctId())) {
            retval = retval + 8L;
        }
        return retval;
    }

    public SubDomainJunction getJunction(Geometry geometry) {
        SubDomainJunction retval = null;
        Stream boundaryStream = geometry.getJunctionsList().stream();
        retval = geometry.getId() == this.getGeometryId() ? (SubDomainJunction)boundaryStream.filter(b -> Objects.equals(this.getId(), b.getId())).findFirst().orElse(null) : (SubDomainJunction)boundaryStream.filter(b -> Objects.equals(this.getId(), b.getId()) || Objects.equals(this.getName(), b.getName())).sorted(this.getJunctionComparator()).findFirst().orElse(null);
        return retval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WQSubDomainJunctionRef that = (WQSubDomainJunctionRef)o;
        return this._id == that._id && Objects.equals(this._name, that._name);
    }

    public int hashCode() {
        return Objects.hash(this._id, this._name);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQSubDomainBoundaryRef.class);
        }
    }
}

