/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQSubDomainRef
implements SubDomainRef {
    private int _id;
    private String _name;
    SubDomainType _type;
    private int _geometryId;

    @JsonCreator
    public WQSubDomainRef(@JsonProperty(value="id") int id, @JsonProperty(value="geometryId") int geoId, @JsonProperty(value="name") String name, @JsonProperty(value="type") SubDomainType type) {
        this._id = id;
        this._geometryId = geoId;
        this._name = name;
        this._type = type;
    }

    public WQSubDomainRef(int geoId, SubDomain b) {
        this._geometryId = geoId;
        this._id = b.getId();
        this._name = b.getName();
        this._type = b.getType();
    }

    public WQSubDomainRef(WQSubDomainRef b) {
        this._id = b.getId();
        this._name = b.getName();
        this._type = b.getType();
        this._geometryId = b.getGeometryId();
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public SubDomainType getType() {
        return this._type;
    }

    public int getGeometryId() {
        return this._geometryId;
    }

    @JsonIgnore
    public Comparator<SubDomain> getSubDomainComparator() {
        return (d1, d2) -> this.getSimilarity((SubDomain)d2).compareTo(this.getSimilarity((SubDomain)d1));
    }

    protected Long getSimilarity(SubDomain domain) {
        Long retval = 0L;
        if (Objects.equals(this.getId(), domain.getId())) {
            retval = retval + 50L;
        }
        if (Objects.equals(this.getName(), domain.getName())) {
            retval = retval + 20L;
        }
        return retval;
    }

    public SubDomain getSubDomain(Geometry geometry) {
        SubDomain retval = null;
        int geometryId = geometry.getId();
        if (geometryId == this.getGeometryId()) {
            retval = geometry.getSubDomainList().stream().filter(b -> Objects.equals(this.getId(), b.getId()) && Objects.equals(this.getType(), b.getType())).findFirst().orElse(null);
        } else {
            List nameOrIdMatches = geometry.getSubDomainList().stream().filter(b -> Objects.equals(this.getType(), b.getType())).filter(b -> Objects.equals(this.getId(), b.getId()) || Objects.equals(this.getName(), b.getName())).collect(Collectors.toList());
            if (nameOrIdMatches != null && !nameOrIdMatches.isEmpty()) {
                retval = nameOrIdMatches.stream().sorted(this.getSubDomainComparator()).findFirst().orElse(null);
            }
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WQSubDomainRef that = (WQSubDomainRef)o;
        return this._id == that._id && Objects.equals(this._name, that._name) && this._type == that._type;
    }

    public int hashCode() {
        return Objects.hash(this._id, this._name, this._type);
    }

    public String toString() {
        return "WQSubDomainRef{id=" + this._id + ", name='" + this._name + "', type=" + this._type + ", geometryId=" + this._geometryId + "}";
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQSubDomainRef.class);
        }
    }
}

