/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.initialCondition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.jackson.Entry;
import hec.wqenginecore.jackson.TypeResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
@JsonPropertyOrder(value={"selectedKey", "entries"})
public class InitialConditionsSourceSelection<T> {
    private String _selectedKey;
    @JsonIgnore
    private Map<String, T> _sources = new LinkedHashMap<String, T>();

    public String getSelectedKey() {
        return this._selectedKey;
    }

    public void setSelectedKey(String sourceName) {
        this._selectedKey = sourceName;
    }

    @JsonIgnore
    public Collection<String> keySet() {
        return Collections.unmodifiableSet(this._sources.keySet());
    }

    public void put(String sourceName, T source) {
        this._sources.put(sourceName, source);
    }

    public T get(String sourceName) {
        return this._sources.get(sourceName);
    }

    @JsonIgnore
    public T getSelected() {
        return this._sources.get(this._selectedKey);
    }

    public boolean containsKey(String sourceName) {
        return this._sources.containsKey(sourceName);
    }

    private boolean containsNonNullValueForKey(String sourceName) {
        boolean retval = false;
        if (this.containsKey(sourceName)) {
            retval = this.get(sourceName) != null;
        }
        return retval;
    }

    @JsonIgnore
    public boolean hasValidSelection() {
        String selectedKey = this.getSelectedKey();
        return this.containsKey(selectedKey) && this.containsNonNullValueForKey(selectedKey);
    }

    public void setEntries(List<Entry<String, T>> entries) {
        Entry.setEntries(this._sources, entries);
    }

    public List<Entry<String, T>> getEntries() {
        return Entry.fromMapEntries(this._sources.entrySet());
    }

    public T putAndSelectIfInvalidSelection(Supplier<? extends T> supplier, String supplierKey) {
        if (!this.hasValidSelection()) {
            this.put(supplierKey, supplier.get());
            this.setSelectedKey(supplierKey);
        }
        return this.getSelected();
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(InitialConditionsSourceSelection.class);
        }
    }
}

