/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.initialCondition;

import hec.io.PairedDataContainer;
import hec.wqenginecore.InitialCondition;
import hec.wqengineimpl.initialCondition.WQInitialCondition;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import org.apache.commons.lang3.ArrayUtils;

public class PairedDepth {
    private final PairedDataContainer _pairedDataContainer;
    private final int _curve;

    public PairedDepth(PairedDataContainer pdc) {
        this(pdc, 0);
    }

    public PairedDepth(PairedDataContainer pdc, int curve) {
        this._pairedDataContainer = pdc;
        this._curve = curve;
    }

    public void addCondition(Double depth, InitialCondition ic) {
        Double override = ic != null ? ic.getOverride() : null;
        this.addCondition(depth, override);
    }

    public void removeCondition(Double depth) {
        this.addCondition(depth, (Double)null);
    }

    public void clearConditions() {
        if (this._pairedDataContainer != null) {
            SortedMap<Double, double[]> data = PairedDepth.getDataAsMap(this._pairedDataContainer);
            data.clear();
            PairedDepth.setDataAsMap(this._pairedDataContainer, data);
        }
    }

    public double getYOrdinate(Double depth) {
        int index;
        double retval = -3.4028234663852886E38;
        if (this._pairedDataContainer != null && depth != null && this._pairedDataContainer.xOrdinates != null && this._pairedDataContainer.xOrdinates.length > 0 && this._pairedDataContainer.yOrdinates != null && this._pairedDataContainer.yOrdinates.length > this._curve && (index = ArrayUtils.indexOf((double[])this._pairedDataContainer.xOrdinates, (double)depth)) >= 0) {
            retval = this._pairedDataContainer.yOrdinates[this._curve][index];
        }
        return retval;
    }

    public boolean isDepth() {
        if (this._pairedDataContainer != null && this._pairedDataContainer.xparameter != null) {
            return this._pairedDataContainer.xparameter.toLowerCase().contains("depth");
        }
        return false;
    }

    public void addCondition(Double depth, Double override) {
        if (this._pairedDataContainer != null && depth != null) {
            PairedDataContainer.ensureCurveExists((PairedDataContainer)this._pairedDataContainer, (int)this._curve);
            SortedMap<Double, double[]> data = PairedDepth.getDataAsMap(this._pairedDataContainer);
            if (override != null) {
                double[] vals = data.computeIfAbsent(depth, v -> new double[this._pairedDataContainer.numberCurves]);
                vals[this._curve] = override;
            } else {
                double[] vals = (double[])data.get(depth);
                if (vals == null || vals.length <= 1) {
                    data.remove(depth);
                } else {
                    vals[this._curve] = -3.4028234663852886E38;
                }
            }
            PairedDepth.setDataAsMap(this._pairedDataContainer, data);
        }
    }

    public SortedMap<Double, InitialCondition> getConditions(int constituentId) {
        TreeMap<Double, InitialCondition> retval = new TreeMap<Double, InitialCondition>();
        if (this._pairedDataContainer != null && this._pairedDataContainer.xOrdinates != null) {
            for (int i = 0; i < this._pairedDataContainer.xOrdinates.length; ++i) {
                double depth = this._pairedDataContainer.xOrdinates[i];
                if (!NumericalConstants.isValidValue((double)depth)) continue;
                WQInitialCondition initialCondition = new WQInitialCondition(constituentId);
                initialCondition.setOverride(this._pairedDataContainer.yOrdinates[this._curve][i]);
                retval.put(depth, initialCondition);
            }
        }
        return retval;
    }

    public SortedSet<Double> getDepths() {
        TreeSet<Double> retval = new TreeSet<Double>();
        if (this._pairedDataContainer != null && this._pairedDataContainer.xOrdinates != null) {
            for (int i = 0; i < this._pairedDataContainer.xOrdinates.length; ++i) {
                double depth = this._pairedDataContainer.xOrdinates[i];
                if (!NumericalConstants.isValidValue((double)depth)) continue;
                retval.add(depth);
            }
        }
        return retval;
    }

    public static void setDataAsMap(PairedDataContainer pairedDataContainer, SortedMap<Double, double[]> data) {
        int size = data.size();
        double[] xOrdinates = new double[size];
        int nCurves = Math.max(pairedDataContainer.numberCurves, 1);
        double[][] yOrdinates = new double[nCurves][size];
        int i = 0;
        for (Map.Entry<Double, double[]> entry : data.entrySet()) {
            xOrdinates[i] = entry.getKey();
            double[] row = entry.getValue();
            for (int j = 0; j < nCurves; ++j) {
                yOrdinates[j][i] = row[j];
            }
            ++i;
        }
        pairedDataContainer.setValues(xOrdinates, yOrdinates);
    }

    public static SortedMap<Double, double[]> getDataAsMap(PairedDataContainer pairedDataContainer) {
        TreeMap<Double, double[]> data = new TreeMap<Double, double[]>();
        if (pairedDataContainer != null) {
            double[] xOrdinates = pairedDataContainer.xOrdinates;
            double[][] yOrdinates = pairedDataContainer.yOrdinates;
            if (xOrdinates != null) {
                for (int i = 0; i < xOrdinates.length; ++i) {
                    double x = xOrdinates[i];
                    double[] row = new double[pairedDataContainer.numberCurves];
                    for (int j = 0; j < pairedDataContainer.numberCurves; ++j) {
                        row[j] = yOrdinates[j][i];
                    }
                    data.put(x, row);
                }
            }
        }
        return data;
    }
}

