/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.initialCondition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.InitialCondition;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.InterpICValue;
import hec.wqenginecore.InterpolationType;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainBoundaryRef;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.initialCondition.WQInitialCondition;
import hec.wqengineimpl.initialCondition.WQInitialConditionSetChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQInitialConditionSet
implements InitialConditionSet {
    private String _name = "";
    private String _description = "";
    private InterpolationType _reservoirInterpolationType = InterpolationType.LINEAR;
    private InterpolationType _riverInterpolationType = InterpolationType.ONEWAYFORWARD;
    @JsonIgnore
    private Map<Integer, Map<Double, Map<WQSubDomainRef, InitialCondition>>> _reservoirConditionMap = new LinkedHashMap<Integer, Map<Double, Map<WQSubDomainRef, InitialCondition>>>();
    @JsonIgnore
    private Map<Integer, Map<WQSubDomainBoundaryRef, InitialCondition>> _junctionConditionMap = new LinkedHashMap<Integer, Map<WQSubDomainBoundaryRef, InitialCondition>>();
    @JsonIgnore
    private Map<Integer, Map<SubDomainBoundaryRef, InterpICValue>> _interpolatedJunctionICMap = null;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    @JsonIgnore
    public Set<Integer> getConstituentIds() {
        LinkedHashSet<Integer> retval = new LinkedHashSet<Integer>();
        retval.addAll(this._reservoirConditionMap.keySet());
        retval.addAll(this._junctionConditionMap.keySet());
        return retval;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public InterpolationType getReservoirInterpolationType() {
        return this._reservoirInterpolationType;
    }

    public void setReservoirInterpolationType(InterpolationType reservoirInterpolationType) {
        this._reservoirInterpolationType = reservoirInterpolationType;
    }

    public InterpolationType getReachInterpolationType() {
        return this._riverInterpolationType;
    }

    public void setReachInterpolationType(InterpolationType reachInterpolationType) {
        this._riverInterpolationType = reachInterpolationType;
    }

    public Set<Double> getDepths(SubDomainRef sdRef) {
        TreeSet<Double> retval = new TreeSet<Double>();
        for (Map<Double, Map<WQSubDomainRef, InitialCondition>> depthMap : this._reservoirConditionMap.values()) {
            for (Map.Entry<Double, Map<WQSubDomainRef, InitialCondition>> entry : depthMap.entrySet()) {
                Double depth = entry.getKey();
                Map<WQSubDomainRef, InitialCondition> icMap = entry.getValue();
                if (!icMap.containsKey(sdRef)) continue;
                retval.add(depth);
            }
        }
        return Collections.unmodifiableSet(retval);
    }

    public Set<Double> getDepths(SubDomainRef sdRef, Constituent constituent) {
        return this.getDepths(sdRef);
    }

    public boolean getIsDepth(SubDomainRef element, int constituentId) {
        return false;
    }

    public String getUnits(SubDomainRef element, int constituentId) {
        return null;
    }

    public Collection<InitialCondition> getConditions(SubDomainRef element, Double depth) {
        return this._reservoirConditionMap.values().stream().map(m -> (Map)m.get(depth)).filter(Objects::nonNull).map(m -> (InitialCondition)m.get(element)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void setConditions(SubDomainRef element, Double depth, Collection<InitialCondition> conditions) {
        this.clearConditions(element, depth);
        for (InitialCondition condition : conditions) {
            this.addCondition(element, depth, condition);
        }
    }

    public void clearConditions(SubDomainRef element, Double depth) {
        for (Map.Entry<Integer, Map<Double, Map<WQSubDomainRef, InitialCondition>>> entry : this._reservoirConditionMap.entrySet()) {
            Map<WQSubDomainRef, InitialCondition> domainMap;
            Map<Double, Map<WQSubDomainRef, InitialCondition>> depthMap = entry.getValue();
            if (depthMap == null || (domainMap = depthMap.get(depth)) == null) continue;
            domainMap.remove(element);
        }
    }

    public void clearConditions(SubDomainRef element) {
        this._reservoirConditionMap.entrySet().stream().map(Map.Entry::getValue).filter(Objects::nonNull).map(Map::values).filter(Objects::nonNull).flatMap(Collection::stream).forEach(map -> map.remove(element));
    }

    public Collection<InitialCondition> getConditions(SubDomainBoundaryRef junc) {
        return this._junctionConditionMap.values().stream().map(m -> (InitialCondition)m.get(junc)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void setConditions(SubDomainBoundaryRef junc, Collection<InitialCondition> conditions) {
        this.clearConditions(junc);
        for (InitialCondition condition : conditions) {
            this.addCondition(junc, condition);
        }
    }

    public void clearConditions(SubDomainBoundaryRef junc) {
        for (Map<WQSubDomainBoundaryRef, InitialCondition> boundMap : this._junctionConditionMap.values()) {
            boundMap.remove(junc);
        }
    }

    public InitialCondition getCondition(SubDomainRef element, Double depth, int constituentId) {
        Map<WQSubDomainRef, InitialCondition> map;
        InitialCondition retval = null;
        Map<Double, Map<WQSubDomainRef, InitialCondition>> depthMap = this._reservoirConditionMap.get(constituentId);
        if (depthMap != null && (map = depthMap.get(depth)) != null) {
            retval = map.get(element);
        }
        return retval;
    }

    public void addCondition(SubDomainRef element, Double depth, InitialCondition ic) {
        Map map = this._reservoirConditionMap.computeIfAbsent(ic.getConstituentId(), v -> new LinkedHashMap());
        Map icMap = map.computeIfAbsent(depth, v -> new HashMap());
        icMap.put((WQSubDomainRef)element, ic);
    }

    public void removeCondition(SubDomainRef element, Double depth, int constituentId) {
        if (element instanceof WQSubDomainRef) {
            Map<Double, Map<WQSubDomainRef, InitialCondition>> depthMap = this._reservoirConditionMap.get(constituentId);
            Map<WQSubDomainRef, InitialCondition> elementMap = null;
            if (depthMap != null) {
                elementMap = depthMap.get(depth);
            }
            if (elementMap != null) {
                elementMap.remove(element);
            }
        }
    }

    public InitialCondition getCondition(SubDomainBoundaryRef junc, int constituentId) {
        InitialCondition retval = null;
        Map<WQSubDomainBoundaryRef, InitialCondition> map = this._junctionConditionMap.get(constituentId);
        if (map != null) {
            retval = map.get(junc);
        }
        return retval;
    }

    public void addCondition(SubDomainBoundaryRef junc, InitialCondition ic) {
        Map map = this._junctionConditionMap.computeIfAbsent(ic.getConstituentId(), v -> new HashMap());
        map.put((WQSubDomainBoundaryRef)junc, ic);
    }

    public void removeCondition(SubDomainBoundaryRef junc, int constituentId) {
        Map<WQSubDomainBoundaryRef, InitialCondition> juncMap;
        if (junc instanceof WQSubDomainBoundaryRef && (juncMap = this._junctionConditionMap.get(constituentId)) != null) {
            juncMap.remove(junc);
        }
    }

    @JsonIgnore
    public Set<SubDomainRef> getSubDomainRefs() {
        return this._reservoirConditionMap.values().stream().map(Map::values).flatMap(Collection::stream).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<SubDomainBoundaryRef> getSubDomainBoundaryRefs() {
        return this._junctionConditionMap.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<Double> getDepths(SubDomain element) {
        return this.getDepths(element.getRef());
    }

    public Collection<InitialCondition> getConditions(SubDomain element, Double depth) {
        return this.getConditions(element.getRef(), depth);
    }

    public void clear() {
        this.clearBoundaryConditions();
        this.clearSubDomainConditions();
    }

    public void clearBoundaryConditions() {
        this._junctionConditionMap.clear();
    }

    public void clearSubDomainConditions() {
        this._reservoirConditionMap.clear();
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public List<DepthEntry> getSubDomainEntries() {
        ArrayList<DepthEntry> retval = new ArrayList<DepthEntry>();
        for (Map.Entry<Integer, Map<Double, Map<WQSubDomainRef, InitialCondition>>> entry : this._reservoirConditionMap.entrySet()) {
            Map<Double, Map<WQSubDomainRef, InitialCondition>> depthMap = entry.getValue();
            for (Map.Entry<Double, Map<WQSubDomainRef, InitialCondition>> depthEntry : depthMap.entrySet()) {
                Double depth = depthEntry.getKey();
                Map<WQSubDomainRef, InitialCondition> icMap = depthEntry.getValue();
                for (Map.Entry<WQSubDomainRef, InitialCondition> icEntry : icMap.entrySet()) {
                    WQSubDomainRef ref = icEntry.getKey();
                    InitialCondition ic = icEntry.getValue();
                    retval.add(new DepthEntry(depth, ref, (WQInitialCondition)ic));
                }
            }
        }
        return retval;
    }

    public void setSubDomainEntries(List<DepthEntry> entries) {
        this._reservoirConditionMap.clear();
        for (DepthEntry entry : entries) {
            this.addCondition(entry.getRef(), entry.getDepth(), entry.getInitialCondition());
        }
    }

    public List<BoundaryEntry> getBoundaryEntries() {
        ArrayList<BoundaryEntry> retval = new ArrayList<BoundaryEntry>();
        for (Map.Entry<Integer, Map<WQSubDomainBoundaryRef, InitialCondition>> entry : this._junctionConditionMap.entrySet()) {
            Integer constId = entry.getKey();
            Map<WQSubDomainBoundaryRef, InitialCondition> refMap = entry.getValue();
            for (Map.Entry<WQSubDomainBoundaryRef, InitialCondition> refEntry : refMap.entrySet()) {
                WQSubDomainBoundaryRef ref = refEntry.getKey();
                InitialCondition ic = refEntry.getValue();
                retval.add(new BoundaryEntry(constId, ref, (WQInitialCondition)ic));
            }
        }
        return retval;
    }

    public void setBoundaryEntries(List<BoundaryEntry> entries) {
        this._junctionConditionMap.clear();
        for (BoundaryEntry entry : entries) {
            this.addCondition(entry.getRef(), entry.getInitialCondition());
        }
    }

    @JsonIgnore
    public void setInterpolatedJunctionICMap(Map<Integer, Map<SubDomainBoundaryRef, InterpICValue>> interpolatedJunctionICMap) {
        this._interpolatedJunctionICMap = interpolatedJunctionICMap;
    }

    @JsonIgnore
    public boolean hasInterpolatedJunctionICMap() {
        return this._interpolatedJunctionICMap != null && !this._interpolatedJunctionICMap.isEmpty();
    }

    @JsonIgnore
    public InterpICValue getInterpolatedIC(Integer constitId, SubDomainBoundaryRef sdRef) {
        Map<SubDomainBoundaryRef, InterpICValue> map;
        if (this._interpolatedJunctionICMap != null && (map = this._interpolatedJunctionICMap.get(constitId)) != null) {
            return map.get(sdRef);
        }
        return null;
    }

    public WQConsistencyCheck checkConsistency(Geometry wqGeo, ConstituentSet constitSet) {
        WQInitialConditionSetChecker checker = new WQInitialConditionSetChecker(this);
        return checker.checkConsistency(wqGeo, constitSet);
    }

    public String getIConditionDataType(int constituentId, SubDomainRef subDomainRef) {
        return "PairedData";
    }

    public static class DepthEntry {
        double _depth;
        WQSubDomainRef _ref;
        WQInitialCondition _initialCondition;

        public DepthEntry() {
        }

        public DepthEntry(Double depth, WQSubDomainRef ref, WQInitialCondition ic) {
            this._depth = depth;
            this._ref = ref;
            this._initialCondition = ic;
        }

        public double getDepth() {
            return this._depth;
        }

        public void setDepth(double depth) {
            this._depth = depth;
        }

        public WQSubDomainRef getRef() {
            return this._ref;
        }

        public void setRef(WQSubDomainRef ref) {
            this._ref = ref;
        }

        public WQInitialCondition getInitialCondition() {
            return this._initialCondition;
        }

        public void setInitialCondition(WQInitialCondition initialCondition) {
            this._initialCondition = initialCondition;
        }
    }

    public static class BoundaryEntry {
        int _constituentId;
        WQSubDomainBoundaryRef _ref;
        WQInitialCondition _initialCondition;

        public BoundaryEntry() {
        }

        public BoundaryEntry(Integer constId, WQSubDomainBoundaryRef ref, WQInitialCondition ic) {
            this._constituentId = constId;
            this._ref = ref;
            this._initialCondition = ic;
        }

        public int getConstituentId() {
            return this._constituentId;
        }

        public void setConstituentId(int constituentId) {
            this._constituentId = constituentId;
        }

        public WQSubDomainBoundaryRef getRef() {
            return this._ref;
        }

        public void setRef(WQSubDomainBoundaryRef ref) {
            this._ref = ref;
        }

        public WQInitialCondition getInitialCondition() {
            return this._initialCondition;
        }

        public void setInitialCondition(WQInitialCondition initialCondition) {
            this._initialCondition = initialCondition;
        }
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQInitialConditionSet.class);
        }
    }
}

