/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.initialCondition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.google.common.flogger.FluentLogger;
import hec.io.PairedDataContainer;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.InitialCondition;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.InterpICValue;
import hec.wqenginecore.InterpolationType;
import hec.wqenginecore.PairedDataProvider;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.pairedData.PairedData;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.initialCondition.InitialConditionsSourceSelection;
import hec.wqengineimpl.initialCondition.PairedDepth;
import hec.wqengineimpl.initialCondition.WQInitialCondition;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet;
import hec.wqengineimpl.initialCondition.WQInitialConditionSetChecker;
import hec.wqengineimpl.initialCondition.WQMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQInitialConditionSet2
implements InitialConditionSet {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private String _name = "";
    private String _description = "";
    private InterpolationType _reservoirInterpolationType = InterpolationType.LINEAR;
    private InterpolationType _riverInterpolationType = InterpolationType.ONEWAYFORWARD;
    private final WQMap<Integer, WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>>> _reservoirSourcesMap = new WQMap();
    private final WQMap<Integer, WQMap<SubDomainBoundaryRef, InitialCondition>> _junctionConditionMap = new WQMap();
    @JsonIgnore
    private transient Map<Integer, Map<SubDomainBoundaryRef, InterpICValue>> _interpolatedJunctionICMap;
    @JsonIgnore
    private PairedDataProvider _dataProvider;

    public void setPairedDataProvider(PairedDataProvider dataProvider) {
        this._dataProvider = dataProvider;
    }

    public static WQInitialConditionSet2 build(WQInitialConditionSet icSet) {
        WQInitialConditionSet2 retval = null;
        if (icSet != null) {
            retval = new WQInitialConditionSet2();
            retval.setName(icSet.getName());
            retval.setDescription(icSet.getDescription());
            retval.setReachInterpolationType(icSet.getReachInterpolationType());
            retval.setReservoirInterpolationType(icSet.getReservoirInterpolationType());
            Set<SubDomainBoundaryRef> subDomainBoundaryRefs = icSet.getSubDomainBoundaryRefs();
            for (SubDomainBoundaryRef boundaryRef : subDomainBoundaryRefs) {
                Collection<InitialCondition> boundaryConditions = icSet.getConditions(boundaryRef);
                if (boundaryConditions == null) continue;
                for (InitialCondition boundaryCondition : boundaryConditions) {
                    retval.addCondition(boundaryRef, boundaryCondition);
                }
            }
            Set<Integer> constituentIds = icSet.getConstituentIds();
            for (Integer constituentId : constituentIds) {
                Set<SubDomainRef> subDomainRefs = icSet.getSubDomainRefs();
                for (SubDomainRef subDomainRef : subDomainRefs) {
                    SortedMap<Double, InitialCondition> conditions = WQInitialConditionSet2.getConditions(icSet, constituentId, subDomainRef);
                    PairedDataContainer pairedDataContainer = WQInitialConditionSet2.buildPairedDataContainer(conditions);
                    InitialConditionsSourceSelection<Data> sourceSelection = retval.getSourceSelection(constituentId, subDomainRef);
                    PairedData data = new PairedData();
                    data.setPairedDataContainer(pairedDataContainer);
                    sourceSelection.put("Paired Data", (Data)data);
                    sourceSelection.setSelectedKey("Paired Data");
                }
            }
        }
        return retval;
    }

    private static PairedDataContainer buildPairedDataContainer(SortedMap<Double, InitialCondition> conditions) {
        PairedDataContainer pairedDataContainer = null;
        if (conditions != null && !conditions.isEmpty()) {
            int size = conditions.size();
            TreeSet<Double> depths = new TreeSet<Double>(conditions.keySet());
            double[] depthsArr = depths.stream().mapToDouble(Double::doubleValue).toArray();
            double[] valuesArr = new double[size];
            Arrays.fill(valuesArr, -3.4028234663852886E38);
            for (int i = 0; i < depthsArr.length; ++i) {
                Double override;
                double depth = depthsArr[i];
                InitialCondition condition = (InitialCondition)conditions.get(depth);
                if (condition == null || (override = condition.getOverride()) == null) continue;
                valuesArr[i] = override;
            }
            pairedDataContainer = new PairedDataContainer();
            pairedDataContainer.setValues(depthsArr, (double[][])new double[][]{valuesArr});
        }
        return pairedDataContainer;
    }

    private static SortedMap<Double, InitialCondition> getConditions(InitialConditionSet icSet, int constituentId, SubDomainRef subDomainRef) {
        TreeMap<Double, InitialCondition> retval = new TreeMap<Double, InitialCondition>();
        icSet.getDepths(subDomainRef).forEach(depth -> {
            Double override;
            InitialCondition condition = icSet.getCondition(subDomainRef, depth, constituentId);
            if (condition != null && NumericalConstants.isValidValue((Double)(override = condition.getOverride()))) {
                retval.put((Double)depth, condition);
            }
        });
        return retval;
    }

    public InitialConditionsSourceSelection<Data> getSourceSelection(int constituentId, SubDomainRef subDomainRef) {
        WQMap constituentSelections = this._reservoirSourcesMap.computeIfAbsent(constituentId, k -> new WQMap());
        return constituentSelections.computeIfAbsent(subDomainRef, k -> new InitialConditionsSourceSelection());
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    @JsonIgnore
    public Set<Integer> getConstituentIds() {
        LinkedHashSet<Integer> retval = new LinkedHashSet<Integer>();
        retval.addAll(this.getReservoirConstituentIds());
        retval.addAll(this._junctionConditionMap.keySet());
        return retval;
    }

    @JsonIgnore
    private Collection<Integer> getReservoirConstituentIds() {
        return new LinkedHashSet<Integer>(this._reservoirSourcesMap.keySet());
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public InterpolationType getReservoirInterpolationType() {
        return this._reservoirInterpolationType;
    }

    public void setReservoirInterpolationType(InterpolationType reservoirInterpolationType) {
        this._reservoirInterpolationType = reservoirInterpolationType;
    }

    public InterpolationType getReachInterpolationType() {
        return this._riverInterpolationType;
    }

    public void setReachInterpolationType(InterpolationType reachInterpolationType) {
        this._riverInterpolationType = reachInterpolationType;
    }

    public Set<Double> getDepths(SubDomainRef sdRef) {
        TreeSet<Double> retval = new TreeSet<Double>();
        for (Integer constituentId : this._reservoirSourcesMap.keySet()) {
            retval.addAll(this.getInitialConditions(constituentId, sdRef).keySet());
        }
        return retval;
    }

    public Set<Double> getDepths(SubDomainRef sdRef, Constituent constituent) {
        return new TreeSet<Double>(this.getInitialConditions(constituent.getId(), sdRef).keySet());
    }

    private Map<Double, InitialCondition> getInitialConditions(Integer constituentId, SubDomainRef sdRef) {
        InitialConditionsSourceSelection<Data> sources;
        Data data;
        PairedDepth pairedDepth;
        TreeMap<Double, InitialCondition> retval = new TreeMap<Double, InitialCondition>();
        WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> resvMap = this._reservoirSourcesMap.get(constituentId);
        if (resvMap != null && (pairedDepth = this.getPairedDepth(data = (sources = resvMap.get(sdRef)).getSelected(), false, sdRef.getId(), constituentId)) != null) {
            retval.putAll(pairedDepth.getConditions(constituentId));
        }
        return retval;
    }

    public Collection<InitialCondition> getConditions(SubDomainRef element, Double depth) {
        ArrayList<InitialCondition> retval = new ArrayList<InitialCondition>();
        for (Integer constituentId : this._reservoirSourcesMap.keySet()) {
            InitialCondition condition = this.getCondition(element, depth, constituentId);
            if (condition == null) continue;
            retval.add(condition);
        }
        return retval;
    }

    public Collection<InitialCondition> getConditions(SubDomainBoundaryRef junc) {
        ArrayList<InitialCondition> retval = new ArrayList<InitialCondition>();
        for (Integer constituentId : this._junctionConditionMap.keySet()) {
            InitialCondition condition = this.getCondition(junc, constituentId);
            if (condition == null) continue;
            retval.add(condition);
        }
        return retval;
    }

    public void setConditions(SubDomainBoundaryRef junc, Collection<InitialCondition> conditions) {
        this.clearConditions(junc);
        for (InitialCondition condition : conditions) {
            this.addCondition(junc, condition);
        }
    }

    public void clearConditions(SubDomainBoundaryRef junc) {
        for (Integer constituentId : this._junctionConditionMap.keySet()) {
            WQMap<SubDomainBoundaryRef, InitialCondition> juncMap = this._junctionConditionMap.get(constituentId);
            if (juncMap == null) continue;
            juncMap.remove(junc);
        }
    }

    public InitialCondition getCondition(SubDomainRef element, Double depth, int constituentId) {
        WQInitialCondition retval = null;
        WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> consMap = this._reservoirSourcesMap.get(constituentId);
        if (consMap != null) {
            InitialConditionsSourceSelection<Data> sources = consMap.get(element);
            retval = this.getWqInitialCondition(sources.getSelected(), element.getId(), constituentId, depth);
        }
        return retval;
    }

    public boolean getIsDepth(SubDomainRef element, int constituentId) {
        InitialConditionsSourceSelection<Data> sources;
        Data data;
        PairedDepth pairedDepth;
        WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> consMap = this._reservoirSourcesMap.get(constituentId);
        if (consMap != null && (pairedDepth = this.getPairedDepth(data = (sources = consMap.get(element)).getSelected(), false, element.getId(), constituentId)) != null) {
            return pairedDepth.isDepth();
        }
        return false;
    }

    public String getUnits(SubDomainRef element, int constituentId) {
        InitialConditionsSourceSelection<Data> sources;
        Data data;
        PairedDepth pairedDepth;
        WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> consMap = this._reservoirSourcesMap.get(constituentId);
        if (consMap != null && (pairedDepth = this.getPairedDepth(data = (sources = consMap.get(element)).getSelected(), false, element.getId(), constituentId)) != null) {
            return data.getUnits();
        }
        return null;
    }

    private WQInitialCondition getWqInitialCondition(Data data, int subDomainId, int constituentId, Double depth) {
        double override;
        WQInitialCondition retval = null;
        PairedDepth pairedDepth = this.getPairedDepth(data, false, subDomainId, constituentId);
        if (pairedDepth != null && NumericalConstants.isValidValue((double)(override = pairedDepth.getYOrdinate(depth)))) {
            retval = new WQInitialCondition(constituentId);
            retval.setOverride(override);
        }
        return retval;
    }

    public void addCondition(SubDomainRef element, Double depth, InitialCondition ic) {
        int constituentId = ic.getConstituentId();
        WQMap locMap = this._reservoirSourcesMap.computeIfAbsent(constituentId, v -> new WQMap());
        InitialConditionsSourceSelection sourceSelection = locMap.computeIfAbsent(element, v -> new InitialConditionsSourceSelection());
        Data selectedSource = sourceSelection.putAndSelectIfInvalidSelection(PairedData::new, "Paired Data");
        PairedDepth pairedDepth = this.getPairedDepth(selectedSource, true, element.getId(), ic.getConstituentId());
        if (pairedDepth != null) {
            pairedDepth.addCondition(depth, ic);
        }
    }

    public void removeCondition(SubDomainRef element, Double depth, int constituentId) {
        InitialConditionsSourceSelection<Data> sourceSelection;
        PairedDepth pairedDepth;
        WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> locMap = this._reservoirSourcesMap.get(constituentId);
        if (locMap != null && (pairedDepth = this.getPairedDepth((sourceSelection = locMap.get(element)).getSelected(), true, element.getId(), constituentId)) != null) {
            pairedDepth.removeCondition(depth);
        }
    }

    private PairedDepth getPairedDepth(Data selectedSource, boolean shouldWarn, int subDomainId, int constituentId) {
        PairedDepth pairedDepth = null;
        if (this._dataProvider != null) {
            PairedDataContainer pdc = this._dataProvider.getDataValues(selectedSource, subDomainId, constituentId);
            int curve = this._dataProvider.getCurve(selectedSource, null, subDomainId, constituentId);
            pairedDepth = new PairedDepth(pdc, curve);
        } else if (selectedSource instanceof PairedData) {
            PairedData source = (PairedData)selectedSource;
            PairedDataContainer pairedDataContainer = source.getPairedDataContainer();
            pairedDepth = new PairedDepth(pairedDataContainer);
        } else {
            Object msg = "Data was null";
            if (selectedSource != null) {
                msg = "Unhandled Data type:" + selectedSource.getClass().getName();
            }
            if (shouldWarn) {
                ((FluentLogger.Api)logger.atWarning()).log((String)msg);
            } else {
                ((FluentLogger.Api)logger.atFine()).log((String)msg);
            }
        }
        return pairedDepth;
    }

    private PairedDepth getPairedDepth(Data selectedSource, boolean shouldWarn, String locationName, String constituentName) {
        PairedDepth pairedDepth = null;
        if (this._dataProvider != null) {
            PairedDataContainer pdc = this._dataProvider.getDataValues(selectedSource, locationName, constituentName);
            int curve = this._dataProvider.getCurve(selectedSource, null, locationName, constituentName);
            pairedDepth = new PairedDepth(pdc, curve);
        } else if (selectedSource instanceof PairedData) {
            PairedData source = (PairedData)selectedSource;
            PairedDataContainer pairedDataContainer = source.getPairedDataContainer();
            pairedDepth = new PairedDepth(pairedDataContainer);
        } else {
            Object msg = "Data was null";
            if (selectedSource != null) {
                msg = "Unhandled Data type:" + selectedSource.getClass().getName();
            }
            if (shouldWarn) {
                ((FluentLogger.Api)logger.atWarning()).log((String)msg);
            } else {
                ((FluentLogger.Api)logger.atFine()).log((String)msg);
            }
        }
        return pairedDepth;
    }

    public InitialCondition getCondition(SubDomainBoundaryRef junc, int constituentId) {
        InitialCondition retval = null;
        WQMap<SubDomainBoundaryRef, InitialCondition> selectionMap = this._junctionConditionMap.get(constituentId);
        if (selectionMap != null) {
            retval = selectionMap.get(junc);
        }
        return retval;
    }

    public void addCondition(SubDomainBoundaryRef junc, InitialCondition ic) {
        WQMap map = this._junctionConditionMap.computeIfAbsent(ic.getConstituentId(), v -> new WQMap());
        map.put(junc, ic);
    }

    public void removeCondition(SubDomainBoundaryRef junc, int constituentId) {
        WQMap<SubDomainBoundaryRef, InitialCondition> map = this._junctionConditionMap.get(constituentId);
        if (map != null) {
            map.remove(junc);
        }
    }

    public void clearConditions(SubDomainRef element, Double depth) {
        for (Integer constituentId : this._reservoirSourcesMap.keySet()) {
            Data selectedSource;
            PairedDepth pairedDepth;
            InitialConditionsSourceSelection<Data> sourceSelection;
            WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> locMap = this._reservoirSourcesMap.get(constituentId);
            if (locMap == null || (sourceSelection = locMap.get(element)) == null || (pairedDepth = this.getPairedDepth(selectedSource = sourceSelection.getSelected(), true, element.getId(), constituentId)) == null) continue;
            pairedDepth.removeCondition(depth);
        }
    }

    public void clearConditions(SubDomainRef element) {
        for (Integer constituentId : this._reservoirSourcesMap.keySet()) {
            WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> locMap = this._reservoirSourcesMap.get(constituentId);
            if (locMap == null) continue;
            locMap.remove(element);
        }
    }

    @JsonIgnore
    public Set<SubDomainRef> getSubDomainRefs() {
        LinkedHashSet<SubDomainRef> retval = new LinkedHashSet<SubDomainRef>();
        for (Integer constituentId : this._reservoirSourcesMap.keySet()) {
            WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> selectionMap = this._reservoirSourcesMap.get(constituentId);
            if (selectionMap == null) continue;
            retval.addAll(selectionMap.keySet());
        }
        return retval;
    }

    @JsonIgnore
    public Set<SubDomainBoundaryRef> getSubDomainBoundaryRefs() {
        LinkedHashSet<SubDomainBoundaryRef> retval = new LinkedHashSet<SubDomainBoundaryRef>();
        for (Integer constituentId : this._junctionConditionMap.keySet()) {
            WQMap<SubDomainBoundaryRef, InitialCondition> map = this._junctionConditionMap.get(constituentId);
            if (map == null) continue;
            retval.addAll(map.keySet());
        }
        return retval;
    }

    public Set<Double> getDepths(SubDomain element) {
        return this.getDepths(element.getRef());
    }

    public Collection<InitialCondition> getConditions(SubDomain element, Double depth) {
        return this.getConditions(element.getRef(), depth);
    }

    public void clear() {
        this.clearBoundaryConditions();
        this.clearSubDomainConditions();
    }

    public void clearBoundaryConditions() {
        this._junctionConditionMap.clear();
    }

    public void clearSubDomainConditions() {
        this._reservoirSourcesMap.clear();
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public WQMap<Integer, WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>>> getReservoirSourcesMap() {
        return this._reservoirSourcesMap;
    }

    public WQMap<Integer, WQMap<SubDomainBoundaryRef, InitialCondition>> getJunctionConditionMap() {
        return this._junctionConditionMap;
    }

    public void setReservoirSourcesMap(WQMap<Integer, WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>>> reservoirSourcesMap) {
        this._reservoirSourcesMap.clear();
        if (reservoirSourcesMap != null) {
            this._reservoirSourcesMap.putAll(reservoirSourcesMap);
        }
    }

    public void setJunctionConditionMap(WQMap<Integer, WQMap<SubDomainBoundaryRef, InitialCondition>> junctionConditionMap) {
        this._junctionConditionMap.clear();
        if (junctionConditionMap != null) {
            this._junctionConditionMap.putAll(junctionConditionMap);
        }
    }

    @JsonIgnore
    public void setInterpolatedJunctionICMap(Map<Integer, Map<SubDomainBoundaryRef, InterpICValue>> interpolatedJunctionICMap) {
        this._interpolatedJunctionICMap = interpolatedJunctionICMap;
    }

    @JsonIgnore
    public boolean hasInterpolatedJunctionICMap() {
        return this._interpolatedJunctionICMap != null && !this._interpolatedJunctionICMap.isEmpty();
    }

    @JsonIgnore
    public InterpICValue getInterpolatedIC(Integer constitId, SubDomainBoundaryRef sdRef) {
        Map<SubDomainBoundaryRef, InterpICValue> map;
        if (this._interpolatedJunctionICMap != null && (map = this._interpolatedJunctionICMap.get(constitId)) != null) {
            return map.get(sdRef);
        }
        return null;
    }

    public WQConsistencyCheck checkConsistency(Geometry wqGeo, ConstituentSet constitSet) {
        WQInitialConditionSetChecker checker = new WQInitialConditionSetChecker(this);
        return checker.checkConsistency(wqGeo, constitSet);
    }

    public String getIConditionDataType(int constituentId, SubDomainRef subDomainRef) {
        Data data;
        InitialConditionsSourceSelection<Data> selection;
        WQMap<SubDomainRef, InitialConditionsSourceSelection<Data>> selectionMap = this._reservoirSourcesMap.get(constituentId);
        if (selectionMap != null && (selection = selectionMap.get(subDomainRef)) != null && (data = selection.getSelected()) != null) {
            return data.getType();
        }
        return null;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQInitialConditionSet2.class);
        }
    }
}

