/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.initialCondition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.InitialCondition;
import hec.wqenginecore.InitialConditionSet;
import hec.wqenginecore.InterpICValue;
import hec.wqenginecore.InterpolationType;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.BoundaryType;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainBoundary;
import hec.wqenginecore.geometry.SubDomainBoundaryRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqengineimpl.initialCondition.InitialConditionsSourceSelection;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class WQInitialConditionSetChecker {
    private final InitialConditionSet _ics;

    public WQInitialConditionSetChecker(InitialConditionSet ics) {
        this._ics = ics;
    }

    public WQConsistencyCheck checkConsistency(Geometry wqGeo, ConstituentSet constitSet) {
        String datasetName = "Water Quality Initial Condition Set: " + this._ics.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        if (wqGeo == null) {
            consistencyCheck.addErrorMessage("Missing dependent Water Quality Geometry");
            return consistencyCheck;
        }
        if (constitSet == null) {
            consistencyCheck.addErrorMessage("Missing dependent Constituent Set");
            return consistencyCheck;
        }
        this.checkInterpolationOptions(consistencyCheck);
        this.checkReservoirData(consistencyCheck, wqGeo, constitSet);
        this.checkJunctionData(consistencyCheck, wqGeo, constitSet);
        return consistencyCheck;
    }

    private void checkInterpolationOptions(WQConsistencyCheck consistencyCheck) {
        String errorMessage;
        if (this._ics.getReservoirInterpolationType() == InterpolationType.LAPLACE) {
            errorMessage = "Reservoir Interpolation Type: Laplace Solution not supported yet";
            consistencyCheck.addErrorMessage(errorMessage);
        }
        if (this._ics.getReservoirInterpolationType() == InterpolationType.LAPLACE) {
            errorMessage = "River Interpolation Type: Laplace Solution not supported yet";
            consistencyCheck.addErrorMessage(errorMessage);
        }
    }

    private void checkReservoirData(WQConsistencyCheck consistencyCheck, Geometry wqGeo, ConstituentSet constitSet) {
        List subDoms = wqGeo.getSubDomainsInExtent();
        Collection constits = constitSet.getConstituentList();
        for (SubDomain sd : subDoms) {
            if (sd.getType() != SubDomainType.RESERVOIR_1DV) continue;
            SubDomainRef ref = sd.getRef();
            Set depths = this._ics.getDepths(ref);
            for (Constituent constit : constits) {
                String dataType = this._ics.getIConditionDataType(constit.getId(), ref);
                if (!"DSSData".equals(dataType)) {
                    this.checkReservoirConstituentData(consistencyCheck, sd, constit, depths, ref);
                    continue;
                }
                this.checkDSSReservoirConstituentData(consistencyCheck, sd, constit, ref);
            }
        }
    }

    private void checkReservoirConstituentData(WQConsistencyCheck consistencyCheck, SubDomain sd, Constituent constit, Set<Double> depths, SubDomainRef ref) {
        boolean hasValidVal = false;
        for (Double depth : depths) {
            InitialCondition ic = this._ics.getCondition(ref, depth, constit.getId());
            if (ic == null || ic.getOverride() == null || !(ic.getOverride() >= 0.0)) continue;
            hasValidVal = true;
            break;
        }
        if (!hasValidVal) {
            String errorMessage = "Reservoir: " + sd.getName() + " has no valid initial condition defined for Constituent: " + constit.getDisplayName();
            consistencyCheck.addErrorMessage(errorMessage);
        }
    }

    private void checkDSSReservoirConstituentData(WQConsistencyCheck consistencyCheck, SubDomain sd, Constituent constit, SubDomainRef ref) {
        WQInitialConditionSet2 ics2 = (WQInitialConditionSet2)this._ics;
        InitialConditionsSourceSelection<Data> sourceSelection = ics2.getSourceSelection(constit.getId(), ref);
        if (sourceSelection != null && sourceSelection.containsKey("DSS")) {
            Data dssData = sourceSelection.get("DSS");
            if (dssData != null && dssData.getType().equals("DSSData")) {
                String errorMessage;
                DssData dss = (DssData)dssData;
                if (dss.getDssPath() == null || dss.getDssPath().trim().isEmpty()) {
                    errorMessage = "Reservoir: " + sd.getName() + " has no valid initial condition defined for Constituent: " + constit.getDisplayName();
                    consistencyCheck.addErrorMessage(errorMessage);
                }
                if (dss.getDssFilePath() == null || dss.getDssFilePath().trim().isEmpty()) {
                    errorMessage = "Reservoir: " + sd.getName() + " has no valid initial condition defined for Constituent: " + constit.getDisplayName();
                    consistencyCheck.addErrorMessage(errorMessage);
                }
            } else {
                String errorMessage = "Reservoir: " + sd.getName() + " has no valid initial condition defined for Constituent: " + constit.getDisplayName();
                consistencyCheck.addErrorMessage(errorMessage);
            }
        } else {
            String errorMessage = "Reservoir: " + sd.getName() + " has no valid initial condition defined for Constituent: " + constit.getDisplayName();
            consistencyCheck.addErrorMessage(errorMessage);
        }
    }

    private void checkReachData(WQConsistencyCheck consistencyCheck, Geometry wqGeo, ConstituentSet constitSet) {
        List<List<SubDomainBoundary>> boundaryGroups = this.createReachBoundaryGroupings(wqGeo);
        Collection constituentList = constitSet.getConstituentList();
        for (Constituent constit : constituentList) {
            for (List<SubDomainBoundary> boundaryGroup : boundaryGroups) {
                this.checkReachBoundaryGroupData(consistencyCheck, constit, boundaryGroup);
            }
        }
    }

    private void checkReachBoundaryGroupData(WQConsistencyCheck consistencyCheck, Constituent constit, List<SubDomainBoundary> boundaryGroup) {
        boolean hasValidVal = false;
        for (SubDomainBoundary sdb : boundaryGroup) {
            SubDomainBoundaryRef sdbRef = sdb.getRef();
            Collection ics = this._ics.getConditions(sdbRef);
            for (InitialCondition ic : ics) {
                if (ic.getConstituentId() != constit.getId()) continue;
                InterpICValue interpValue = this._ics.getInterpolatedIC(Integer.valueOf(constit.getId()), sdbRef);
                if (interpValue != null && interpValue.getValue() != null && interpValue.getValue() >= 0.0) {
                    hasValidVal = true;
                    break;
                }
                if (ic.getOverride() == null || !(ic.getOverride() >= 0.0)) continue;
                hasValidVal = true;
                break;
            }
            if (!hasValidVal) continue;
            break;
        }
        if (!hasValidVal) {
            String errorMessage = "Junction Group including " + boundaryGroup.get(0).getName() + " has no valid initial conditions defined for Constituent: " + constit.getDisplayName();
            consistencyCheck.addErrorMessage(errorMessage);
        }
    }

    @JsonIgnore
    private void checkJunctionData(WQConsistencyCheck consistencyCheck, Geometry wqGeo, ConstituentSet constitSet) {
        Set sdbRefs = this._ics.getSubDomainBoundaryRefs();
        List sdBounds = wqGeo.getBoundariesInExtent();
        Collection constits = constitSet.getConstituentList();
        boolean hasInterpVals = this._ics.hasInterpolatedJunctionICMap();
        for (SubDomainBoundaryRef sdbr : sdbRefs) {
            for (Constituent constit : constits) {
                boolean hasValidVal = false;
                InitialCondition ic = this._ics.getCondition(sdbr, constit.getId());
                if (hasInterpVals) {
                    InterpICValue interpValue = this._ics.getInterpolatedIC(Integer.valueOf(constit.getId()), sdbr);
                    if (interpValue != null && interpValue.getValue() != null && interpValue.getValue() >= 0.0) {
                        hasValidVal = true;
                    }
                } else {
                    hasValidVal = true;
                }
                if (ic.getOverride() != null && ic.getOverride() >= 0.0) {
                    hasValidVal = true;
                }
                if (hasValidVal) continue;
                SubDomainBoundary sdb = sdBounds.stream().filter(b -> b.getRef().equals(sdbr)).findFirst().orElse(null);
                String errorMessage = "Junction: " + sdb + " has no valid initial condition defined for Constituent: " + constit.getDisplayName();
                consistencyCheck.addErrorMessage(errorMessage);
            }
        }
    }

    @JsonIgnore
    private List<List<SubDomainBoundary>> createReachBoundaryGroupings(Geometry geo) {
        List subDomains = geo.getSubDomainsInExtent();
        List sdBounds = geo.getBoundariesInExtent();
        ArrayList<List<SubDomainBoundary>> groupings = new ArrayList<List<SubDomainBoundary>>();
        ArrayList<BoundaryType> checkTheseBoundaries = new ArrayList<BoundaryType>();
        checkTheseBoundaries.add(BoundaryType.RIVER_INFLOW);
        checkTheseBoundaries.add(BoundaryType.RIVER_INFLOW_IN_NETWORK);
        checkTheseBoundaries.add(BoundaryType.RESERVOIR_2_RIVER);
        for (SubDomainBoundary sdBound : sdBounds) {
            if (!checkTheseBoundaries.contains(sdBound.getBoundaryType())) continue;
            List<SubDomain> sdGrouping = this.createSubdomainGrouping(sdBound, subDomains, sdBounds);
            List<SubDomainBoundary> sdbGroupBounds = this.getGroupBounds(sdGrouping, sdBounds);
            boolean addGroup = true;
            for (List list : groupings) {
                if (!sdbGroupBounds.contains(list.get(0))) continue;
                addGroup = false;
                break;
            }
            if (!addGroup) continue;
            groupings.add(sdbGroupBounds);
        }
        return groupings;
    }

    private List<SubDomainBoundary> getGroupBounds(List<SubDomain> groupSDs, List<SubDomainBoundary> allSDBList) {
        ArrayList<SubDomainBoundary> outputSDBList = new ArrayList<SubDomainBoundary>();
        for (SubDomainBoundary sdb : allSDBList) {
            int usId = sdb.getUpstreamSubDomainId();
            int dsId = sdb.getDownstreamSubDomainId();
            for (SubDomain sd : groupSDs) {
                int sdId = sd.getId();
                if (usId != sdId && dsId != sdId || outputSDBList.contains(sdb) || sdb.isLocal()) continue;
                outputSDBList.add(sdb);
            }
        }
        return outputSDBList;
    }

    private List<SubDomain> createSubdomainGrouping(SubDomainBoundary sdBound, List<SubDomain> subDomains, List<SubDomainBoundary> sdBounds) {
        ArrayList<SubDomain> sdGrouping = new ArrayList<SubDomain>();
        List<SubDomainBoundary> activeBounds = new ArrayList<SubDomainBoundary>();
        ArrayList<SubDomainBoundary> usedBounds = new ArrayList<SubDomainBoundary>();
        activeBounds.add(sdBound);
        usedBounds.add(sdBound);
        boolean foundNewSD = true;
        while (foundNewSD) {
            if (!(activeBounds = this.addConnectedSubDomains(activeBounds, usedBounds, sdGrouping, subDomains, sdBounds)).isEmpty()) continue;
            foundNewSD = false;
        }
        return sdGrouping;
    }

    private List<SubDomainBoundary> addConnectedSubDomains(List<SubDomainBoundary> activeSdbList, List<SubDomainBoundary> usedSdbList, List<SubDomain> groupSDList, List<SubDomain> allSDList, List<SubDomainBoundary> allSDBList) {
        ArrayList<Integer> inputSdbIdList = new ArrayList<Integer>();
        ArrayList<SubDomainBoundary> outputSdbList = new ArrayList<SubDomainBoundary>(activeSdbList);
        for (SubDomainBoundary sdbound : activeSdbList) {
            int sdbJnctId = sdbound.getJnctId();
            inputSdbIdList.add(sdbound.getId());
            for (SubDomain sd : allSDList) {
                List usJnctIds = sd.getUpstreamElemIds();
                List dsJnctIds = sd.getDownstreamElemIds();
                if (!usJnctIds.contains(sdbJnctId) && !dsJnctIds.contains(sdbJnctId) || groupSDList.contains(sd)) continue;
                if (sd.getType() != SubDomainType.RESERVOIR_1DV) {
                    groupSDList.add(sd);
                }
                for (SubDomainBoundary sdb : allSDBList) {
                    boolean inList;
                    int usId = sdb.getUpstreamSubDomainId();
                    int dsId = sdb.getDownstreamSubDomainId();
                    boolean usesSD = usId == sd.getId() || dsId == sd.getId();
                    boolean bl = inList = outputSdbList.contains(sdb) || usedSdbList.contains(sdb);
                    if (!usesSD || inList || sdb.getBoundaryType() != BoundaryType.RIVER_2_RIVER) continue;
                    outputSdbList.add(sdb);
                    usedSdbList.add(sdb);
                }
            }
        }
        ArrayList<SubDomainBoundary> outputSdbList2 = new ArrayList<SubDomainBoundary>(outputSdbList);
        for (Integer sdbId : inputSdbIdList) {
            for (SubDomainBoundary sdb : outputSdbList) {
                if (sdb.getId() != sdbId.intValue()) continue;
                outputSdbList2.remove(sdb);
            }
        }
        return outputSdbList2;
    }
}

