/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.initialCondition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.SimpleInitialCondition;
import hec.wqenginecore.SimpleInitialConditionSet;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.initialCondition.WQInitialConditionSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQSimpleInitialConditionSet
implements SimpleInitialConditionSet {
    private String _name = "";
    private String _description = "";
    @JsonIgnore
    private Map<Integer, Map<Integer, SimpleInitialCondition>> _conditionsMap = new LinkedHashMap<Integer, Map<Integer, SimpleInitialCondition>>();

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Collection<SimpleInitialCondition> getConditions() {
        return this._conditionsMap.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<SimpleInitialCondition> getConditions(int subDomainId) {
        return this._conditionsMap.get(subDomainId).values().stream().collect(Collectors.toSet());
    }

    public SimpleInitialCondition getCondition(int subDomainId, Constituent constit) {
        Map<Integer, SimpleInitialCondition> sdMap = this._conditionsMap.get(subDomainId);
        if (sdMap != null) {
            return sdMap.get(constit.getId());
        }
        return null;
    }

    public void addCondition(int subDomainId, Constituent constit, SimpleInitialCondition ic) {
        if (this._conditionsMap == null) {
            this._conditionsMap = new HashMap<Integer, Map<Integer, SimpleInitialCondition>>();
        }
        Map map = this._conditionsMap.computeIfAbsent(subDomainId, v -> new HashMap());
        map.put(constit.getId(), ic);
    }

    public void clearConditions() {
        this._conditionsMap.clear();
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQInitialConditionSet.class);
        }
    }
}

