/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.libraries;

import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.libraries.AbstractWQLibrary;
import hec.wqenginecore.parameter.Parameter;
import hec.wqenginecore.parameter.ParameterOption;
import hec.wqengineimpl.WQConstituent;
import hec.wqengineimpl.libraries.BufferedReaderIterator;
import hec.wqengineimpl.libraries.FilteringIterator;
import hec.wqengineimpl.libraries.IdExpression;
import hec.wqengineimpl.parameter.WQParameter;
import hec.wqengineimpl.parameter.WQParameterOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class BaseWQLibrary
extends AbstractWQLibrary {
    public static final Logger logger = Logger.getLogger(BaseWQLibrary.class.getName());
    public static final String SPACES = "\\s*";
    public static final String SEP = ",\\s*";
    public static final String DOUBLE_REGEX = "[+-]?((\\d+\\.?\\d*)|(\\.\\d+))";
    public static final String NAMED_REGEX_PATTERN = "(?<%s>%s)";
    protected Map<Integer, WQConstituent> constituents = new LinkedHashMap<Integer, WQConstituent>();
    protected Map<Integer, WQParameter> parameters = new LinkedHashMap<Integer, WQParameter>();
    protected Map<IdExpression, Set<Integer>> paramDepExpr = new LinkedHashMap<IdExpression, Set<Integer>>();
    protected Map<Integer, WQParameterOption> options = new LinkedHashMap<Integer, WQParameterOption>();
    protected Map<IdExpression, Set<Integer>> paramOptDepExpr = new LinkedHashMap<IdExpression, Set<Integer>>();
    protected Map<Integer, Set<Integer>> dependencies = new LinkedHashMap<Integer, Set<Integer>>();
    protected Map<Integer, String> groupNames = new LinkedHashMap<Integer, String>();

    public BaseWQLibrary(String aName, String aDescription, String aDisplayName) {
        super(aName, aDescription, aDisplayName);
    }

    public Set<Constituent> listConstituents() {
        return Collections.unmodifiableSet(new LinkedHashSet<WQConstituent>(this.constituents.values()));
    }

    public static boolean isComment(String line) {
        boolean retval = true;
        if (line != null && !line.trim().isEmpty()) {
            retval = line.startsWith("**");
        }
        return retval;
    }

    public void build() {
        InputStream stream = this.getInputStream();
        this.build(stream);
    }

    public void build(InputStream stream) {
        if (stream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                BufferedReaderIterator iter = new BufferedReaderIterator(reader);
                FilteringIterator<String> stIter = new FilteringIterator<String>(iter.iterator(), s -> !BaseWQLibrary.isComment(s));
                this.buildConstituents(stIter);
                this.buildGroups(stIter);
                this.buildParameters(stIter);
                this.buildParameterOptions(stIter);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unexpected Exception", e);
            }
        }
    }

    protected void buildConstituents(Iterator<String> stIter) {
        int numConstituents = this.getNextInt(stIter);
        for (int i = 0; i < numConstituents; ++i) {
            List<WQConstituent> cons = this.buildConstituent(stIter);
            if (cons == null || cons.isEmpty()) continue;
            for (WQConstituent con : cons) {
                this.constituents.put(con.getId(), con);
            }
        }
    }

    protected void buildGroups(Iterator<String> stIter) {
        int numGroups = this.getNextInt(stIter);
        for (int i = 0; i < numGroups; ++i) {
            if (!stIter.hasNext()) continue;
            String nextLine = stIter.next();
            this.addGroup(nextLine);
        }
    }

    protected void buildParameters(Iterator<String> stIter) {
        int numParameter = this.getNextInt(stIter);
        for (int i = 0; i < numParameter; ++i) {
            if (!stIter.hasNext()) continue;
            String nextLine = stIter.next();
            this.addParameters(nextLine);
        }
    }

    protected void buildParameterOptions(Iterator<String> stIter) {
        int numParamOptions = this.getNextInt(stIter);
        for (int i = 0; i < numParamOptions; ++i) {
            if (!stIter.hasNext()) continue;
            this.addParamOptions(stIter.next());
        }
    }

    private void addGroup(String line) {
        String[] parts = line.split(SEP);
        int id = Integer.parseInt(parts[0].trim());
        String gname = parts[2].trim();
        this.groupNames.put(id, gname);
    }

    protected InputStream getInputStream(String resourceName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
    }

    private void addParamOptions(String line) {
        String regex = this.getParamOptionRegex();
        Matcher m = Pattern.compile(regex).matcher(line);
        boolean matches = m.matches();
        if (matches) {
            int id = Integer.parseInt(m.group(ParamOptionPart.ID.name()).trim());
            String sname = m.group(ParamOptionPart.SNAME.name()).trim();
            String lname = m.group(ParamOptionPart.LNAME.name()).trim();
            String cidPart = m.group(ParamOptionPart.CID.name());
            String optIdNames = m.group(ParamOptionPart.OPT.name());
            Map<Integer, String> option = this.getOptions(optIdNames);
            int defaultOption = Integer.parseInt(m.group(ParamOptionPart.DEF.name()).trim());
            int groupId = Integer.parseInt(m.group(ParamOptionPart.GID.name()).trim());
            IdExpression expr = new IdExpression(cidPart);
            Set optionSet = this.paramOptDepExpr.computeIfAbsent(expr, v -> new LinkedHashSet());
            WQParameterOption po = new WQParameterOption(id, sname, lname, option, defaultOption);
            po.setGroupId(groupId);
            this.options.put(po.getId(), po);
            optionSet.add(po.getId());
        } else {
            logger.warning("While parsing param file for library " + this.getName() + " ParameterOption line did not match expected pattern:" + line);
        }
    }

    private String getOptionRegex() {
        return "(\\s*,?\\s*\\{\\s*" + OptionPart.ID.getNamedRegex() + SEP + OptionPart.DESC.getNamedRegex() + "\\})";
    }

    Map<Integer, String> getOptions(String param) {
        LinkedHashMap<Integer, String> option = new LinkedHashMap<Integer, String>();
        if (param != null) {
            Matcher m = Pattern.compile(this.getOptionRegex()).matcher(param);
            while (m.find()) {
                String id = m.group(OptionPart.ID.name());
                String desc = m.group(OptionPart.DESC.name());
                option.put(Integer.parseInt(id.trim()), desc.trim());
            }
        }
        return option;
    }

    private void addParameters(String line) {
        String regex = this.getParameterRegex();
        Matcher m = Pattern.compile(regex).matcher(line);
        boolean matches = m.matches();
        if (matches) {
            int id = Integer.parseInt(m.group(ParameterPart.ID.name()).trim());
            String sname = m.group(ParameterPart.SNAME.name()).trim();
            String lname = m.group(ParameterPart.LNAME.name()).trim();
            String symbol = m.group(ParameterPart.SYM.name()).trim();
            String units = StringEscapeUtils.unescapeJava((String)m.group(ParameterPart.UNITS.name()).trim());
            Double defaultValue = this.getDoubleValue(m.group(ParameterPart.DVAL.name()));
            Double normalMin = this.getDoubleValue(m.group(ParameterPart.NMIN.name()));
            Double normalMax = this.getDoubleValue(m.group(ParameterPart.NMAX.name()));
            Double absMin = this.getDoubleValue(m.group(ParameterPart.ABSMIN.name()));
            Double absMax = this.getDoubleValue(m.group(ParameterPart.ABSMAX.name()));
            Double dTheta = this.getDoubleValue(m.group(ParameterPart.DEFTHETA.name()));
            String consIdStr = m.group(ParameterPart.DEP.name());
            int groupId = Integer.parseInt(m.group(ParameterPart.GROUPID.name()).trim());
            IdExpression expr = new IdExpression(consIdStr);
            Set optionSet = this.paramDepExpr.computeIfAbsent(expr, v -> new LinkedHashSet());
            WQParameter param = new WQParameter(id);
            param.setName(sname);
            param.setDescription(lname);
            param.setSymbol(symbol);
            param.setUnits(units);
            param.setDefaultValue(defaultValue);
            param.setNormalMin(normalMin);
            param.setNormalMax(normalMax);
            param.setAbsMin(absMin);
            param.setAbsMax(absMax);
            param.setDefaultTheta(dTheta);
            param.setGroupId(groupId);
            this.parameters.put(param.getId(), param);
            optionSet.add(param.getId());
        } else {
            logger.warning("While parsing param file for library " + this.getName() + " Parameter line did not match expected pattern:" + line);
        }
    }

    public String getParameterGroupName(Integer groupId) {
        return this.groupNames.get(groupId);
    }

    public Set<Integer> getParameterGroupIds() {
        return this.groupNames.keySet();
    }

    private String getParameterRegex() {
        StringBuilder sb = new StringBuilder(SPACES);
        sb.append(Arrays.stream(ParameterPart.getParts()).map(ParameterPart::getNamedRegex).collect(Collectors.joining(SEP)));
        return sb.toString();
    }

    private String getParamOptionRegex() {
        return SPACES + Arrays.stream(ParamOptionPart.getParts()).map(ParamOptionPart::getNamedRegex).collect(Collectors.joining(SEP));
    }

    private Double getDoubleValue(String part) {
        Double retval = Double.NEGATIVE_INFINITY;
        if (part != null) {
            retval = Double.parseDouble(part.trim());
        }
        return retval;
    }

    private List<WQConstituent> buildConstituent(Iterator<String> stIter) {
        if (stIter.hasNext()) {
            return this.buildConstituent(stIter.next());
        }
        return Collections.emptyList();
    }

    private List<WQConstituent> buildConstituent(String line) {
        ArrayList<WQConstituent> retval = new ArrayList<WQConstituent>();
        String regex = this.getConstituentRegex();
        Matcher m = Pattern.compile(regex).matcher(line);
        boolean matches = m.matches();
        if (matches) {
            int id = Integer.parseInt(m.group(ConstituentPart.ID.name()));
            String shortName = m.group(ConstituentPart.SNAME.name()).trim();
            String cname = m.group(ConstituentPart.NAME.name()).trim();
            String units = StringEscapeUtils.unescapeJava((String)m.group(ConstituentPart.UNITS.name()).trim());
            String symbol = m.group(ConstituentPart.SYM.name()).trim();
            String depcontents = m.group(ConstituentPart.DEP.name());
            Set<Integer> deps = this.asIntSet(depcontents);
            Boolean advected = "T".equals(m.group(ConstituentPart.ADVECTED.name()));
            Boolean injected = "T".equals(m.group(ConstituentPart.INJECTED.name()));
            Boolean evaporated = "T".equals(m.group(ConstituentPart.EVAPORATED.name()));
            this.dependencies.put(id, deps);
            WQConstituent wqc = new WQConstituent(id, shortName, cname, units, this.getName());
            wqc.setIsAdvected(advected);
            wqc.setIsInjected(injected);
            wqc.setIsEvaporated(evaporated);
            retval.add(wqc);
        } else {
            logger.warning("While parsing param file for library " + this.getName() + " Constituent line did not match expected pattern:" + line);
        }
        return retval;
    }

    private String getConstituentRegex() {
        StringBuilder sb = new StringBuilder(SPACES);
        sb.append(Arrays.stream(ConstituentPart.getParts()).map(ConstituentPart::getNamedRegex).collect(Collectors.joining(SEP)));
        return sb.toString();
    }

    private Set<Integer> asIntSet(String depcontents) {
        LinkedHashSet<Integer> deps = new LinkedHashSet<Integer>();
        while (depcontents != null && !depcontents.isEmpty() && depcontents.startsWith("{") && depcontents.endsWith("}")) {
            depcontents = depcontents.substring(1, depcontents.length() - 1);
        }
        if (depcontents != null && !depcontents.isEmpty()) {
            String[] parts;
            for (String part : parts = depcontents.split(SEP)) {
                int dep = Integer.parseInt(part);
                deps.add(dep);
            }
        }
        return deps;
    }

    private int getNextInt(Iterator<String> lines) {
        int retval = 0;
        if (lines.hasNext()) {
            String next = lines.next();
            retval = Integer.parseInt(next.trim());
        }
        return retval;
    }

    public Collection<Constituent> addRequired(Collection<Constituent> input) {
        LinkedHashSet<Constituent> retval = new LinkedHashSet<Constituent>();
        if (input != null && !input.isEmpty()) {
            retval.addAll(input);
            Set<Integer> selectedIds = input.stream().map(Constituent::getId).collect(Collectors.toSet());
            Set<Integer> missingIds = this.findMissing(selectedIds);
            if (missingIds != null) {
                for (Integer id : missingIds) {
                    WQConstituent wqConstituent = this.constituents.get(id);
                    if (wqConstituent == null) continue;
                    retval.add(wqConstituent);
                }
            }
        }
        return retval;
    }

    protected Set<Integer> findMissing(Set<Integer> selectedIds) {
        int pre = selectedIds.size();
        Set<Integer> expanded = this.expand(selectedIds);
        while (expanded.size() - pre > 0) {
            pre = expanded.size();
            expanded = this.expand(expanded);
        }
        LinkedHashSet<Integer> missing = new LinkedHashSet<Integer>(expanded);
        missing.removeAll(selectedIds);
        return missing;
    }

    private Set<Integer> expand(Set<Integer> selectedIds) {
        LinkedHashSet<Integer> expanded = new LinkedHashSet<Integer>(selectedIds);
        for (Integer selectedId : selectedIds) {
            Set<Integer> needed = this.dependencies.get(selectedId);
            if (needed == null || needed.isEmpty()) continue;
            expanded.addAll(needed);
        }
        return expanded;
    }

    public Set<Parameter> getParameters(ConstituentSet cset) {
        Set<Parameter> retval = Collections.emptySet();
        if (cset != null) {
            retval = this.getParameters(cset.getConstituentList());
        }
        return retval;
    }

    public Set<Parameter> getParameters(Collection<Constituent> constituentList) {
        LinkedHashSet<Parameter> retval = new LinkedHashSet<Parameter>();
        List<Integer> ids = this.getConstituentIds(constituentList);
        Set<Integer> parameterIds = this.getParameterIds(ids);
        for (Integer parameterId : parameterIds) {
            WQParameter parameter = this.parameters.get(parameterId);
            retval.add(parameter);
        }
        return retval;
    }

    private Set<Integer> getParameterIds(List<Integer> constituentIds) {
        TreeSet<Integer> parameterIds = new TreeSet<Integer>();
        for (Map.Entry<IdExpression, Set<Integer>> entry : this.paramDepExpr.entrySet()) {
            IdExpression expr = entry.getKey();
            if (!expr.test((Collection<Integer>)constituentIds)) continue;
            Set<Integer> matchingIds = entry.getValue();
            parameterIds.addAll(matchingIds);
        }
        return parameterIds;
    }

    private List<Integer> getConstituentIds(ConstituentSet cset) {
        List<Integer> retval = Collections.emptyList();
        if (cset != null) {
            retval = this.getConstituentIds(cset.getConstituentList());
        }
        return retval;
    }

    public List<Integer> getConstituentIds(Collection<Constituent> constituentList) {
        List<Integer> retval = Collections.emptyList();
        if (constituentList != null && !constituentList.isEmpty()) {
            retval = constituentList.stream().map(Constituent::getId).collect(Collectors.toList());
        }
        return retval;
    }

    public Set<ParameterOption> getParameterOptions(ConstituentSet cset) {
        Set<ParameterOption> retval = Collections.emptySet();
        if (cset != null) {
            retval = this.getParameterOptions(cset.getConstituentList());
        }
        return retval;
    }

    public Set<ParameterOption> getParameterOptions(Collection<Constituent> constituentList) {
        LinkedHashSet<ParameterOption> retval = new LinkedHashSet<ParameterOption>();
        List<Integer> constituentIds = this.getConstituentIds(constituentList);
        Set<Integer> optionIds = this.getParameterOptionIds(constituentIds);
        for (Integer id : optionIds) {
            WQParameterOption wqParameterOption = this.options.get(id);
            retval.add(wqParameterOption);
        }
        return retval;
    }

    private Set<Integer> getParameterOptionIds(List<Integer> constituentIds) {
        TreeSet<Integer> optionIds = new TreeSet<Integer>();
        for (Map.Entry<IdExpression, Set<Integer>> entry : this.paramOptDepExpr.entrySet()) {
            IdExpression expr = entry.getKey();
            if (!expr.test((Collection<Integer>)constituentIds)) continue;
            Set<Integer> matchingIds = entry.getValue();
            optionIds.addAll(matchingIds);
        }
        return optionIds;
    }

    protected InputStream getInputStream() {
        InputStream retval = null;
        String paramPath = this.getUrlSpec();
        if (paramPath == null) {
            String resourceName = this.getResourceName();
            if (resourceName == null) {
                logger.log(Level.INFO, "WQLibrary Implementation " + ((Object)((Object)this)).getClass().getName() + " does not provide a resource name and no URL specification was found.  A parameter file will not be parsed.");
            } else {
                retval = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
            }
        } else {
            try {
                URL url = new URL(paramPath);
                retval = url.openStream();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unexpected Exception", e);
            }
        }
        return retval;
    }

    public String getResourceName() {
        return null;
    }

    public String getUrlSpec() {
        return null;
    }

    public Path getParamFilePath() {
        Path path = null;
        String urlSpec = this.getUrlSpec();
        if (urlSpec != null) {
            try {
                URL url = new URL(urlSpec);
                File file = new File(url.getPath());
                if (file.exists()) {
                    path = Paths.get(file.getAbsolutePath(), new String[0]);
                }
            }
            catch (MalformedURLException e) {
                logger.log(Level.WARNING, "Unexpected Exception", e);
            }
        }
        if (path == null) {
            logger.log(Level.WARNING, "Unable to determine param file path for library " + this.getName());
        }
        return path;
    }

    public static enum ParamOptionPart {
        ID("\\d+"),
        SNAME("[^,]*"),
        LNAME("[^,]*"),
        CID("\\{(\\s*\\d+(,\\s*\\d*)*)\\}"),
        OPT("\\{(\\{\\d+,.+\\},?)*\\}"),
        DEF("\\d+"),
        GID("\\d+");

        public final String pattern;

        private ParamOptionPart(String pattern) {
            this.pattern = pattern;
        }

        public String getNamedRegex() {
            return String.format(BaseWQLibrary.NAMED_REGEX_PATTERN, this.name(), this.pattern);
        }

        public static ParamOptionPart[] getParts() {
            return new ParamOptionPart[]{ID, SNAME, LNAME, CID, OPT, DEF, GID};
        }
    }

    public static enum OptionPart {
        ID("\\d+"),
        DESC("[^\\}]+");

        public final String pattern;

        private OptionPart(String pattern) {
            this.pattern = pattern;
        }

        public String getNamedRegex() {
            return String.format(BaseWQLibrary.NAMED_REGEX_PATTERN, this.name(), this.pattern);
        }
    }

    public static enum ParameterPart {
        ID("\\d+"),
        SNAME("[^,]*"),
        LNAME("[^,]*"),
        SYM(".*"),
        UNITS(".*"),
        DVAL("[+-]?((\\d+\\.?\\d*)|(\\.\\d+))"),
        NMIN("[+-]?((\\d+\\.?\\d*)|(\\.\\d+))"),
        NMAX("[+-]?((\\d+\\.?\\d*)|(\\.\\d+))"),
        ABSMIN("[+-]?((\\d+\\.?\\d*)|(\\.\\d+))"),
        ABSMAX("[+-]?((\\d+\\.?\\d*)|(\\.\\d+))"),
        DEFTHETA("[+-]?((\\d+\\.?\\d*)|(\\.\\d+))"),
        DEP("\\{([\\d\\s\\&\\!\\,\\{\\}]*)\\}"),
        GROUPID("\\d+");

        public final String pattern;

        private ParameterPart(String pattern) {
            this.pattern = pattern;
        }

        public String getNamedRegex() {
            return String.format(BaseWQLibrary.NAMED_REGEX_PATTERN, this.name(), this.pattern);
        }

        public static ParameterPart[] getParts() {
            return new ParameterPart[]{ID, SNAME, LNAME, SYM, UNITS, DVAL, NMIN, NMAX, ABSMIN, ABSMAX, DEFTHETA, DEP, GROUPID};
        }
    }

    public static enum ConstituentPart {
        ID("\\d+"),
        SNAME(".*"),
        NAME(".*"),
        SYM(".*"),
        UNITS(".*"),
        DEP("\\{(\\d+(\\s*,\\d+)*)?\\}"),
        ADVECTED("T|F"),
        INJECTED("T|F"),
        EVAPORATED("T|F");

        public final String pattern;

        private ConstituentPart(String pattern) {
            this.pattern = pattern;
        }

        public String getNamedRegex() {
            return String.format(BaseWQLibrary.NAMED_REGEX_PATTERN, this.name(), this.pattern);
        }

        public static ConstituentPart[] getParts() {
            return new ConstituentPart[]{ID, SNAME, NAME, SYM, UNITS, DEP, ADVECTED, INJECTED, EVAPORATED};
        }
    }
}

