/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.libraries;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Predicate;

public class FilteringIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private final Predicate<T> pred;
    private Queue<T> queue = new ArrayBlockingQueue<T>(1);

    public FilteringIterator(Iterator<T> iter, Predicate<T> pred) {
        this.iter = iter;
        this.pred = pred;
    }

    @Override
    public boolean hasNext() {
        this.fillQueue();
        return !this.queue.isEmpty();
    }

    private void fillQueue() {
        if (this.queue.isEmpty()) {
            try {
                T item = this.next();
                this.queue.add(item);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    @Override
    public T next() {
        if (this.queue.isEmpty()) {
            boolean hasNext = this.iter.hasNext();
            if (!hasNext) {
                throw new NoSuchElementException();
            }
            T next = this.iter.next();
            while (!this.pred.test(next)) {
                if (!this.iter.hasNext()) {
                    throw new NoSuchElementException();
                }
                next = this.iter.next();
            }
            this.queue.add(next);
        }
        return this.queue.remove();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

