/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.libraries;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public class IdExpression
implements Predicate<Collection<Integer>> {
    private String str;
    private int pos = -1;
    private int ch;
    private Predicate<Collection<Integer>> predicate;

    public IdExpression(String input) {
        this.str = input;
        this.predicate = this.parse();
    }

    private void nextChar() {
        this.ch = ++this.pos < this.str.length() ? (int)this.str.charAt(this.pos) : -1;
    }

    private boolean eat(int charToEat) {
        while (this.ch == 32) {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private Predicate<Collection<Integer>> parse() {
        if (this.str == null || this.str.isEmpty()) {
            return integers -> true;
        }
        this.nextChar();
        Predicate<Collection<Integer>> x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new RuntimeException("Unexpected: " + (char)this.ch);
        }
        return x;
    }

    private Predicate<Collection<Integer>> parseExpression() {
        Predicate<Collection<Integer>> x = this.parseTerm();
        while (this.eat(44)) {
            x = x.or(this.parseTerm());
        }
        return x;
    }

    private Predicate<Collection<Integer>> parseTerm() {
        Predicate<Collection<Integer>> x = this.parseFactor();
        while (this.eat(38)) {
            x = x.and(this.parseFactor());
        }
        return x;
    }

    private Predicate<Collection<Integer>> parseFactor() {
        Predicate<Collection<Integer>> x;
        int startPos = this.pos;
        if (this.eat(33)) {
            x = this.parseFactor().negate();
        } else if (this.eat(123)) {
            x = this.parseExpression();
            this.eat(125);
        } else if (this.ch >= 48 && this.ch <= 57) {
            while (this.ch >= 48 && this.ch <= 57) {
                this.nextChar();
            }
            int lookFor = Integer.parseInt(this.str.substring(startPos, this.pos));
            x = this.buildPredicate(lookFor);
        } else {
            throw new RuntimeException("Unexpected: " + (char)this.ch);
        }
        return x;
    }

    protected Predicate<Collection<Integer>> buildPredicate(int lookFor) {
        return constituentIds -> constituentIds.contains(lookFor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdExpression that = (IdExpression)o;
        return Objects.equals(this.str, that.str);
    }

    public int hashCode() {
        return Objects.hash(this.str);
    }

    @Override
    public boolean test(Collection<Integer> integers) {
        return this.predicate.test(integers);
    }
}

