/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.massInjection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.massinjection.MassInjectionConstituentData;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.util.List;

public class WQMassInjectionConstituentData
implements MassInjectionConstituentData {
    private Data _selectedDataSource;
    private List<Data> _dataSources;
    private String _selectedDataSourceSetting;
    private String _selectedDataUnits;

    public WQMassInjectionConstituentData() {
    }

    public WQMassInjectionConstituentData(WQMassInjectionConstituentData v2, String constituentName) {
        this();
        this._dataSources = WQMassInjectionSiteData.createDataSources(constituentName);
        this.copyFrom(v2);
    }

    public void copyFrom(WQMassInjectionConstituentData copyFrom) {
        TableData newData;
        Data d = copyFrom._selectedDataSource;
        if (d instanceof TableData) {
            newData = new TableData((TableData)d);
            this._selectedDataSource = newData;
        } else if (d instanceof DssData) {
            newData = new DssData((DssData)d);
            this._selectedDataSource = newData;
        } else if (d instanceof ConstantData) {
            newData = new ConstantData((ConstantData)d);
            this._selectedDataSource = newData;
        } else if (d instanceof ExcelData) {
            newData = new ExcelData((ExcelData)d);
            this._selectedDataSource = newData;
        }
        if (this._selectedDataSource != null) {
            for (int i = 0; i < this._dataSources.size(); ++i) {
                if (!this._dataSources.get(i).getName().equals(this._selectedDataSource.getName())) continue;
                this._dataSources.set(i, this._selectedDataSource);
                break;
            }
        }
        this._selectedDataUnits = copyFrom._selectedDataUnits;
        this._selectedDataSourceSetting = copyFrom._selectedDataSourceSetting;
    }

    public List<Data> getDataSources() {
        return this._dataSources;
    }

    public String getSelectedDataSourceSetting() {
        return this._selectedDataSourceSetting;
    }

    public String getSelectedDataUnits() {
        return this._selectedDataUnits;
    }

    public Data getSelectedDataSource() {
        return this._selectedDataSource;
    }

    public void setDataSources(List<Data> dataSources) {
        if (dataSources != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                Data data = dataSources.get(i);
                if (!(data instanceof DssData)) continue;
                ((DssData)data).setHasInterpretedUnits(false);
                break;
            }
        }
        this._dataSources = dataSources;
    }

    public void setSelectedDataSource(Data selectedDataSource) {
        this._selectedDataSource = selectedDataSource;
    }

    public void setSelectedDataSourceSetting(String selectedDataSourceSetting) {
        this._selectedDataSourceSetting = selectedDataSourceSetting;
    }

    public void setSelectedDataUnits(String selectedDataUnits) {
        this._selectedDataUnits = selectedDataUnits;
    }

    @JsonIgnore
    public boolean isEmpty() {
        boolean isEmpty = true;
        isEmpty = isEmpty && (this._dataSources == null || this._dataSources.isEmpty());
        isEmpty = isEmpty && (this._selectedDataSourceSetting == null || this._selectedDataSourceSetting.isEmpty());
        isEmpty = isEmpty && (this._selectedDataUnits == null || this._selectedDataUnits.isEmpty());
        isEmpty = isEmpty && this._selectedDataSource == null;
        return isEmpty;
    }
}

