/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.massInjection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.data.Units;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.Library;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.massinjection.MassInjectionConstituentData;
import hec.wqenginecore.massinjection.MassInjectionReservoirType;
import hec.wqenginecore.massinjection.MassInjectionSet;
import hec.wqenginecore.massinjection.MassInjectionSite;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import hec.wqengineimpl.massInjection.WQMassInjectionSiteData;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonPropertyOrder(value={"name", "description"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQMassInjectionSet
implements MassInjectionSet {
    @JsonPropertyOrder(alphabetic=true)
    @JsonProperty(value="massInjectionSiteIdList")
    protected List<Integer> _massInjectionSiteIdList = new ArrayList<Integer>();
    @JsonProperty(value="name")
    private String name = "";
    @JsonProperty(value="description")
    private String description = "";
    @JsonProperty(value="massInjectionSiteData")
    private Map<Integer, WQMassInjectionSiteData> _siteData = new HashMap<Integer, WQMassInjectionSiteData>();
    private transient PropertyChangeSupport _propChangeSupport = new PropertyChangeSupport(this);

    public WQMassInjectionSet() {
    }

    public WQMassInjectionSet(String name, String description) {
        this();
        this.name = name;
        this.description = description;
    }

    @JsonIgnore
    public List<MassInjectionSite> getMassInjectionSiteList(List<MassInjectionSite> allSites) {
        if (allSites == null) {
            return new ArrayList<MassInjectionSite>(0);
        }
        return allSites.stream().filter(mis -> this._massInjectionSiteIdList.contains(mis.getId())).collect(Collectors.toList());
    }

    public void setMassInjectionSiteList(Collection<MassInjectionSite> newList) {
        this._massInjectionSiteIdList.clear();
        if (newList != null) {
            this._massInjectionSiteIdList.addAll(newList.stream().map(mis -> mis.getId()).collect(Collectors.toList()));
            for (int i = 0; i < this._massInjectionSiteIdList.size(); ++i) {
                Integer id = this._massInjectionSiteIdList.get(i);
                if (this._siteData.containsKey(id)) continue;
                this._siteData.put(id, new WQMassInjectionSiteData());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String text) {
        this.name = text;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String text) {
        this.description = text;
    }

    public WQConsistencyCheck checkConsistency(List<MassInjectionSite> miSites, Geometry wqGeo, ConstituentSet constitSet) {
        String datasetName = "Water Quality Mass Injection Set: " + this.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        if (wqGeo == null) {
            String errorMessage = "Missing dependent Water Quality Geometry";
            consistencyCheck.addErrorMessage(errorMessage);
            return consistencyCheck;
        }
        if (constitSet == null) {
            String errorMessage = "Missing dependent Constituent Set";
            consistencyCheck.addErrorMessage(errorMessage);
            return consistencyCheck;
        }
        if (miSites == null) {
            String warningMessage = "Can only evaluate Mass Injection Set consistency from Simulation Module";
            consistencyCheck.addWarningMessage(warningMessage);
            return consistencyCheck;
        }
        Collection constitList = constitSet.getConstituentList();
        ArrayList<Integer> constitSetIdList = new ArrayList<Integer>();
        for (Constituent constit : constitList) {
            constitSetIdList.add(constit.getId());
        }
        int nMassInjections = miSites.size();
        for (int j = 0; j < nMassInjections; ++j) {
            MassInjectionReservoirType miType;
            String warningMessage;
            boolean isSubdomain;
            MassInjectionSite site = miSites.get(j);
            MassInjectionSiteData siteData = this.getMassInjectionSiteData(site);
            SubDomain subdom = siteData.getSubDomain(wqGeo);
            SubDomainJunction subdomJunc = siteData.getSubDomainJunction(wqGeo);
            boolean isJunction = subdomJunc != null;
            boolean bl = isSubdomain = subdom != null;
            if (!isJunction && !isSubdomain) {
                String errorMessage = "Mass Injection: " + site.getName() + " not found in WQ Geometry";
                consistencyCheck.addErrorMessage(errorMessage);
                continue;
            }
            if (isSubdomain) {
                if (!wqGeo.isInExtent(subdom)) {
                    warningMessage = "Mass Injection: " + site.getName() + " in Subdomain: " + subdom.getName() + " is not within the active WQ Geometry extent";
                    consistencyCheck.addWarningMessage(warningMessage);
                    continue;
                }
            } else if (!wqGeo.isWQJnctInExtent(subdomJunc)) {
                warningMessage = "Mass Injection: " + site.getName() + " at Junction: " + subdomJunc.getName() + " is not within the active WQ Geometry extent";
                consistencyCheck.addWarningMessage(warningMessage);
                continue;
            }
            if (isSubdomain && subdom.getType() == SubDomainType.RESERVOIR_1DV && (miType = siteData.getMassInjectionReservoirType()) == MassInjectionReservoirType.Elevation && Math.abs(siteData.getReservoirInjectionElevation()) < 0.01) {
                String warningMessage2 = "Mass Injection: " + site.getName() + " is injected at Reservoir Elevation = 0.0";
                consistencyCheck.addWarningMessage(warningMessage2);
            }
            Set constitIds = siteData.getConstituentIds();
            Iterator iterator = constitIds.iterator();
            while (iterator.hasNext()) {
                String errorMessage;
                int cId = (Integer)iterator.next();
                Constituent targetConstit = this.findConstituent(cId);
                String cName = targetConstit != null ? targetConstit.getDisplayName() : String.valueOf(cId);
                if (!constitSetIdList.contains(cId)) {
                    String warningMessage3 = "Mass Injection: " + site.getName() + " has data for Constituent: " + cName + " which is not in the active Constituent Set";
                    consistencyCheck.addWarningMessage(warningMessage3);
                    continue;
                }
                MassInjectionConstituentData micData = siteData.getMassInjectionConstituentData(cId);
                Data dataSrc = micData.getSelectedDataSource();
                if (dataSrc instanceof ConstantData) {
                    double val = ((ConstantData)dataSrc).getConstantValue();
                    if (val == Double.NEGATIVE_INFINITY) {
                        errorMessage = "Mass Injection: " + site.getName() + " has no defined constant value for constituent " + cName;
                        consistencyCheck.addErrorMessage(errorMessage);
                        continue;
                    }
                    if (!(val < 0.0)) continue;
                    errorMessage = "Mass Injection: " + site.getName() + " has constant value < 0.0 for constituent " + cName;
                    consistencyCheck.addErrorMessage(errorMessage);
                    continue;
                }
                if (!(dataSrc instanceof DssData)) continue;
                DssData dssData = (DssData)dataSrc;
                if (dssData.getDssFilePath() == null || dssData.getDssPath() == null) {
                    String errorMessage2 = "Mass Injection: " + site.getName() + " has no defined DSS file or path for constituent " + cName;
                    consistencyCheck.addErrorMessage(errorMessage2);
                }
                String units = dssData.getUnits();
                if (cId != 1 || Units.canConvertBetweenUnits((String)units, (String)"deg C")) continue;
                errorMessage = "Mass Injection: " + site.getName() + " has units for water temperature: " + units + " which can't be converted to deg C";
                consistencyCheck.addErrorMessage(errorMessage);
            }
        }
        return consistencyCheck;
    }

    private Constituent findConstituent(int constitId) {
        WQLibraryRegistryImpl libraryRegistry = new WQLibraryRegistryImpl();
        Constituent constit = null;
        boolean found = false;
        for (Library library : libraryRegistry.getLibraries()) {
            Set available = library.listConstituents();
            for (Constituent c : available) {
                if (c.getId() != constitId) continue;
                constit = c;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return constit;
    }

    public boolean addMassInjectionSite(MassInjectionSite site) {
        if (site == null) {
            return false;
        }
        if (!this._massInjectionSiteIdList.contains(site.getId())) {
            this.addMassInjectionSiteId(site.getId());
            return true;
        }
        return false;
    }

    public boolean hasMassInjectionSite(int massInjectionSiteId) {
        return this._massInjectionSiteIdList.contains(massInjectionSiteId);
    }

    @JsonIgnore
    public MassInjectionSite getMassInjectionSite(int id, List<MassInjectionSite> allSites) {
        if (this._massInjectionSiteIdList == null) {
            return null;
        }
        Optional<MassInjectionSite> site = allSites.stream().filter(mis -> mis.getId() == id).findFirst();
        if (site.isPresent()) {
            return site.get();
        }
        return null;
    }

    @JsonIgnore
    public int getNumSites() {
        return this.size();
    }

    @JsonIgnore
    public int size() {
        if (this._massInjectionSiteIdList == null) {
            return 0;
        }
        return this._massInjectionSiteIdList.size();
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public boolean has(Integer massInjectionSiteId) {
        System.out.println("has TODO implement me");
        return false;
    }

    public void addMassInjectionSiteId(int newSiteId) {
        if (newSiteId < 0) {
            return;
        }
        if (!this._massInjectionSiteIdList.contains(newSiteId)) {
            this._massInjectionSiteIdList.add(newSiteId);
            this._propChangeSupport.firePropertyChange("siteadded", 0, newSiteId);
            MassInjectionSiteData data = this.getMassInjectionSiteData(newSiteId);
            if (data == null) {
                this._siteData.put(newSiteId, new WQMassInjectionSiteData());
            }
        }
    }

    public MassInjectionSiteData getMassInjectionSiteData(MassInjectionSite site) {
        if (site != null) {
            return this.getMassInjectionSiteData(site.getId());
        }
        return null;
    }

    private MassInjectionSiteData getMassInjectionSiteData(int id) {
        WQMassInjectionSiteData data = this._siteData.get(id);
        if (data == null) {
            data = new WQMassInjectionSiteData();
            this._siteData.put(id, data);
        }
        return data;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this._propChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this._propChangeSupport.removePropertyChangeListener(listener);
        }
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQMassInjectionSet.class);
        }
    }
}

