/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.massInjection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainJunction;
import hec.wqenginecore.geometry.SubDomainJunctionRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.massinjection.MassInjectionConstituentData;
import hec.wqenginecore.massinjection.MassInjectionReservoirType;
import hec.wqenginecore.massinjection.MassInjectionSiteData;
import hec.wqenginecore.massinjection.MassInjectionType;
import hec.wqengineimpl.geometry.WQSubDomainJunctionRef;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.massInjection.WQMassInjectionConstituentData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQMassInjectionSiteData
implements MassInjectionSiteData {
    private Map<Integer, WQMassInjectionConstituentData> _constituentData = new HashMap<Integer, WQMassInjectionConstituentData>();
    private Set<Integer> _constituentIds = new HashSet<Integer>();
    private SubDomainRef _subDomainRef;
    private SubDomainJunctionRef _subDomainJunctionRef;
    private MassInjectionType _massInjectionType;
    private MassInjectionReservoirType _massInjectionReservoirType;
    private double _reservoirInjectionElevation;
    private double _reservoirInjectionDepth;

    @JsonIgnore
    public void setConstituents(List<Constituent> constituents) {
        this._constituentIds.clear();
        if (constituents != null) {
            this._constituentIds.addAll(constituents.stream().map(c -> c.getId()).collect(Collectors.toList()));
        }
    }

    public void setConstituentIds(Collection<Integer> constituentIds) {
        this._constituentIds.clear();
        if (constituentIds != null) {
            this._constituentIds.addAll(constituentIds);
        }
    }

    public Set<Integer> getConstituentIds() {
        return Collections.unmodifiableSet(this._constituentIds);
    }

    @JsonIgnore
    public List<Constituent> getConstituents(List<Constituent> allConstituents) {
        return allConstituents.stream().filter(c -> this._constituentIds.contains(c.getId())).collect(Collectors.toList());
    }

    public boolean hasConstituent(Constituent c) {
        if (c != null) {
            return this._constituentIds.contains(c.getId());
        }
        return false;
    }

    public MassInjectionConstituentData getMassInjectionConstituentData(Constituent constituent) {
        if (constituent == null) {
            return null;
        }
        int id = constituent.getId();
        MassInjectionConstituentData constituentData = this._constituentData.get(id);
        if (constituentData == null) {
            constituentData = new WQMassInjectionConstituentData();
            constituentData.setDataSources(WQMassInjectionSiteData.createDataSources(constituent.getName()));
            this.addMassInjectionConstituentData(id, (WQMassInjectionConstituentData)constituentData);
        }
        return constituentData;
    }

    public MassInjectionConstituentData getMassInjectionConstituentData(int constituentId) {
        MassInjectionConstituentData constituentData = this._constituentData.get(constituentId);
        return constituentData;
    }

    public void addMassInjectionConstituentData(int id, WQMassInjectionConstituentData constituentData) {
        this._constituentData.put(id, constituentData);
    }

    static List<Data> createDataSources(String constituentName) {
        ArrayList<Data> dataSources = new ArrayList<Data>();
        TableData tableData = new TableData();
        tableData.setVariableName(constituentName);
        dataSources.add((Data)tableData);
        DssData dssData = new DssData(false);
        dataSources.add((Data)dssData);
        dataSources.add((Data)new ExcelData());
        dataSources.add((Data)new ConstantData());
        return dataSources;
    }

    @JsonDeserialize(as=WQSubDomainRef.class)
    public void setSubDomainRef(SubDomainRef sdRef) {
        this._subDomainRef = sdRef;
        this._subDomainJunctionRef = null;
    }

    @JsonSerialize(as=WQSubDomainRef.class)
    public SubDomainRef getSubDomainRef() {
        return this._subDomainRef;
    }

    @JsonDeserialize(as=WQSubDomainJunctionRef.class)
    public void setSubDomainJunctionRef(SubDomainJunctionRef sdbRef) {
        this._subDomainJunctionRef = sdbRef;
        this._subDomainRef = null;
    }

    @JsonSerialize(as=WQSubDomainJunctionRef.class)
    public SubDomainJunctionRef getSubDomainJunctionRef() {
        return this._subDomainJunctionRef;
    }

    public SubDomain getSubDomain(Geometry geometry) {
        if (this._subDomainRef != null) {
            return this._subDomainRef.getSubDomain(geometry);
        }
        return null;
    }

    public SubDomainJunction getSubDomainJunction(Geometry geometry) {
        if (this._subDomainJunctionRef != null) {
            return this._subDomainJunctionRef.getJunction(geometry);
        }
        return null;
    }

    public void copyFrom(MassInjectionSiteData fromSiteData, List<Constituent> allConstituents) {
        if (!(fromSiteData instanceof WQMassInjectionSiteData)) {
            return;
        }
        WQMassInjectionSiteData fromWQData = (WQMassInjectionSiteData)fromSiteData;
        this._constituentIds.addAll(fromWQData._constituentIds);
        Set<Map.Entry<Integer, WQMassInjectionConstituentData>> eSet = fromWQData._constituentData.entrySet();
        for (Map.Entry<Integer, WQMassInjectionConstituentData> entry : eSet) {
            Integer key = entry.getKey();
            if (!this._constituentData.containsKey(key)) {
                WQMassInjectionConstituentData newData = new WQMassInjectionConstituentData(entry.getValue(), this.getConstituentName(key, allConstituents));
                this._constituentData.put(key, newData);
                continue;
            }
            WQMassInjectionConstituentData data = this._constituentData.get(key);
            data.copyFrom(fromWQData._constituentData.get(key));
        }
    }

    private String getConstituentName(Integer key, List<Constituent> allConstituents) {
        Optional<Constituent> constituent = allConstituents.stream().filter(c -> c.getId() == key.intValue()).findFirst();
        if (constituent.isPresent()) {
            return constituent.get().getName();
        }
        return null;
    }

    public Map<Integer, WQMassInjectionConstituentData> getConstituentData() {
        return Collections.unmodifiableMap(this._constituentData);
    }

    public void setConstituentData(Map<Integer, WQMassInjectionConstituentData> constituentData) {
        this._constituentData.clear();
        if (constituentData != null) {
            this._constituentData.putAll(constituentData);
        }
    }

    public MassInjectionType getMassInjectionType() {
        return this._massInjectionType;
    }

    public void setMassInjectionType(MassInjectionType type) {
        this._massInjectionType = type;
    }

    public MassInjectionReservoirType getMassInjectionReservoirType() {
        return this._massInjectionReservoirType;
    }

    public void setMassInjectionReservoirType(MassInjectionReservoirType type) {
        this._massInjectionReservoirType = type;
    }

    public double getReservoirInjectionDepth() {
        return this._reservoirInjectionDepth;
    }

    public double getReservoirInjectionElevation() {
        return this._reservoirInjectionElevation;
    }

    public void setReservoirInjectionDepth(double value) {
        this._reservoirInjectionDepth = value;
    }

    public void setReservoirInjectionElevation(double value) {
        this._reservoirInjectionElevation = value;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQMassInjectionSiteData.class);
        }
    }
}

