/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.vividsolutions.jts.geom.Geometry;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetVariable;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqengineimpl.metstation.WQMetVariable;
import hec.wqengineimpl.metstation.variable.AirTemperature;
import hec.wqengineimpl.metstation.variable.AtmosphericPressure;
import hec.wqengineimpl.metstation.variable.Cloudiness;
import hec.wqengineimpl.metstation.variable.Humidity;
import hec.wqengineimpl.metstation.variable.ShortWaveRadiation;
import hec.wqengineimpl.metstation.variable.WindSpeed;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WQMetStation
implements MetStation {
    public static final String ACTIVE = "active";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String NEAREST_MERIDIAN = "nearestMeridian";
    @JsonProperty(value="id")
    int _id = -1;
    @JsonProperty(value="name")
    String _name = "";
    @JsonProperty(value="description")
    String _description = "";
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="geometry")
    private Geometry _geometry;
    @JsonDeserialize(contentAs=WQMetVariable.class)
    @JsonSerialize(contentAs=WQMetVariable.class)
    @JsonProperty(value="variables")
    final List<MetVariable> _variables = new ArrayList<MetVariable>();
    @JsonProperty(value="longitude")
    private double _longitude;
    @JsonProperty(value="latitude")
    private double _latitude;
    @JsonProperty(value="nearestMeridian")
    private int _nearestMeridian = 0;
    @JsonProperty(value="referenceElevation")
    private double _referenceElevation;
    @JsonProperty(value="active")
    private boolean _isActive = true;
    @JsonProperty(value="observed")
    private boolean _isObserved;
    @JsonProperty(value="metStation")
    private boolean _isMetStation;
    @JsonIgnore
    private ShortWaveListener _shortWaveListener = new ShortWaveListener();
    @JsonIgnore
    PropertyChangeSupport _propertyChangeSupport;

    public WQMetStation() {
        this._propertyChangeSupport = new PropertyChangeSupport(this);
        this._variables.add(new AtmosphericPressure());
        this._variables.add(new AirTemperature());
        this._variables.add(new Humidity());
        ShortWaveRadiation shortWaveRadiation = new ShortWaveRadiation();
        this._shortWaveListener = new ShortWaveListener();
        this.addListener(shortWaveRadiation);
        this._propertyChangeSupport.addPropertyChangeListener(this._shortWaveListener);
        this._variables.add(shortWaveRadiation);
        this._variables.add(new Cloudiness());
        this._variables.add(new WindSpeed());
    }

    public void addListener(ShortWaveRadiation shortWaveRadiation) {
        shortWaveRadiation.setLatitude(this._latitude);
        shortWaveRadiation.setLongitude(this._longitude);
        shortWaveRadiation.setNearestMeridian(this._nearestMeridian);
        this._shortWaveListener.setShortWaveRadiation(shortWaveRadiation);
    }

    public WQMetStation(int id, String name, List<MetVariable> variables) {
        this._id = id;
        this._name = name;
        this._variables.addAll(variables);
    }

    @JsonIgnore
    public int getId() {
        return this._id;
    }

    public void setId(int i) {
        this._id = i;
    }

    @JsonIgnore
    public AtmosphericPressure getAtmosphericPressure() {
        Predicate<MetVariable> q = ap -> ap.getType().equals(MetVariableTypes.ATMOSPHERIC_PRESSURE.getName());
        return (AtmosphericPressure)this.getVariables(q).get(0);
    }

    public List<MetVariable> getVariables(Predicate<MetVariable> predicate) {
        return this._variables.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MetVariable> getVariables() {
        return this._variables;
    }

    public void setVariables(List<MetVariable> vars) {
        this._variables.clear();
        if (vars != null && !vars.isEmpty()) {
            this._variables.addAll(vars);
            for (MetVariable var : vars) {
                if (!(var instanceof ShortWaveRadiation)) continue;
                ShortWaveRadiation shortWaveRadiation = (ShortWaveRadiation)var;
                this.addListener(shortWaveRadiation);
            }
        }
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean active) {
        boolean oldActive = this._isActive;
        this._isActive = active;
        this._propertyChangeSupport.firePropertyChange(ACTIVE, oldActive, this._isActive);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonIgnore
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setGeometry(Geometry geometry) {
        this._geometry = geometry;
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    @JsonIgnore
    public double getLatitude() {
        return this._latitude;
    }

    @JsonIgnore
    public double getLongitude() {
        return this._longitude;
    }

    @JsonIgnore
    public int getNearestMeridian() {
        return this._nearestMeridian;
    }

    @JsonIgnore
    public double getReferenceElevation() {
        return this._referenceElevation;
    }

    public void setReferenceElevation(double refElevation) {
        this._referenceElevation = refElevation;
        for (MetVariable variable : this._variables) {
            List dataSources = variable.getDataSources();
            for (Data dataSource : dataSources) {
                if (!(dataSource instanceof ElevationData)) continue;
                ((ElevationData)dataSource).setElevation(refElevation);
            }
        }
    }

    public void setLatitude(double latitude) {
        double oldVal = this._latitude;
        this._latitude = latitude;
        this._propertyChangeSupport.firePropertyChange(LATITUDE, oldVal, this._latitude);
    }

    public void setLongitude(double longitude) {
        double oldVal = this._longitude;
        this._longitude = longitude;
        this._propertyChangeSupport.firePropertyChange(LONGITUDE, oldVal, this._longitude);
    }

    public void setNearestMeridian(int nearestMeridian) {
        int oldVal = this._nearestMeridian;
        this._nearestMeridian = nearestMeridian;
        this._propertyChangeSupport.firePropertyChange(NEAREST_MERIDIAN, oldVal, this._nearestMeridian);
    }

    @JsonIgnore
    public boolean isObserved() {
        return this._isObserved;
    }

    public void setIsObserved(boolean isObserved) {
        this._isObserved = isObserved;
    }

    @JsonIgnore
    public boolean isMetStation() {
        return this._isMetStation;
    }

    public void setIsMetStation(boolean isMetStation) {
        this._isMetStation = isMetStation;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String toString() {
        return this.getName();
    }

    private static class ShortWaveListener
    implements PropertyChangeListener {
        private ShortWaveRadiation _shortWaveRadiation = null;

        public void setShortWaveRadiation(ShortWaveRadiation shortWaveRadiation) {
            this._shortWaveRadiation = shortWaveRadiation;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this._shortWaveRadiation != null) {
                Object newValue;
                if (WQMetStation.LATITUDE.equals(evt.getPropertyName())) {
                    Object newValue2 = evt.getNewValue();
                    if (newValue2 instanceof Double) {
                        this._shortWaveRadiation.setLatitude((Double)newValue2);
                    }
                } else if (WQMetStation.LONGITUDE.equals(evt.getPropertyName())) {
                    Object newValue3 = evt.getNewValue();
                    if (newValue3 instanceof Double) {
                        this._shortWaveRadiation.setLongitude((Double)newValue3);
                    }
                } else if (WQMetStation.NEAREST_MERIDIAN.equals(evt.getPropertyName()) && (newValue = evt.getNewValue()) instanceof Integer) {
                    this._shortWaveRadiation.setNearestMeridian((Integer)newValue);
                }
            }
        }
    }
}

