/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.WQEngineAdapter;
import hec.wqenginecore.WQException;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.metstation.MetStation;
import hec.wqenginecore.metstation.MetStationSet;
import hec.wqenginecore.metstation.MetVariable;
import hec.wqengineimpl.metstation.WQMetStation;
import hec.wqengineimpl.metstation.variable.AirTemperature;
import hec.wqengineimpl.metstation.variable.AtmosphericPressure;
import hec.wqengineimpl.metstation.variable.Cloudiness;
import hec.wqengineimpl.metstation.variable.Humidity;
import hec.wqengineimpl.metstation.variable.ShortWaveRadiation;
import hec.wqengineimpl.metstation.variable.WindSpeed;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.UnitsConversionException;

@JsonPropertyOrder(value={"id", "name", "description", "metdatablending", "stations"})
public class WQMetStationSet
implements MetStationSet {
    @JsonProperty(value="id")
    int _id = -1;
    @JsonProperty(value="name")
    String _name = "";
    @JsonProperty(value="description")
    String _description = "";
    @JsonProperty(value="metdatablending")
    boolean _metDataBlending = false;
    List<MetStation> _metStations = new ArrayList<MetStation>();

    public WQMetStationSet() {
    }

    public WQMetStationSet(String name, String description, List<WQMetStation> metStations) {
        this._name = name;
        this._description = description;
        this._metStations.addAll(metStations);
    }

    public void testMethod() {
        System.out.println("This is a test method");
        System.out.println("printout my cool messages");
    }

    public void testMethod2() {
        System.out.println("This is a test method2");
        System.out.println("printout my cool messages");
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonIgnore
    public int getId() {
        return this._id;
    }

    public void setId(int i) {
        this._id = i;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JsonDeserialize(contentAs=WQMetStation.class)
    @JsonSerialize(contentAs=WQMetStation.class)
    public List<MetStation> getStations() {
        return this._metStations;
    }

    @JsonIgnore
    public List<MetStation> getActiveStations() {
        return this.getStations(station -> station.isActive());
    }

    public void addStation(WQMetStation metStation) {
        this._metStations.add(metStation);
    }

    public <T extends MetStation> List<T> getStations(Predicate<T> query) {
        return this._metStations.stream().map(s -> s).filter(query).collect(Collectors.toList());
    }

    public String toString() {
        return this.getName();
    }

    public WQConsistencyCheck checkConsistency() {
        String datasetName = "Meteorological Data Set: " + this.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        for (MetStation metStation : this._metStations) {
            if (!metStation.isActive()) continue;
            for (MetVariable metVar : metStation.getVariables()) {
                String errorMessage;
                String errorMessage2;
                double[] vals;
                String errorMessage3;
                double value;
                ConstantData data;
                String selectedDataSourceName = metVar.getSelectedDataSourceName();
                if ("Constant Value".equals(selectedDataSourceName)) {
                    block21: {
                        data = (ConstantData)metVar.getSelectedData();
                        value = data.getConstantValue();
                        if (value == Double.NEGATIVE_INFINITY) {
                            errorMessage3 = "Met Station: " + metStation.getName() + " has no defined constant value for variable " + metVar.getType();
                            consistencyCheck.addErrorMessage(errorMessage3);
                            continue;
                        }
                        vals = new double[]{value};
                        try {
                            if (metVar instanceof AirTemperature) {
                                vals = WQEngineAdapter.convertAirTemp((MetVariable)metVar, (double[])vals, (String)data.getUnits(), (MetStation)metStation);
                                break block21;
                            }
                            if (metVar instanceof AtmosphericPressure) {
                                vals = WQEngineAdapter.convertAtmoValues((MetVariable)metVar, (double[])vals, (Data)metVar.getSelectedData(), (String)data.getUnits(), (MetStation)metStation);
                                break block21;
                            }
                            if (metVar instanceof Cloudiness) break block21;
                            if (metVar instanceof Humidity) {
                                vals[0] = 50.0;
                                break block21;
                            }
                            if (metVar instanceof ShortWaveRadiation) {
                                vals = WQEngineAdapter.convertSWRad((MetVariable)metVar, (double[])vals, (Data)metVar.getSelectedData(), (String)data.getUnits(), null, null, null, (MetStation)metStation);
                                break block21;
                            }
                            if (!(metVar instanceof WindSpeed)) break block21;
                            vals = WQEngineAdapter.convertWindSpeed((MetVariable)metVar, (double[])vals, (String)data.getUnits(), (MetStation)metStation);
                        }
                        catch (UnitsConversionException uce) {
                            errorMessage2 = "Met Station: " + metStation.getName() + " unit conversion error for variable " + metVar.getType();
                            consistencyCheck.addErrorMessage(errorMessage2);
                            continue;
                        }
                        catch (WQException wqe) {
                            consistencyCheck.addErrorMessage(wqe.getMessage());
                            continue;
                        }
                    }
                    if (vals[0] < metVar.getMinAllowedVal()) {
                        errorMessage = "Met Station: " + metStation.getName() + " variable " + metVar.getType() + " below minimum allowed value";
                        consistencyCheck.addErrorMessage(errorMessage);
                        continue;
                    }
                    if (!(vals[0] > metVar.getMaxAllowedVal())) continue;
                    errorMessage = "Met Station: " + metStation.getName() + " variable " + metVar.getType() + " above maximum allowed value";
                    consistencyCheck.addErrorMessage(errorMessage);
                    continue;
                }
                if ("DSS".equals(selectedDataSourceName)) {
                    data = (DssData)metVar.getSelectedData();
                    this.checkDssData((DssData)data, metVar, metStation, consistencyCheck);
                    continue;
                }
                if ("Lat-Long".equals(selectedDataSourceName)) {
                    this.checkLatLongForStation(metStation, consistencyCheck);
                    continue;
                }
                if ("Compute from ObsSW and Lat-Long".equals(selectedDataSourceName)) {
                    data = (ObservedData)metVar.getSelectedData();
                    this.checkDssData((DssData)data, metVar, metStation, consistencyCheck);
                    this.checkLatLongForStation(metStation, consistencyCheck);
                    continue;
                }
                if ("Elevation".equals(selectedDataSourceName)) {
                    data = (ElevationData)metVar.getSelectedData();
                    value = data.getElevation();
                    if (value == Double.NEGATIVE_INFINITY) {
                        errorMessage3 = "Met Station: " + metStation.getName() + " has no defined elevation for variable " + metVar.getType();
                        consistencyCheck.addErrorMessage(errorMessage3);
                        continue;
                    }
                    vals = new double[]{value};
                    try {
                        vals = WQEngineAdapter.convertAtmoValues((MetVariable)metVar, (double[])vals, (Data)metVar.getSelectedData(), (String)data.getUnits(), (MetStation)metStation);
                    }
                    catch (UnitsConversionException uce) {
                        errorMessage2 = "Met Station: " + metStation.getName() + " unit conversion error for variable " + metVar.getType();
                        consistencyCheck.addErrorMessage(errorMessage2);
                        continue;
                    }
                    catch (WQException wqe) {
                        errorMessage2 = "Met Station: " + metStation.getName() + " negative value found for variable " + metVar.getType();
                        consistencyCheck.addErrorMessage(errorMessage2);
                        continue;
                    }
                    if (vals[0] < metVar.getMinAllowedVal()) {
                        errorMessage = "Met Station: " + metStation.getName() + " variable " + metVar.getType() + " below minimum allowed value";
                        consistencyCheck.addErrorMessage(errorMessage);
                        continue;
                    }
                    if (!(vals[0] > metVar.getMaxAllowedVal())) continue;
                    errorMessage = "Met Station: " + metStation.getName() + " variable " + metVar.getType() + " above maximum allowed value";
                    consistencyCheck.addErrorMessage(errorMessage);
                    continue;
                }
                if (selectedDataSourceName != null && !selectedDataSourceName.isEmpty()) continue;
                String errorMessage4 = "Met Station: " + metStation.getName() + " has no defined data source for variable " + metVar.getType();
                consistencyCheck.addErrorMessage(errorMessage4);
            }
        }
        return consistencyCheck;
    }

    private void checkDssData(DssData data, MetVariable metVar, MetStation metStation, WQConsistencyCheck consistencyCheck) {
        String errorMessage;
        if (data.getDssFilePath().isEmpty() || data.getDssPath() == null || data.getDssPath().isEmpty()) {
            errorMessage = "Met Station: " + metStation.getName() + " has no defined DSS file or path for variable " + metVar.getType();
            consistencyCheck.addErrorMessage(errorMessage);
        }
        if (data.getInterpretedUnits() == null) {
            errorMessage = "Met Station: " + metStation.getName() + " has no defined units for variable " + metVar.getType();
            consistencyCheck.addErrorMessage(errorMessage);
        }
    }

    private void checkLatLongForStation(MetStation metStation, WQConsistencyCheck consistencyCheck) {
        String warningMessage;
        double tol = 0.01;
        if (Math.abs(metStation.getLatitude()) < tol) {
            warningMessage = "Met Station: " + metStation.getName() + " has latitude = 0";
            consistencyCheck.addWarningMessage(warningMessage);
        }
        if (Math.abs(metStation.getLongitude()) < tol) {
            warningMessage = "Met Station: " + metStation.getName() + " has longitude = 0";
            consistencyCheck.addWarningMessage(warningMessage);
        }
        if (Math.abs(metStation.getNearestMeridian()) == 0) {
            warningMessage = "Met Station: " + metStation.getName() + " has standard meridian = 0W (Greenwich Mean Time)";
            consistencyCheck.addWarningMessage(warningMessage);
        }
    }

    public boolean getDataBlending() {
        return this._metDataBlending;
    }

    public void setDataBlending(boolean blending) {
        this._metDataBlending = blending;
    }
}

