/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
@JsonIgnoreProperties(value={"datasource"})
public abstract class WQMetVariable
implements MetVariable {
    @JsonIgnore
    private final String type;
    @JsonProperty(value="dataSources")
    private List<Data> dataSources = new ArrayList<Data>();
    @JsonProperty(value="selectedDataSourceName")
    private String _selectedDataSourceName = "";
    @JsonIgnore
    private List<Data> _dataSourcesCopy;

    protected WQMetVariable(String type) {
        this.type = type;
        this.createDataSources();
    }

    public String getType() {
        return this.type;
    }

    public String getSelectedDataSourceName() {
        return this._selectedDataSourceName;
    }

    @Deprecated
    public void setSelectedDataSourcename(String name) {
        this.setSelectedDataSourceName(name);
    }

    public void setSelectedDataSourceName(String name) {
        this._selectedDataSourceName = name;
    }

    @JsonIgnore
    public Data getSelectedData() {
        String name = this.getSelectedDataSourceName();
        return this.getDataSources().stream().filter(d -> Objects.equals(d.getName(), name)).findFirst().orElse(null);
    }

    @JsonIgnore
    public abstract String[] getUnits();

    protected Collection<Object> createDataSources() {
        ArrayList<Object> dataSourceSet = new ArrayList<Object>();
        String[] units = this.getUnits();
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData();
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
        ElevationData ed = new ElevationData();
        ed.setAvailableUnits(units);
        this.addDataSource((Data)ed);
        return dataSourceSet;
    }

    protected void addDataSource(Data obj) {
        Objects.requireNonNull(obj, "Null Datasource being added.");
        this.dataSources.add(obj);
    }

    public List<Data> getDataSources() {
        for (Data data : this.dataSources) {
            if (!(data instanceof TableData)) continue;
            ((TableData)data).setVariableName(this.getType());
        }
        return this.dataSources;
    }

    @JsonIgnore
    public List<Data> getDataSourcesCopy() {
        if (this._dataSourcesCopy == null) {
            this._dataSourcesCopy = new ArrayList<Data>();
            for (Data data : this.getDataSources()) {
                this._dataSourcesCopy.add(data.copy());
            }
        }
        return this._dataSourcesCopy;
    }

    protected <T> T lookup(Class<T> clazz) {
        return null;
    }

    @JsonIgnore
    public void applyDataSourcesChanges() {
        if (this._dataSourcesCopy != null) {
            this.dataSources.clear();
            this.dataSources.addAll(this.getDataSourcesCopy());
            this._dataSourcesCopy = null;
        }
    }

    public void clearCopy() {
        this._dataSourcesCopy = null;
    }
}

