/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqengineimpl.metstation.WQMetVariable;
import java.util.ArrayList;
import java.util.Collection;
import rma.services.annotations.ServiceProvider;

public class AirTemperature
extends WQMetVariable {
    public AirTemperature() {
        super(MetVariableTypes.AIR_TEMPERATURE.getName());
    }

    @Override
    @JsonIgnore
    public String[] getUnits() {
        return new String[]{"deg C", "deg F"};
    }

    @JsonIgnore
    public double getMinAllowedVal() {
        return -140.0;
    }

    @JsonIgnore
    public double getMaxAllowedVal() {
        return 140.0;
    }

    @Override
    protected Collection<Object> createDataSources() {
        ArrayList<Object> dataSourceSet = new ArrayList<Object>();
        String[] units = this.getUnits();
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData();
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        return dataSourceSet;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class AirTemperatureTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return AirTemperature.class;
        }

        public String getTypeId() {
            return AirTemperature.class.getSimpleName();
        }
    }
}

