/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.elevation.ElevationData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqengineimpl.metstation.WQMetVariable;
import java.util.ArrayList;
import java.util.Collection;
import rma.services.annotations.ServiceProvider;

public class AtmosphericPressure
extends WQMetVariable {
    public AtmosphericPressure() {
        super(MetVariableTypes.ATMOSPHERIC_PRESSURE.getName());
    }

    @Override
    @JsonIgnore
    public String[] getUnits() {
        return new String[]{"atm", "bar", "kPa", "mb", "mm-hg", "in-hg", "psi"};
    }

    @JsonIgnore
    public double getMinAllowedVal() {
        return 0.838;
    }

    @JsonIgnore
    public double getMaxAllowedVal() {
        return 1.086;
    }

    @Override
    protected Collection<Object> createDataSources() {
        ArrayList<Object> dataSourceSet = new ArrayList<Object>();
        String[] units = this.getUnits();
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData();
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        ElevationData ed = new ElevationData();
        ed.setAvailableUnits(new String[]{"ft", "m"});
        this.addDataSource((Data)ed);
        return dataSourceSet;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class AtmosphericPressureTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return AtmosphericPressure.class;
        }

        public String getTypeId() {
            return AtmosphericPressure.class.getSimpleName();
        }
    }
}

