/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.obs.ObservedData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqengineimpl.metstation.WQMetVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rma.services.annotations.ServiceProvider;

public class Cloudiness
extends WQMetVariable {
    public static final String UNITS = "Fraction, 0-1";
    public static final String C_PART = "Cloud Cover";

    public Cloudiness() {
        super(MetVariableTypes.CLOUDINESS.getName());
    }

    @Override
    @JsonIgnore
    public String[] getUnits() {
        return new String[]{UNITS};
    }

    public static String getDefaultUnits() {
        return UNITS;
    }

    @JsonIgnore
    public String getVariableType() {
        return MetVariableTypes.CLOUDINESS.getName();
    }

    @JsonIgnore
    public double getMinAllowedVal() {
        return 0.0;
    }

    @JsonIgnore
    public double getMaxAllowedVal() {
        return 1.0;
    }

    @Override
    protected Collection<Object> createDataSources() {
        ArrayList<Object> dataSourceSet = new ArrayList<Object>();
        String[] units = this.getUnits();
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData();
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        ObservedData observedData = new ObservedData();
        observedData.setAvailableUnits(units);
        this.addDataSource((Data)observedData);
        return dataSourceSet;
    }

    @Override
    public List<Data> getDataSources() {
        List<Data> dataSources = super.getDataSources();
        for (Data dataSource : dataSources) {
            if (!(dataSource instanceof ConstantData)) continue;
        }
        return dataSources;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class CloudinessTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return Cloudiness.class;
        }

        public String getTypeId() {
            return Cloudiness.class.getSimpleName();
        }
    }
}

