/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqengineimpl.metstation.WQMetVariable;
import java.util.ArrayList;
import java.util.Collection;
import rma.services.annotations.ServiceProvider;

public class Humidity
extends WQMetVariable {
    public Humidity() {
        super(MetVariableTypes.HUMIDITY.getName());
    }

    @Override
    @JsonIgnore
    public String[] getUnits() {
        return new String[]{"Relative Humidity, %", "Dewpt T, deg C", "Dewpt T, deg F", "Wetbulb T, deg C", "Wetbulb T, deg F", "mm-hg", "in-hg", "mb", "psi"};
    }

    @JsonIgnore
    public double getMinAllowedVal() {
        return 0.0;
    }

    @JsonIgnore
    public double getMaxAllowedVal() {
        return 100.0;
    }

    @Override
    protected Collection<Object> createDataSources() {
        ArrayList<Object> dataSourceSet = new ArrayList<Object>();
        String[] units = this.getUnits();
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData();
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        return dataSourceSet;
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class HumidityTypeResolverRegistration
    implements TypeResolver.TypeResolverRegistration {
        public Class getTypeClass() {
            return Humidity.class;
        }

        public String getTypeId() {
            return Humidity.class.getSimpleName();
        }
    }
}

