/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.metstation.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.latlong.LatLongData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.metstation.MetVariableTypes;
import hec.wqenginecore.metstation.ShortWaveRadiationUnits;
import hec.wqengineimpl.metstation.WQMetVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class ShortWaveRadiation
extends WQMetVariable {
    private LatLongData latLongData;

    public ShortWaveRadiation() {
        super(MetVariableTypes.SHORTWAVE_RADIATION.getName());
    }

    @Override
    @JsonIgnore
    public String[] getUnits() {
        return new String[]{ShortWaveRadiationUnits.WATTS_PER_M2.toString(), ShortWaveRadiationUnits.CAL_PER_CM2_PER_DAY.toString(), ShortWaveRadiationUnits.MJ_PER_M2_PER_DAY.toString(), ShortWaveRadiationUnits.LANGLEY_PER_MIN.toString()};
    }

    @JsonIgnore
    public static String getDefaultComputedUnits() {
        return ShortWaveRadiationUnits.WATTS_PER_M2.toString();
    }

    @Override
    public List<Data> getDataSources() {
        List<Data> dataSources = super.getDataSources();
        return dataSources;
    }

    @JsonIgnore
    public double getMinAllowedVal() {
        return 0.0;
    }

    @JsonIgnore
    public double getMaxAllowedVal() {
        return 2000.0;
    }

    @Override
    protected Collection<Object> createDataSources() {
        ArrayList<Object> dataSourceSet = new ArrayList<Object>();
        String[] units = this.getUnits();
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData();
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        this.latLongData = new LatLongData();
        this.latLongData.setAvailableUnits(units);
        this.addDataSource((Data)this.latLongData);
        return dataSourceSet;
    }

    public void setLatitude(Double newValue) {
        this.latLongData.setLatitude(newValue.doubleValue());
    }

    public void setLongitude(Double newValue) {
        this.latLongData.setLongitude(newValue.doubleValue());
    }

    public void setNearestMeridian(Integer newValue) {
        this.latLongData.setNearestMeridian(newValue.intValue());
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(ShortWaveRadiation.class);
        }
    }
}

