/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.observed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import hec.wqengineimpl.observed.WQObsVariable;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQObsConstituentVariable
extends WQObsVariable {
    private int _constituentId;
    private String _displayName;

    public WQObsConstituentVariable() {
        this.addDataSources();
    }

    public WQObsConstituentVariable(int constituentId, String displayName) {
        this._constituentId = constituentId;
        this._displayName = displayName;
        this.addDataSources();
    }

    public int getConstituentId() {
        return this._constituentId;
    }

    public void setConstituentId(int constituentId) {
        this._constituentId = constituentId;
        this._dataSources.clear();
        this.addDataSources();
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    @JsonIgnore
    public String getUnits() {
        WQLibraryRegistryImpl registry = new WQLibraryRegistryImpl();
        Constituent first = registry.getLibraries().stream().map(l -> l.listConstituents()).flatMap(l -> l.stream()).filter(c -> this._constituentId == c.getId()).findFirst().orElse(null);
        if (first == null) {
            return null;
        }
        return first.getUnit();
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQObsConstituentVariable.class);
        }
    }
}

