/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.observed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.vividsolutions.jts.geom.Geometry;
import hec.map.WorldPt;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsStationNetworkElement;
import hec.wqengineimpl.observed.WQObsVariable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WQObsStation
implements ObsStation {
    @JsonProperty(value="id")
    private int _id = -1;
    @JsonProperty(value="name")
    private String _name = "";
    @JsonProperty(value="description")
    private String _description = "";
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="geometry")
    private Geometry _geometry;
    @JsonDeserialize(contentAs=WQObsVariable.class)
    @JsonSerialize(contentAs=WQObsVariable.class)
    @JsonProperty(value="variables")
    private final List<ObsVariable> _variables = new ArrayList<ObsVariable>();
    @JsonProperty(value="longitude")
    private double _longitude;
    @JsonProperty(value="latitude")
    private double _latitude;
    @JsonProperty(value="nearestMeridian")
    private int _nearestMeridian = 0;
    @JsonProperty(value="referenceElevation")
    private double _referenceElevation;
    @JsonProperty(value="active")
    private boolean _isActive = true;
    @JsonProperty(value="observed")
    private boolean _isObserved;
    @JsonProperty(value="metStation")
    private boolean _isMetStation;
    @JsonProperty(value="snapToStreamElement")
    private boolean _snapToStreamElement;
    @JsonProperty(value="streamName")
    private String _streamName;
    @JsonProperty(value="stationIconLongitude")
    private double _stationIconLongitude;
    @JsonProperty(value="stationIconLatitude")
    private double _stationIconLatitude;
    @JsonDeserialize(contentAs=WQObsStationNetworkElement.class)
    @JsonSerialize(contentAs=WQObsStationNetworkElement.class)
    @JsonProperty(value="networkElements")
    private final List<WQObsStationNetworkElement> _networkElements = new ArrayList<WQObsStationNetworkElement>();
    @JsonIgnore
    private PropertyChangeSupport _propertyChangeSupport;
    @JsonProperty(value="streamStation")
    private double _streamStation;
    @JsonProperty(value="isProfileStation")
    private boolean _isProfileStation;

    public WQObsStation() {
        this._propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public WQObsStation(int id, String name, List<ObsVariable> variables) {
        this._id = id;
        this._name = name;
        this._variables.addAll(variables);
    }

    public WQObsStation(WQObsStation copyFrom) {
        this(copyFrom.getId(), copyFrom.getName(), new ArrayList<ObsVariable>(copyFrom.getVariables()));
        this.setIsProfileStation(copyFrom.isProfileStation());
        this.setStreamStation(copyFrom.getStreamStation());
        this.setStationIconLocation(copyFrom.getStationIconLocation());
        this.setDescription(copyFrom.getDescription());
        this.setLatitude(copyFrom.getLatitude());
        this.setLongitude(copyFrom.getLongitude());
        this.setGeometry(copyFrom.getGeometry());
        this.setIsMetStation(copyFrom.isMetStation());
        this.setIsObserved(copyFrom.isObserved());
        this.setNearestMeridian(copyFrom.getNearestMeridian());
        this.setReferenceElevation(copyFrom.getReferenceElevation());
        this.setStreamName(copyFrom.getStreamName());
        this.setNetworkElements(new ArrayList<WQObsStationNetworkElement>(copyFrom.getNetworkElements()));
    }

    public void setSnapToStream(boolean snapToStreamElement) {
        this._snapToStreamElement = snapToStreamElement;
    }

    public boolean isSnapToStreamElement() {
        return this._snapToStreamElement;
    }

    public void setStreamName(String streamName) {
        this._streamName = streamName;
    }

    public String getStreamName() {
        return this._streamName;
    }

    @JsonIgnore
    public int getId() {
        return this._id;
    }

    public void setId(int i) {
        this._id = i;
    }

    public List<ObsVariable> getVariables(Predicate<ObsVariable> predicate) {
        return this._variables.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<ObsVariable> getVariables() {
        return this._variables;
    }

    public void addVariable(ObsVariable variable) {
        this._variables.add(variable);
        Collections.sort(this._variables, new Comparator<ObsVariable>(){

            @Override
            public int compare(ObsVariable o1, ObsVariable o2) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
        });
    }

    public void removeVariable(ObsVariable variable) {
        this._variables.remove(variable);
    }

    public boolean hasConstituent(Constituent constituent) {
        for (ObsVariable var : this._variables) {
            WQObsConstituentVariable wqocv;
            int constitId;
            if (!(var instanceof WQObsConstituentVariable) || (constitId = (wqocv = (WQObsConstituentVariable)var).getConstituentId()) != constituent.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean active) {
        boolean oldActive = this._isActive;
        this._isActive = active;
        this._propertyChangeSupport.firePropertyChange("active", oldActive, this._isActive);
    }

    @JsonIgnore
    public boolean isMetStation() {
        return this._isMetStation;
    }

    public void setIsMetStation(boolean isMetStation) {
        this._isMetStation = isMetStation;
    }

    @JsonIgnore
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonIgnore
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setGeometry(Geometry geometry) {
        this._geometry = geometry;
    }

    public Geometry getGeometry() {
        return this._geometry;
    }

    @JsonIgnore
    public double getLatitude() {
        return this._latitude;
    }

    @JsonIgnore
    public double getLongitude() {
        return this._longitude;
    }

    @JsonIgnore
    public int getNearestMeridian() {
        return this._nearestMeridian;
    }

    @JsonIgnore
    public double getReferenceElevation() {
        return this._referenceElevation;
    }

    public void setReferenceElevation(double refElevation) {
        this._referenceElevation = refElevation;
    }

    public void setLatitude(double latitude) {
        this._latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this._longitude = longitude;
    }

    public void setNearestMeridian(int nearestMeridian) {
        this._nearestMeridian = nearestMeridian;
    }

    @JsonIgnore
    public boolean isObserved() {
        return this._isObserved;
    }

    public void setIsObserved(boolean isObserved) {
        this._isObserved = isObserved;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    @JsonIgnore
    public List<WQObsStationNetworkElement> getNetworkElements() {
        return new ArrayList<WQObsStationNetworkElement>(this._networkElements);
    }

    @JsonIgnore
    public void addNetworkElement(WQObsStationNetworkElement networkElement) {
        this._networkElements.add(networkElement);
    }

    public String toString() {
        return this.getName();
    }

    @JsonIgnore
    public void setStationIconLocation(WorldPt stationIconLocation) {
        if (stationIconLocation != null) {
            this._stationIconLongitude = stationIconLocation.e;
            this._stationIconLatitude = stationIconLocation.n;
        }
    }

    @JsonIgnore
    public double getStationIconLatitude() {
        return this._stationIconLatitude;
    }

    @JsonIgnore
    public double getStationIconLongitude() {
        return this._stationIconLongitude;
    }

    @JsonIgnore
    public WorldPt getStationIconLocation() {
        WorldPt retVal = null;
        if (this.getStationIconLongitude() != 0.0 || this.getStationIconLatitude() != 0.0) {
            retVal = new WorldPt(this.getStationIconLongitude(), this.getStationIconLatitude());
        }
        return retVal;
    }

    @JsonIgnore
    public void clearNetworkElements() {
        this._networkElements.clear();
    }

    @JsonIgnore
    public void setStreamStation(double streamStation) {
        this._streamStation = streamStation;
    }

    @JsonIgnore
    public double getStreamStation() {
        return this._streamStation;
    }

    public void setIsProfileStation(boolean isProfileStation) {
        this._isProfileStation = isProfileStation;
    }

    @JsonIgnore
    public boolean isProfileStation() {
        return this._isProfileStation;
    }

    public void setNetworkElements(List<WQObsStationNetworkElement> networkElements) {
        this._networkElements.clear();
        this._networkElements.addAll(networkElements);
    }

    public WQObsStationNetworkElement getNetworkElement(int networkId) {
        WQObsStationNetworkElement retVal = null;
        for (WQObsStationNetworkElement networkElement : this._networkElements) {
            if (networkElement.getNetworkId() != networkId) continue;
            retVal = networkElement;
            break;
        }
        return retVal;
    }
}

