/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.observed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.geometry.Geometry;
import hec.wqenginecore.geometry.SubDomain;
import hec.wqenginecore.geometry.SubDomainType;
import hec.wqenginecore.observed.ObsStation;
import hec.wqenginecore.observed.ObsStationSet;
import hec.wqenginecore.observed.ObsVariable;
import hec.wqengineimpl.observed.WQObsConstituentVariable;
import hec.wqengineimpl.observed.WQObsStation;
import hec.wqengineimpl.observed.WQObsStationNetworkElement;
import hec.wqengineimpl.observed.WQObsUserVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@JsonPropertyOrder(value={"id", "name", "description", "stations"})
public class WQObsStationSet
implements ObsStationSet {
    @JsonProperty(value="id")
    private int _id = -1;
    @JsonProperty(value="name")
    private String _name = "";
    @JsonProperty(value="description")
    private String _description = "";
    private List<WQObsUserVariable> _userVariables = new ArrayList<WQObsUserVariable>();
    private final List<ObsStation> _obsStations = new ArrayList<ObsStation>();

    public WQObsStationSet() {
    }

    public WQObsStationSet(String name, String description, List<WQObsStation> obsStations) {
        this._name = name;
        this._obsStations.addAll(obsStations);
        this._description = description;
    }

    public List<WQObsUserVariable> getUserDefinedVariables() {
        return this._userVariables;
    }

    public void setUserDefinedVariables(List<WQObsUserVariable> vars) {
        this._userVariables.clear();
        this._userVariables.addAll(vars);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @JsonIgnore
    public int getId() {
        return this._id;
    }

    public void setId(int i) {
        this._id = i;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JsonDeserialize(contentAs=WQObsStation.class)
    @JsonSerialize(contentAs=WQObsStation.class)
    public List<ObsStation> getStations() {
        return this._obsStations;
    }

    @JsonIgnore
    public List<ObsStation> getActiveStations() {
        return this.getStations(ObsStation::isActive);
    }

    public void addStation(WQObsStation obsStation) {
        this._obsStations.add(obsStation);
    }

    public <T extends ObsStation> List<T> getStations(Predicate<T> query) {
        return this._obsStations.stream().map(s -> s).filter(query).collect(Collectors.toList());
    }

    public WQConsistencyCheck checkConsistency(int networkId, Geometry geo, ConstituentSet constitSet) {
        String datasetName = "Water Quality Observed Data Set: " + this.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        if (geo == null) {
            consistencyCheck.addErrorMessage("Missing dependent Water Quality Geometry");
            return consistencyCheck;
        }
        if (constitSet == null) {
            String errorMessage = "Missing dependent Constituent Set";
            consistencyCheck.addErrorMessage(errorMessage);
            return consistencyCheck;
        }
        for (ObsStation obsStation : this.getActiveStations()) {
            List obsVariables;
            WQObsStationNetworkElement osne = ((WQObsStation)obsStation).getNetworkElement(networkId);
            if (osne == null) {
                String warningMsg = "Observed Station " + obsStation.getName() + " is not mapped to an element in the active Network";
                consistencyCheck.addWarningMessage(warningMsg);
                continue;
            }
            int elemId = osne.getElementId();
            if (((WQObsStation)obsStation).isProfileStation()) {
                List activeWQSubDomains = geo.getSubDomainsInExtent();
                boolean found = false;
                for (SubDomain sd : activeWQSubDomains) {
                    if (sd.getType() != SubDomainType.RESERVOIR_1DV || sd.getElementId() != elemId) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    String warningMsg = "Observed Profile Station " + obsStation.getName() + " is not mapped to a Reservoir element in the active WQ Geometry";
                    consistencyCheck.addWarningMessage(warningMsg);
                    continue;
                }
            }
            if ((obsVariables = obsStation.getVariables()).isEmpty()) {
                String warningMsg = "Observed Station " + obsStation.getName() + " has no observed variables";
                consistencyCheck.addWarningMessage(warningMsg);
            }
            for (ObsVariable obsVariable : obsVariables) {
                if (!(obsVariable instanceof WQObsConstituentVariable)) continue;
                int obsConstitId = ((WQObsConstituentVariable)obsVariable).getConstituentId();
                String constitName = obsVariable.getDisplayName();
                if (constitSet.hasConstituent(Integer.valueOf(obsConstitId))) continue;
                String warningMsg = "Constituent " + constitName + " not found in active Constituent Set";
                consistencyCheck.addWarningMessage(warningMsg);
            }
        }
        return consistencyCheck;
    }

    public void setObsStations(List<ObsStation> obsStations) {
        this._obsStations.clear();
        this._obsStations.addAll(obsStations);
    }

    public String toString() {
        return this.getName();
    }
}

