/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.observed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.dataSource.Data;
import hec.wqenginecore.dataSource.constant.ConstantData;
import hec.wqenginecore.dataSource.excel.ExcelData;
import hec.wqenginecore.dataSource.table.TableData;
import hec.wqenginecore.dataSource.timeSeries.DssData;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.observed.ObsVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public abstract class WQObsVariable
implements ObsVariable {
    @JsonProperty(value="datasource")
    protected List<Data> _dataSources = new ArrayList<Data>();
    @JsonProperty(value="selectedDataSourceName")
    private String _selectedDataSourceName = "";

    WQObsVariable() {
    }

    public void setSelectedDataSourceName(String selectedDataSourceName) {
        this._selectedDataSourceName = selectedDataSourceName;
    }

    private void addDataSource(Data obj) {
        Objects.requireNonNull(obj, "Null Datasource being added.");
        this._dataSources.add(obj);
    }

    public List<Data> getDataSources() {
        for (Data data : this._dataSources) {
            if (data instanceof TableData) {
                ((TableData)data).setVariableName(this.getDisplayName());
                continue;
            }
            if (!(data instanceof DssData)) continue;
            ((DssData)data).setHasInterpretedUnits(false);
        }
        return this._dataSources;
    }

    public String getSelectedDataSourceName() {
        return this._selectedDataSourceName;
    }

    @JsonIgnore
    public Data getSelectedData() {
        String name = this.getSelectedDataSourceName();
        return this.getDataSources().stream().filter(d -> Objects.equals(d.getName(), name)).findFirst().orElse(null);
    }

    protected void addDataSources() {
        String[] units = new String[]{this.getUnits()};
        TableData tableData = new TableData();
        tableData.setAvailableUnits(units);
        this.addDataSource((Data)tableData);
        DssData tsData = new DssData(false);
        tsData.setAvailableUnits(units);
        this.addDataSource((Data)tsData);
        ExcelData excelData = new ExcelData();
        excelData.setAvailableUnits(units);
        this.addDataSource((Data)excelData);
        ConstantData constantData = new ConstantData();
        constantData.setAvailableUnits(units);
        this.addDataSource((Data)constantData);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQObsVariable.class);
        }
    }
}

