/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.parameter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Constituent;
import hec.wqenginecore.ConstituentSet;
import hec.wqenginecore.WQConsistencyCheck;
import hec.wqenginecore.geometry.RegionRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqenginecore.parameter.Parameter;
import hec.wqenginecore.parameter.ParameterOption;
import hec.wqenginecore.parameter.ParameterOptionSetting;
import hec.wqenginecore.parameter.ParameterSet;
import hec.wqenginecore.parameter.ParameterSetting;
import hec.wqengineimpl.WQLibraryRegistryImpl;
import hec.wqengineimpl.geometry.WQRegionRef;
import hec.wqengineimpl.libraries.BaseWQLibrary;
import hec.wqengineimpl.parameter.WQParameter;
import hec.wqengineimpl.parameter.WQParameterOptionSetting;
import hec.wqengineimpl.parameter.WQParameterSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonPropertyOrder(value={"name", "description"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQParameterSet
implements ParameterSet {
    private String _name = "";
    private String _description = "";
    private Set<Integer> _parameterIds = new LinkedHashSet<Integer>();
    private Set<Integer> _parameterOptionIds = new LinkedHashSet<Integer>();
    private Map<Integer, WQParameterSetting> _parameterSettings = new LinkedHashMap<Integer, WQParameterSetting>();
    private Map<RegionRef, Map<Integer, WQParameterSetting>> _regionParameterSettings = new LinkedHashMap<RegionRef, Map<Integer, WQParameterSetting>>();
    private Map<Integer, WQParameterOptionSetting> _parameterOptionSettings = new LinkedHashMap<Integer, WQParameterOptionSetting>();
    private Map<RegionRef, Map<Integer, WQParameterOptionSetting>> _regionParameterOptionSettings = new LinkedHashMap<RegionRef, Map<Integer, WQParameterOptionSetting>>();

    public WQParameterSet() {
    }

    public WQParameterSet(String name, String description) {
        this._name = name;
        this._description = description;
    }

    public WQConsistencyCheck checkConsistency(ConstituentSet constitSet) {
        String warningMessage;
        String datasetName = "Water Quality Parameter Set: " + this.getName();
        WQConsistencyCheck consistencyCheck = new WQConsistencyCheck(datasetName);
        if (constitSet == null) {
            String errorMessage = "Missing dependent Constituent Set";
            consistencyCheck.addErrorMessage(errorMessage);
            return consistencyCheck;
        }
        List<Integer> pidList = this.getParameterIdsForConstituentSet(constitSet);
        List<Integer> pidoList = this.getParameterOptionIdsForConstituentSet(constitSet);
        Set<String> libraryNames = this.getLibraryNamesForConstituentSet(constitSet);
        HashSet<Parameter> params = new HashSet<Parameter>();
        HashSet<ParameterOption> paramOpts = new HashSet<ParameterOption>();
        for (String libraryName : libraryNames) {
            BaseWQLibrary paramLib = this.getLibrary(libraryName);
            if (paramLib != null) {
                params.addAll(paramLib.getParameters(constitSet));
                paramOpts.addAll(paramLib.getParameterOptions(constitSet));
                continue;
            }
            String errorMessage = "Parameter library: " + libraryName + " not found for constituent set: " + constitSet.getName();
            consistencyCheck.addErrorMessage(errorMessage);
        }
        Iterator<Object> iterator = pidList.iterator();
        while (iterator.hasNext()) {
            int pid = (Integer)iterator.next();
            ParameterSetting ps = this.getParameterSetting(pid);
            if (ps != null && ps.getParameterValue() != null) continue;
            Parameter param = params.stream().filter(p -> p.getId() == pid).findFirst().orElse(null);
            warningMessage = param != null ? "Parameter: " + param.getDescription() + " has no defined value. Using default value" : "Parameter id: " + pid + " has no defined value. Using default value";
            consistencyCheck.addWarningMessage(warningMessage);
        }
        iterator = pidoList.iterator();
        while (iterator.hasNext()) {
            int pido = (Integer)iterator.next();
            WQParameterOptionSetting pos = this.getParameterOptionSetting(pido);
            ParameterOption paramOpt = paramOpts.stream().filter(p -> p.getId() == pido).findFirst().orElse(null);
            if (pos != null && pos.getOption() != null) continue;
            warningMessage = paramOpt != null ? "Parameter option: " + paramOpt.getName() + " has no defined value" : "Parameter option id: " + pido + " has no defined value";
            consistencyCheck.addWarningMessage(warningMessage);
        }
        return consistencyCheck;
    }

    public Set<Parameter> getParametersForConstituentSet(ConstituentSet constitSet) {
        HashSet<Parameter> params = new HashSet<Parameter>();
        Set<String> libraryNames = this.getLibraryNamesForConstituentSet(constitSet);
        for (String libraryName : libraryNames) {
            BaseWQLibrary paramLib = this.getLibrary(libraryName);
            if (paramLib == null) continue;
            params.addAll(paramLib.getParameters(constitSet));
        }
        return params;
    }

    private Set<String> getLibraryNamesForConstituentSet(ConstituentSet constitSet) {
        TreeSet<String> libraryNames = new TreeSet<String>();
        Collection constituentList = constitSet.getConstituentList();
        for (Constituent constituent : constituentList) {
            libraryNames.add(constituent.getLibraryName());
        }
        return libraryNames;
    }

    private List<Integer> getParameterIdsForConstituentSet(ConstituentSet constitSet) {
        ArrayList<Integer> parameterIdList = new ArrayList<Integer>();
        Set<Parameter> params = this.getParametersForConstituentSet(constitSet);
        for (Parameter p : params) {
            parameterIdList.add(p.getId());
        }
        return parameterIdList;
    }

    private List<Integer> getParameterOptionIdsForConstituentSet(ConstituentSet constitSet) {
        ArrayList<Integer> parameterIdList = new ArrayList<Integer>();
        Set<String> libraryNames = this.getLibraryNamesForConstituentSet(constitSet);
        for (String libraryName : libraryNames) {
            BaseWQLibrary paramLib = this.getLibrary(libraryName);
            if (paramLib == null) continue;
            Set<ParameterOption> paramOpt = paramLib.getParameterOptions(constitSet);
            for (ParameterOption po : paramOpt) {
                parameterIdList.add(po.getId());
            }
        }
        return parameterIdList;
    }

    private BaseWQLibrary getLibrary(String libraryName) {
        WQLibraryRegistryImpl library = new WQLibraryRegistryImpl();
        return (BaseWQLibrary)library.getLibrary(libraryName);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String text) {
        this._name = text;
    }

    public String getDescription() {
        return this._description;
    }

    public Set<Integer> getParameterIds() {
        return Collections.unmodifiableSet(this._parameterIds);
    }

    public void setParameterIds(Collection<Integer> newList) {
        this._parameterIds.clear();
        if (newList != null) {
            this._parameterIds.addAll(newList);
        }
    }

    public Set<Integer> getParameterOptionIds() {
        return Collections.unmodifiableSet(this._parameterOptionIds);
    }

    public void setParameterOptionIds(Collection<Integer> newList) {
        this._parameterOptionIds.clear();
        if (newList != null) {
            this._parameterOptionIds.addAll(newList);
        }
    }

    public void setDescription(String text) {
        this._description = text;
    }

    public void addParameterId(WQParameter wqp) {
        if (wqp != null) {
            int id = wqp.getId();
            this.addParameterId(id);
        }
    }

    public void addParameterId(int id) {
        this._parameterIds.add(id);
    }

    public void removeParameterId(int id) {
        this._parameterIds.remove(id);
    }

    public void addParameterOptionId(int id) {
        this._parameterOptionIds.add(id);
    }

    public void removeParameterOptionId(int id) {
        this._parameterOptionIds.remove(id);
    }

    public Collection<WQParameterSetting> getParameterSettings() {
        return this._parameterSettings.values();
    }

    public void setParameterSettings(Collection<WQParameterSetting> settings) {
        this._parameterSettings.clear();
        if (settings != null) {
            settings.stream().filter(Objects::nonNull).forEach(s -> this._parameterSettings.put(s.getParameterId(), (WQParameterSetting)s));
        }
    }

    public ParameterSetting getParameterSetting(int parameterId) {
        return this._parameterSettings.get(parameterId);
    }

    public void addParameterSetting(WQParameterSetting setting) {
        if (setting != null) {
            this._parameterSettings.put(setting.getParameterId(), setting);
        }
    }

    public void addParameterOptionSetting(WQParameterOptionSetting setting) {
        if (setting != null) {
            this._parameterOptionSettings.put(setting.getParameterOptionId(), setting);
        }
    }

    public void addParameterSetting(RegionRef ref, WQParameterSetting setting) {
        if (setting != null) {
            Map map = this._regionParameterSettings.computeIfAbsent(ref, v -> new LinkedHashMap());
            map.put(setting.getParameterId(), setting);
        }
    }

    public void removeParameterSetting(RegionRef ref, int id) {
        Map<Integer, WQParameterSetting> map = this._regionParameterSettings.get(ref);
        if (map != null) {
            map.remove(id);
        }
    }

    public void removeParameterOptionSetting(RegionRef ref, int id) {
        Map<Integer, WQParameterOptionSetting> map = this._regionParameterOptionSettings.get(ref);
        if (map != null) {
            map.remove(id);
        }
    }

    public void addParameterOptionSetting(RegionRef ref, WQParameterOptionSetting setting) {
        if (setting != null) {
            Map map = this._regionParameterOptionSettings.computeIfAbsent(ref, v -> new LinkedHashMap());
            map.put(setting.getParameterOptionId(), setting);
        }
    }

    public void removeParameterSetting(int id) {
        this._parameterSettings.remove(id);
    }

    public Collection<WQParameterOptionSetting> getParameterOptionSettings() {
        return this._parameterOptionSettings.values();
    }

    public ParameterSetting getParameterSetting(int parameterId, RegionRef regionRef) {
        ParameterSetting retval = null;
        Map<Integer, WQParameterSetting> settingMap = this._regionParameterSettings.get(regionRef);
        if (settingMap != null) {
            retval = settingMap.get(parameterId);
        }
        return retval;
    }

    public void setParameterSetting(RegionRef ref, WQParameterSetting setting) {
        Map map = this._regionParameterSettings.computeIfAbsent(ref, v -> new LinkedHashMap());
        map.put(setting.getParameterId(), setting);
    }

    public void setParameterSettings(RegionRef ref, Collection<WQParameterSetting> settings) {
        Map map = this._regionParameterSettings.computeIfAbsent(ref, v -> new LinkedHashMap());
        map.clear();
        for (WQParameterSetting setting : settings) {
            if (setting == null) continue;
            map.put(setting.getParameterId(), setting);
        }
    }

    public Collection<? extends ParameterSetting> getParameterSettings(RegionRef regionRef) {
        Collection<Object> retval = Collections.emptySet();
        Map<Integer, WQParameterSetting> settingMap = this._regionParameterSettings.get(regionRef);
        if (settingMap != null) {
            retval = settingMap.values();
        }
        return retval;
    }

    public ParameterOptionSetting getParameterOptionSetting(int parameterOptionId, RegionRef regionRef) {
        ParameterOptionSetting retval = null;
        Map<Integer, WQParameterOptionSetting> map = this._regionParameterOptionSettings.get(regionRef);
        if (map != null) {
            retval = map.get(parameterOptionId);
        }
        return retval;
    }

    public void setParameterOptionSetting(RegionRef regionRef, WQParameterOptionSetting setting) {
        Map map = this._regionParameterOptionSettings.computeIfAbsent(regionRef, v -> new LinkedHashMap());
        map.put(setting.getParameterOptionId(), setting);
    }

    public Collection<? extends ParameterOptionSetting> getParameterOptionSettings(RegionRef regionRef) {
        Map<Integer, WQParameterOptionSetting> map = this._regionParameterOptionSettings.get(regionRef);
        if (map != null) {
            return map.values();
        }
        return Collections.emptySet();
    }

    public void setParameterOptionSettings(RegionRef regionRef, Collection<WQParameterOptionSetting> settings) {
        Map map = this._regionParameterOptionSettings.computeIfAbsent(regionRef, v -> new LinkedHashMap());
        map.clear();
        settings.stream().filter(Objects::nonNull).forEach(s -> map.put(s.getParameterOptionId(), s));
    }

    public void setParameterOptionSettings(Collection<WQParameterOptionSetting> optionSettings) {
        this._parameterOptionSettings.clear();
        if (optionSettings != null) {
            optionSettings.stream().filter(Objects::nonNull).forEach(s -> this._parameterOptionSettings.put(s.getParameterOptionId(), (WQParameterOptionSetting)s));
        }
    }

    public WQParameterOptionSetting getParameterOptionSetting(int parameterOptionId) {
        return this._parameterOptionSettings.get(parameterOptionId);
    }

    public List<RegionParameterSettings> getRegionParameterSettings() {
        return this._regionParameterSettings.entrySet().stream().map(e -> new RegionParameterSettings((WQRegionRef)e.getKey(), ((Map)e.getValue()).values())).collect(Collectors.toList());
    }

    public void setRegionParameterSettings(List<RegionParameterSettings> entries) {
        this._regionParameterSettings.clear();
        if (entries != null) {
            for (RegionParameterSettings entry : entries) {
                Map map = this._regionParameterSettings.computeIfAbsent(entry.getRegionRef(), v -> new LinkedHashMap());
                List<WQParameterSetting> settings = entry.getParameterSettings();
                for (WQParameterSetting setting : settings) {
                    map.put(setting.getParameterId(), setting);
                }
            }
        }
    }

    public List<RegionParameterOptionSettings> getRegionParameterOptionSettings() {
        return this._regionParameterOptionSettings.entrySet().stream().map(e -> new RegionParameterOptionSettings((WQRegionRef)e.getKey(), ((Map)e.getValue()).values())).collect(Collectors.toList());
    }

    public void setRegionParameterOptionSettings(List<RegionParameterOptionSettings> entries) {
        this._regionParameterOptionSettings.clear();
        if (entries != null) {
            for (RegionParameterOptionSettings entry : entries) {
                Map map = this._regionParameterOptionSettings.computeIfAbsent(entry.getRegionRef(), v -> new LinkedHashMap());
                List<WQParameterOptionSetting> settings = entry.getParameterOptionSettings();
                for (WQParameterOptionSetting setting : settings) {
                    map.put(setting.getParameterOptionId(), setting);
                }
            }
        }
    }

    @JsonIgnore
    public String toString() {
        return this.getName();
    }

    public static class RegionParameterSettings {
        WQRegionRef _regionRef;
        List<WQParameterSetting> _parameterSettings = new ArrayList<WQParameterSetting>();

        public RegionParameterSettings() {
        }

        public RegionParameterSettings(WQRegionRef regionRef, Collection<WQParameterSetting> parmeterSettings) {
            this._regionRef = regionRef;
            if (parmeterSettings != null) {
                this._parameterSettings.addAll(parmeterSettings);
            }
        }

        public WQRegionRef getRegionRef() {
            return this._regionRef;
        }

        public void setRegionRef(WQRegionRef regionRef) {
            this._regionRef = regionRef;
        }

        public List<WQParameterSetting> getParameterSettings() {
            return this._parameterSettings;
        }

        public void setParameterSettings(List<WQParameterSetting> parmeterSettings) {
            this._parameterSettings = parmeterSettings;
        }
    }

    public static class RegionParameterOptionSettings {
        WQRegionRef _regionRef;
        List<WQParameterOptionSetting> _parameterOptionSettings = new ArrayList<WQParameterOptionSetting>();

        public RegionParameterOptionSettings() {
        }

        public RegionParameterOptionSettings(WQRegionRef regionRef, Collection<WQParameterOptionSetting> parmeterSettings) {
            this._regionRef = regionRef;
            if (parmeterSettings != null) {
                this._parameterOptionSettings.addAll(parmeterSettings);
            }
        }

        public WQRegionRef getRegionRef() {
            return this._regionRef;
        }

        public void setRegionRef(WQRegionRef regionRef) {
            this._regionRef = regionRef;
        }

        public List<WQParameterOptionSetting> getParameterOptionSettings() {
            return this._parameterOptionSettings;
        }

        public void setParameterOptionSettings(List<WQParameterOptionSetting> parmeterSettings) {
            this._parameterOptionSettings = parmeterSettings;
        }
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQParameterSet.class);
        }
    }
}

