/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.parameter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import hec.wqenginecore.parameter.ParameterSettingValue;
import hec.wqengineimpl.parameter.WQParameterSettingDSSValue;
import hec.wqengineimpl.parameter.WQParameterSettingDoubleValue;
import hec.wqengineimpl.parameter.WQParameterSettingSeasonalVariationValue;
import hec.wqengineimpl.parameter.WQParameterSettingStateVariableValue;
import java.io.IOException;

public class WQParameterValueDeserializer
extends JsonDeserializer<ParameterSettingValue<?>> {
    public ParameterSettingValue<?> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        block21: {
            JsonNode node;
            block20: {
                String type;
                node = (JsonNode)parser.getCodec().readTree(parser);
                if (node.isDouble()) {
                    WQParameterSettingDoubleValue doubleValue = new WQParameterSettingDoubleValue();
                    doubleValue.setValue(node.doubleValue());
                    return doubleValue;
                }
                if (!node.isObject()) break block20;
                JsonNode typeNode = node.get("type");
                if (typeNode == null) break block21;
                switch (type = typeNode.asText()) {
                    case "Value": {
                        return (ParameterSettingValue)parser.getCodec().treeToValue((TreeNode)node, WQParameterSettingDoubleValue.class);
                    }
                    case "Table": {
                        return (ParameterSettingValue)parser.getCodec().treeToValue((TreeNode)node, WQParameterSettingSeasonalVariationValue.class);
                    }
                    case "Time Series": {
                        JsonNode timeSeriesTypeNode = node.get("timeSeriesType");
                        if (timeSeriesTypeNode != null) {
                            String timeSeriesType;
                            switch (timeSeriesType = timeSeriesTypeNode.asText()) {
                                case "DSS": {
                                    return (ParameterSettingValue)parser.getCodec().treeToValue((TreeNode)node, WQParameterSettingDSSValue.class);
                                }
                                case "State Variable": {
                                    return (ParameterSettingValue)parser.getCodec().treeToValue((TreeNode)node, WQParameterSettingStateVariableValue.class);
                                }
                            }
                            throw new IOException("Unknown timeSeriesType: " + timeSeriesType + ". Likely need to update " + ((Object)((Object)this)).getClass().getSimpleName() + " to handle this type.");
                        }
                        break block21;
                    }
                    default: {
                        throw new IOException("Unknown type: " + type);
                    }
                }
            }
            throw new IOException("Unexpected format for value field: " + node);
        }
        return new WQParameterSettingDoubleValue(Double.NEGATIVE_INFINITY);
    }
}

