/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.region;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.region.WQRegion;
import hec.wqengineimpl.region.WQRegionSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQDefaultRegion
extends WQRegion {
    @JsonCreator
    public WQDefaultRegion(@JsonProperty(value="parent") WQRegionSet parent) {
        super(0, parent, "Default Region", null);
    }

    @Override
    @JsonIgnore
    public String getName() {
        return super.getName();
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    @JsonIgnore
    public int getId() {
        return super.getId();
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException("Cannot edit the name of the default region");
    }

    @Override
    public void setDescription(String desc) {
        throw new UnsupportedOperationException("Cannot edit the description of the default region");
    }

    @Override
    public void add(SubDomainRef domain) {
        if (!this._subDomains.contains(domain)) {
            this._parent.remove(domain);
        }
        this._subDomains.add(domain);
    }

    @Override
    public void remove(SubDomainRef domain) {
        this._subDomains.remove(domain);
    }

    @Override
    public void removeAll(Collection<? extends SubDomainRef> c) {
        this._subDomains.removeAll(c);
    }

    @Override
    public void addAll(Collection<? extends SubDomainRef> c) {
        LinkedHashSet<? extends SubDomainRef> notPresent = new LinkedHashSet<SubDomainRef>(c);
        notPresent.removeAll(this._subDomains);
        if (!notPresent.isEmpty()) {
            this._parent.removeAll(notPresent);
            this._subDomains.addAll(notPresent);
        }
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQDefaultRegion.class);
        }
    }
}

