/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.region;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Region;
import hec.wqenginecore.geometry.RegionRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQSubDomainRef;
import hec.wqengineimpl.region.WQRegionSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQRegion
implements Region {
    private final int _id;
    private String _name = "";
    private String _description;
    @JsonIgnore
    protected Set<SubDomainRef> _subDomains = new LinkedHashSet<SubDomainRef>();
    @JsonBackReference
    protected WQRegionSet _parent;

    @JsonCreator
    public WQRegion(@JsonProperty(value="id") int id, @JsonProperty(value="parent") WQRegionSet parent) {
        this._id = id;
        this._parent = parent;
    }

    public WQRegion(int id, WQRegionSet parent, String name, String description) {
        this._id = id;
        this._parent = parent;
        this._name = name;
        this._description = description;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setParent(WQRegionSet set) {
        this._parent = set;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public int getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    @JsonDeserialize(contentAs=WQSubDomainRef.class)
    @JsonSerialize(contentAs=WQSubDomainRef.class)
    public Set<SubDomainRef> getElements() {
        return Collections.unmodifiableSet(this._subDomains);
    }

    public void setElements(Collection<? extends SubDomainRef> c) {
        this._subDomains.clear();
        this._subDomains.addAll(c);
    }

    public void add(SubDomainRef domain) {
        WQRegion defaultRegion = this._parent.getDefaultRegion();
        if (defaultRegion != this) {
            defaultRegion.remove(domain);
        }
        this._subDomains.add(domain);
    }

    public void remove(SubDomainRef domain) {
        if (this._subDomains.contains(domain)) {
            this._subDomains.remove(domain);
            WQRegion defaultRegion = this._parent.getDefaultRegion();
            if (defaultRegion != this) {
                defaultRegion.add(domain);
            }
        }
    }

    public void removeAll(Collection<? extends SubDomainRef> c) {
        LinkedHashSet<? extends SubDomainRef> contains = new LinkedHashSet<SubDomainRef>(c);
        contains.retainAll(this._subDomains);
        this._subDomains.removeAll(contains);
        WQRegion defaultRegion = this._parent.getDefaultRegion();
        if (defaultRegion != this && !contains.isEmpty()) {
            defaultRegion.addAll(contains);
        }
    }

    public void addAll(Collection<? extends SubDomainRef> c) {
        WQRegion defaultRegion = this._parent.getDefaultRegion();
        if (defaultRegion != this && !c.isEmpty()) {
            defaultRegion.removeAll(c);
        }
        this._subDomains.addAll(c);
    }

    public void clear() {
        if (!this._subDomains.isEmpty()) {
            this._parent.addToDefault(this._subDomains);
            this._subDomains.clear();
        }
    }

    public boolean contains(SubDomainRef ref) {
        return this._subDomains.contains(ref);
    }

    public RegionRef buildRef() {
        return this._parent.buildRef(this);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQRegion.class);
        }
    }
}

