/*
 * Decompiled with CFR 0.152.
 */
package hec.wqengineimpl.region;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import hec.wqenginecore.Region;
import hec.wqenginecore.RegionSet;
import hec.wqenginecore.geometry.RegionRef;
import hec.wqenginecore.geometry.SubDomainRef;
import hec.wqenginecore.jackson.TypeResolver;
import hec.wqengineimpl.geometry.WQRegionRef;
import hec.wqengineimpl.region.WQDefaultRegion;
import hec.wqengineimpl.region.WQRegion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import rma.services.annotations.ServiceProvider;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonTypeIdResolver(value=TypeResolver.class)
public class WQRegionSet
implements RegionSet {
    public static final int DEFAULT_ID = 0;
    private final WQRegion _defaultRegion;
    private int _geometryId;
    @JsonManagedReference
    private List<WQRegion> _regions = new ArrayList<WQRegion>();

    public WQRegionSet() {
        this._defaultRegion = new WQDefaultRegion(this);
    }

    public WQRegionSet(Collection<? extends SubDomainRef> domainList) {
        this();
        this._defaultRegion.addAll(domainList);
    }

    public int getGeometryId() {
        return this._geometryId;
    }

    public void setGeometryId(int geometryId) {
        this._geometryId = geometryId;
    }

    public WQRegion createRegion(String name, String description) {
        WQRegion retval = new WQRegion(this._regions.size() + 1, this, name, description);
        this._regions.add(retval);
        return retval;
    }

    public void delete(WQRegion region) {
        if (region == this._defaultRegion) {
            throw new IllegalArgumentException("Cannot delete the default region");
        }
        if (region != null) {
            Collection elements = region.getElements();
            region.removeAll(new ArrayList(elements));
            this._defaultRegion.addAll(elements);
            this._regions.remove(region);
        }
    }

    public void addToDefault(SubDomainRef domain) {
        this._defaultRegion.add(domain);
    }

    public void addToDefault(Collection<SubDomainRef> c) {
        this._defaultRegion.addAll(c);
    }

    public void move(SubDomainRef domain, WQRegion dest) {
        WQRegion owner = this.getRegion(domain);
        owner.remove(domain);
        dest.add(domain);
    }

    public WQRegion getRegion(SubDomainRef domainRef) {
        WQRegion retval = null;
        for (WQRegion region : this._regions) {
            if (!region.contains(domainRef)) continue;
            retval = region;
        }
        if (retval == null) {
            retval = this._defaultRegion;
        }
        return retval;
    }

    @JsonIgnore
    public WQRegion getDefaultRegion() {
        return this._defaultRegion;
    }

    public void setDefaultRegion(WQRegion newDefault) {
        this._defaultRegion.clear();
        this._defaultRegion.addAll(newDefault.getElements());
    }

    public List<WQRegion> getRegions() {
        ArrayList<WQRegion> retval = new ArrayList<WQRegion>();
        retval.add(this._defaultRegion);
        if (!this._regions.isEmpty()) {
            retval.addAll(this._regions);
        }
        return Collections.unmodifiableList(retval);
    }

    public void setRegions(List<WQRegion> regions) {
        WQRegion newDefault = regions.stream().filter(r -> r.getId() == 0).findFirst().orElse(null);
        this._regions.clear();
        this._regions.addAll(regions.stream().filter(r -> r.getId() != 0).collect(Collectors.toList()));
        if (newDefault != null) {
            this.setDefaultRegion(newDefault);
        }
    }

    public RegionRef buildRef(Region region) {
        return new WQRegionRef(this._geometryId, region.getId(), region.getName());
    }

    public Region getRegion(RegionRef ref) {
        return ref.getRegion((RegionSet)this);
    }

    public Region getRegion(int id) {
        if (id == 0) {
            return this._defaultRegion;
        }
        return this._regions.stream().filter(r -> id == r.getId()).findFirst().orElse(null);
    }

    public void addToDefaultIfAbsent(Collection<? extends SubDomainRef> refs) {
        for (SubDomainRef subDomainRef : refs) {
            this.addToDefaultIfAbsent(subDomainRef);
        }
    }

    public void addToDefaultIfAbsent(SubDomainRef ref) {
        WQRegion region = this.getRegion(ref);
        if (region == this._defaultRegion) {
            this._defaultRegion.add(ref);
        }
    }

    public boolean contains(SubDomainRef ref) {
        return this.getRegions().stream().anyMatch(r -> r.contains(ref));
    }

    public void remove(SubDomainRef ref) {
        this._regions.stream().forEach(r -> r.remove(ref));
        this._defaultRegion.remove(ref);
    }

    public void removeAll(Collection<? extends SubDomainRef> refs) {
        this._regions.stream().forEach(r -> r.removeAll(refs));
        this._defaultRegion.removeAll(refs);
    }

    @JsonIgnore
    public List<WQRegion> getNonDefaultRegions() {
        return Collections.unmodifiableList(this._regions);
    }

    @ServiceProvider(service=TypeResolver.TypeResolverRegistration.class)
    public static class Resolver
    extends TypeResolver.BaseRegistration {
        public Resolver() {
            super(WQRegionSet.class);
        }
    }
}

