/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.lang.LoginException;
import hec.security.UserProfile;
import hec.serversuite.ClientCacException;
import hec.serversuite.CwmsCacUtil;
import hec.serversuite.LoginHandler;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsLoginUtil;
import hec.serversuite.data.CwmsServersStatus;
import hec.serversuite.data.LocalAuthenticationSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import mil.army.usace.hec.serversuite.ui.CwmsServiceStatusChecker;
import mil.army.usace.hec.serversuite.ui.ServerSuiteUiFactory;
import rma.swing.RmaJButton;
import rma.swing.RmaJDialog;
import rma.swing.TextEditDlg;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;
import usace.loading.gui.LoadingGui;
import usace.loading.gui.LoadingGuiFactory;

public final class CwmsLoginDialog
extends RmaJDialog {
    private static final Logger LOGGER = Logger.getLogger(CwmsLoginDialog.class.getName());
    private final JTextPane _jTextStatus = new JTextPane();
    private final JButton _textMessagesButton = new JButton("...");
    private final JComboBox<String> _jComboBoxUsername = new JComboBox();
    private final JButton _jButtonLogin = new JButton("OK");
    private final JPasswordField _jPasswordField = new PasswordField();
    private final JButton _jButtonCancel = new JButton("Cancel");
    private final JComboBox<CwmsAuthenticationSource> _jComboBoxServer = new JComboBox();
    private final RmaJButton _jButtonServerStatus = new RmaJButton("Status");
    private final JButton _jButtonLoginSetup = new JButton("Login Setup...");
    private final List<CwmsAuthenticationSource> _cwmsAuthenticationSources = new ArrayList<CwmsAuthenticationSource>();
    private final LoginHandler _loginHandler;
    private final LoadingGui<Component> _loadingGui;
    private final CwmsServiceStatusChecker _cwmsServiceStatusChecker = new CwmsServiceStatusChecker();
    private final Map<CwmsAuthenticationSource, CwmsServersStatus> _statusMap = new HashMap<CwmsAuthenticationSource, CwmsServersStatus>();
    private boolean _canceled;

    private CwmsLoginDialog(Window parentWindow, LoginHandler loginHandler) {
        super(parentWindow);
        this._loginHandler = loginHandler;
        this._loadingGui = LoadingGuiFactory.getLoadingGui((Component)((Object)this), (Preferences)Preferences.userRoot());
        this.initComponents();
    }

    public static CwmsLoginDialog displayLoginDialogAndSetup(Window window, List<CwmsAuthenticationSource> authenticationSources, LoginHandler loginHandler) {
        CwmsLoginDialog cwmsLoginDialog = CwmsLoginDialog.buildCwmsLoginDialog(window, authenticationSources, loginHandler);
        cwmsLoginDialog.setVisible(true);
        cwmsLoginDialog.actionPerformedSetup(null);
        return cwmsLoginDialog;
    }

    public static CwmsLoginDialog buildCwmsLoginDialog(Window window, List<CwmsAuthenticationSource> authenticationSources, LoginHandler loginHandler) {
        if (window == null) {
            window = Arrays.stream(Frame.getFrames()).filter(Window::isActive).findFirst().orElse(Arrays.stream(Frame.getFrames()).findFirst().orElse(null));
        }
        CwmsLoginDialog cwmsLoginDialog = new CwmsLoginDialog(window, loginHandler);
        if (window == null || window.getIconImages().isEmpty()) {
            cwmsLoginDialog.setIconImage(ServerSuiteUtil.getImageIcon());
        }
        cwmsLoginDialog.fillForm(authenticationSources);
        String lastLoginServer = CwmsLoginUtil.getLastLoginServer();
        authenticationSources.stream().filter(s -> s.getDisplayName().equals(lastLoginServer)).findAny().ifPresent(cwmsLoginDialog::setSelectedServer);
        return cwmsLoginDialog;
    }

    public static CwmsLoginDialog buildCwmsLoginDialog(Window window, boolean useLocal, LoginHandler loginHandler) {
        List cwmsAuthenticationSources = CwmsLoginUtil.buildPreferenceServers();
        if (useLocal && !cwmsAuthenticationSources.contains(LocalAuthenticationSource.getInstance())) {
            cwmsAuthenticationSources.add(0, LocalAuthenticationSource.getInstance());
        }
        return CwmsLoginDialog.buildCwmsLoginDialog(window, cwmsAuthenticationSources, loginHandler);
    }

    private void initComponents() {
        this.setTitle("CWMS Login");
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        Dimension dimension = new Dimension(520, 320);
        this.setSize(dimension);
        this.setMinimumSize(dimension);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel centralPanel = new JPanel();
        centralPanel.setLayout(new BorderLayout());
        centralPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        centralPanel.add((Component)this.buildHeader(), "North");
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BorderLayout(5, 5));
        lowerPanel.add((Component)this.buildLoginSetup(), "North");
        lowerPanel.add((Component)this.buildStatusPanel(), "Center");
        centralPanel.add((Component)lowerPanel, "Center");
        JLayer<JPanel> jLayer = new JLayer<JPanel>(centralPanel, this._loadingGui.getLayer());
        this.add(jLayer, "Center");
        this.addListeners();
        this.authenticationSourceSelected();
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (aComponent == CwmsLoginDialog.this._jComboBoxUsername || aComponent.getParent() == CwmsLoginDialog.this._jComboBoxUsername) {
                    return CwmsLoginDialog.this._jPasswordField;
                }
                return super.getComponentAfter(aContainer, aComponent);
            }
        });
    }

    private JLabel buildHeader() {
        Color foregroundColor = new Color(-10066279);
        JLabel jLabelHec = new JLabel();
        jLabelHec.setText("CWMS Login");
        jLabelHec.setHorizontalAlignment(0);
        jLabelHec.setHorizontalTextPosition(0);
        jLabelHec.setFont(new Font("Dialog", 1, 48));
        jLabelHec.setForeground(foregroundColor);
        return jLabelHec;
    }

    private JPanel buildStatusPanel() {
        Dimension prefDim = this._jTextStatus.getPreferredSize();
        prefDim.height *= 3;
        this._jTextStatus.setPreferredSize(prefDim);
        this._jTextStatus.setEditable(false);
        this._jTextStatus.setBackground(this.getContentPane().getBackground());
        JScrollPane scrollPane = new JScrollPane(this._jTextStatus);
        JPanel jPanelStatus = new JPanel(new BorderLayout(5, 0));
        jPanelStatus.add((Component)scrollPane, "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this._textMessagesButton);
        jPanelStatus.add((Component)panel, "East");
        return jPanelStatus;
    }

    private JPanel buildLoginSetup() {
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        JLabel jLabelUsername = new JLabel("Username:");
        jLabelUsername.setDisplayedMnemonic('U');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        retval.add((Component)jLabelUsername, gbc);
        jLabelUsername.setLabelFor(this._jComboBoxUsername);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        retval.add(this._jComboBoxUsername, gbc);
        this._jButtonLogin.setName("jButtonLogin");
        this._jButtonLogin.setActionCommand("Ok");
        this._jButtonLogin.setBackground(retval.getBackground());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        retval.add((Component)this._jButtonLogin, gbc);
        JLabel jLabelPassword = new JLabel("Password:");
        jLabelPassword.setDisplayedMnemonic('P');
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.gridx = 0;
        gbc.gridy = 1;
        retval.add((Component)jLabelPassword, gbc);
        jLabelPassword.setLabelFor(this._jPasswordField);
        this._jPasswordField.setMinimumSize(new Dimension(100, 20));
        this._jPasswordField.setEchoChar('*');
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.gridx = 1;
        gbc.gridy = 1;
        retval.add((Component)this._jPasswordField, gbc);
        this._jButtonCancel.setActionCommand("Cancel");
        this._jButtonCancel.setBackground(retval.getBackground());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        retval.add((Component)this._jButtonCancel, gbc);
        JLabel jLabelServer = new JLabel("Server:");
        jLabelServer.setDisplayedMnemonic('S');
        gbc = new GridBagConstraints();
        gbc.gridy = 5;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.gridx = 0;
        gbc.gridy = 3;
        retval.add((Component)jLabelServer, gbc);
        jLabelServer.setLabelFor(this._jComboBoxServer);
        this._jComboBoxServer.setEditable(false);
        this._jComboBoxServer.setRenderer(new CwmsServerComboBoxRenderer());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        retval.add(this._jComboBoxServer, gbc);
        this._jButtonServerStatus.setMnemonic('S');
        this._jButtonServerStatus.setActionCommand("ServerStatus");
        this._jButtonServerStatus.setBackground(retval.getBackground());
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = insets;
        retval.add((Component)this._jButtonServerStatus, gbc);
        this._jButtonLoginSetup.setMnemonic('L');
        this._jButtonLoginSetup.setActionCommand("LoginSetup");
        this._jButtonLoginSetup.setBackground(retval.getBackground());
        gbc = new GridBagConstraints();
        gbc.gridy = 7;
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = new Insets(20, 5, 5, 5);
        retval.add((Component)this._jButtonLoginSetup, gbc);
        return retval;
    }

    private void addListeners() {
        this.getRootPane().setDefaultButton(this._jButtonLogin);
        this._textMessagesButton.addActionListener(new MessagesButtonActionListener());
        this._jPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                CwmsLoginDialog.this._jPasswordField.selectAll();
            }
        });
        this._jComboBoxServer.addActionListener(e -> this.authenticationSourceSelected());
        this._jComboBoxUsername.addActionListener(e -> this.initSocketFactory());
        this.getRootPane().registerKeyboardAction(e -> this.cancelDialog(), KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new DialogWindowAdapter());
        this._jButtonLogin.addActionListener(this::actionPerformedLogin);
        this._jButtonCancel.addActionListener(this::actionPerformedCancel);
        this._jButtonLoginSetup.addActionListener(this::actionPerformedSetup);
        this._jButtonServerStatus.addActionListener(this::actionPerformedServerStatus);
    }

    private void actionPerformedServerStatus(ActionEvent actionEvent) {
        Object selectedItem = this._jComboBoxServer.getSelectedItem();
        String certificateAlias = Optional.ofNullable(this._jComboBoxUsername.getSelectedItem()).map(Object::toString).orElse(null);
        if (selectedItem instanceof CwmsAuthenticationSource) {
            CwmsAuthenticationSource selectedDataSource = (CwmsAuthenticationSource)selectedItem;
            if (!LocalAuthenticationSource.getInstance().equals((Object)selectedDataSource)) {
                SwingUtilities.invokeLater(() -> this.setCursor(Cursor.getPredefinedCursor(3)));
                this._cwmsServiceStatusChecker.checkServerStatus(selectedDataSource, certificateAlias).whenCompleteAsync((o, t) -> {
                    if (t != null) {
                        LOGGER.log(Level.SEVERE, "Error attempting unauthenticated connection to the server", (Throwable)t);
                    }
                    this._statusMap.put(selectedDataSource, (CwmsServersStatus)o);
                    this.setCursor(Cursor.getDefaultCursor());
                    this._jComboBoxServer.repaint();
                    JOptionPane.showMessageDialog((Component)((Object)this), o.getMessage(), "Server Status", 1);
                }, SwingUtilities::invokeLater);
            }
        }
    }

    private void authenticationSourceSelected() {
        CwmsAuthenticationSource selectedServer = this.getSelectedAuthenticationSource();
        this._jPasswordField.setText("");
        if (selectedServer != null) {
            if (selectedServer.isCacSupported()) {
                this._jComboBoxUsername.setEnabled(true);
                this._jComboBoxUsername.setEditable(false);
                this.fillCACCertificates();
                this._jPasswordField.setEnabled(false);
                this._jPasswordField.setVisible(false);
                Object labeledBy = this._jPasswordField.getClientProperty("labeledBy");
                if (labeledBy instanceof JComponent) {
                    ((JComponent)labeledBy).setVisible(false);
                }
            } else {
                this._jComboBoxUsername.setEditable(selectedServer.isUsernamePasswordSupported());
                this._jComboBoxUsername.setEnabled(selectedServer.isUsernamePasswordSupported());
                this._jComboBoxUsername.setSelectedItem(selectedServer.getUsernamePlaceholder());
                this._jPasswordField.setEnabled(selectedServer.isUsernamePasswordSupported());
                this._jPasswordField.setVisible(selectedServer.isUsernamePasswordSupported());
                Object labeledBy = this._jPasswordField.getClientProperty("labeledBy");
                if (labeledBy instanceof JComponent) {
                    ((JComponent)labeledBy).setVisible(selectedServer.isUsernamePasswordSupported());
                }
                this.updateCurrentStatus(selectedServer);
            }
        } else {
            this._jPasswordField.setEnabled(false);
            this._jComboBoxUsername.setEnabled(false);
            this._jComboBoxUsername.setSelectedItem("");
            this.updateCurrentStatus(selectedServer);
        }
    }

    private void fillCACCertificates() {
        this._loadingGui.start("Loading CAC certificate aliases");
        CwmsCacUtil.getCertificateAliases().whenCompleteAsync((a, t) -> {
            this._loadingGui.stop();
            this._jComboBoxUsername.removeAllItems();
            a.forEach(this._jComboBoxUsername::addItem);
        }, SwingUtilities::invokeLater);
    }

    private void initSocketFactory() {
        CwmsAuthenticationSource selectedServer = (CwmsAuthenticationSource)this._jComboBoxServer.getSelectedItem();
        this._loadingGui.start("Initializing secure connection to CWMS");
        CompletableFuture.runAsync(() -> {
            if (selectedServer != null && selectedServer.isCacSupported()) {
                try {
                    String certificateAlias = Optional.ofNullable(this._jComboBoxUsername.getSelectedItem()).map(Object::toString).orElse(null);
                    CwmsCacUtil.initRmiSocketFactory((String)certificateAlias);
                }
                catch (ClientCacException | RuntimeException e) {
                    String message = "Error establishing a secure connection to CWMS";
                    this.handleLoginException(new IllegalStateException(message, e));
                    LOGGER.log(Level.SEVERE, message, e);
                }
            }
        }).whenCompleteAsync((obj, t) -> {
            this._loadingGui.stop();
            this.updateCurrentStatus(selectedServer);
        });
    }

    public void disableServerSetup() {
        this._jButtonLoginSetup.setEnabled(false);
    }

    private void actionPerformedCancel(ActionEvent event) {
        this.cancelDialog();
    }

    private void actionPerformedLogin(ActionEvent event) {
        if (this.getSelectedAuthenticationSource() != null) {
            new LoginSwingWorker().execute();
        }
    }

    private String expandExceptionMessage(String message, Throwable ex) {
        ArrayList<String> exceptionMessages = new ArrayList<String>();
        this.expandExceptionMessageRecursive(exceptionMessages, ex);
        return message + String.join((CharSequence)"\n", exceptionMessages);
    }

    private void expandExceptionMessageRecursive(List<String> messages, Throwable ex) {
        String message = ex.getMessage();
        if (message == null) {
            message = ex.getClass().getName();
        }
        String newMessage = message.replaceAll("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*([a-zA-Z_$][a-zA-Z\\d_$]*)Exception:\\s*", "");
        for (String previousMessage : messages) {
            newMessage = newMessage.replace(previousMessage, "").trim();
        }
        if (!newMessage.isEmpty()) {
            messages.add(newMessage);
        }
        if (ex.getCause() != null) {
            this.expandExceptionMessageRecursive(messages, ex.getCause());
        }
    }

    private void actionPerformedSetup(ActionEvent event) {
        CwmsAuthenticationSource selectedDataSource = ServerSuiteUiFactory.launchServerSuiteSetupDialog((Window)((Object)this));
        List authenticationSources = CwmsLoginUtil.buildPreferenceServers();
        CwmsLoginUtil.setLastLoginServerUrls((List)authenticationSources);
        boolean usesLocal = this._cwmsAuthenticationSources.contains(LocalAuthenticationSource.getInstance());
        this._cwmsAuthenticationSources.clear();
        if (usesLocal) {
            this._cwmsAuthenticationSources.add((CwmsAuthenticationSource)LocalAuthenticationSource.getInstance());
        }
        this._cwmsAuthenticationSources.addAll(authenticationSources);
        this._cwmsAuthenticationSources.removeIf(d -> !d.canAuthenticate());
        this._jComboBoxServer.removeAllItems();
        this._cwmsAuthenticationSources.forEach(this._jComboBoxServer::addItem);
        this._statusMap.clear();
        if (selectedDataSource != null) {
            this._jComboBoxServer.setSelectedItem(selectedDataSource);
        } else if (!this._cwmsAuthenticationSources.isEmpty()) {
            this._jComboBoxServer.setSelectedIndex(0);
        }
    }

    private void cancelDialog() {
        this._canceled = true;
        this.setVisible(false);
        this._loginHandler.cancel();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    private void setDlgLocation() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dd = this.getSize();
        this.setLocation((d.width - dd.width) / 2, (d.height - dd.height) / 2);
    }

    public void setVisible(boolean tf) {
        if (tf) {
            this.setDlgLocation();
            this.setSize(this.getPreferredSize());
            Dimension ddd = this.getPreferredSize();
            this.setDefaultSize(ddd.width + 10, ddd.height + 30);
        }
        super.setVisible(tf);
        if (!tf) {
            this._loadingGui.shutdown();
            this._cwmsServiceStatusChecker.shutdown();
        }
    }

    private String getUsername() {
        String username = "";
        Object selectedItem = this._jComboBoxUsername.getSelectedItem();
        if (selectedItem != null) {
            username = selectedItem.toString();
        }
        return username.trim();
    }

    public void setUsername(String u) {
        this._jComboBoxUsername.setSelectedItem(u);
    }

    private char[] getPassword() {
        return this._jPasswordField.getPassword();
    }

    public void setPassword(String p) {
        this._jPasswordField.setText(p);
    }

    public CwmsAuthenticationSource getSelectedAuthenticationSource() {
        return (CwmsAuthenticationSource)this._jComboBoxServer.getSelectedItem();
    }

    public List<CwmsAuthenticationSource> getCwmsAuthenticationSources() {
        return this._cwmsAuthenticationSources;
    }

    public void setSelectedServer(CwmsAuthenticationSource serverInfo) {
        if (this._cwmsAuthenticationSources.contains(serverInfo)) {
            this._jComboBoxServer.setSelectedItem(serverInfo);
        } else if (serverInfo != null) {
            this._jComboBoxServer.addItem(serverInfo);
            this._jComboBoxServer.setSelectedItem(serverInfo);
        }
    }

    private void addStatus(String msg, SimpleAttributeSet simpleAttributeSet) {
        Document doc = this._jTextStatus.getDocument();
        int len = doc.getLength();
        try {
            if (len > 0) {
                msg = "\n\n" + (String)msg;
            }
            doc.insertString(len, (String)msg, simpleAttributeSet);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.FINE, "Error inserting status string.", e);
        }
    }

    public String getStatus() {
        return this._jTextStatus.getText();
    }

    public void setStatus(String status) {
        this._jTextStatus.setText(status);
    }

    public void fillForm(List<CwmsAuthenticationSource> serverInfoList) {
        this._cwmsAuthenticationSources.clear();
        this._cwmsAuthenticationSources.addAll(serverInfoList);
        this._cwmsAuthenticationSources.removeIf(d -> !d.canAuthenticate());
        CwmsAuthenticationSource selectedItem = (CwmsAuthenticationSource)this._jComboBoxServer.getSelectedItem();
        ArrayList<CwmsAuthenticationSource> filteredSources = new ArrayList<CwmsAuthenticationSource>(this._cwmsAuthenticationSources);
        RmaListModel model = new RmaListModel(false, filteredSources);
        this._jComboBoxServer.setModel((ComboBoxModel<CwmsAuthenticationSource>)model);
        if (this._cwmsAuthenticationSources.contains(selectedItem)) {
            this._jComboBoxServer.setSelectedItem(selectedItem);
        } else if (!this._cwmsAuthenticationSources.isEmpty()) {
            String lastLoginServer = CwmsLoginUtil.getLastLoginServer();
            Integer index = filteredSources.stream().filter(c -> c.getDisplayName().equals(lastLoginServer)).map(filteredSources::indexOf).findAny().orElse(0);
            this._jComboBoxServer.setSelectedIndex(index);
        }
    }

    private void addError(String msg) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, Color.RED);
        StyleConstants.setBold(attrs, true);
        this.addStatus(msg, attrs);
    }

    private void login() throws LoginException {
        CwmsAuthenticationSource selectedAuthenticationSource = this.getSelectedAuthenticationSource();
        if (selectedAuthenticationSource != null) {
            String username = this.getUsername();
            this._loginHandler.login(selectedAuthenticationSource, username, this.getPassword());
            if (!selectedAuthenticationSource.isCacSupported()) {
                CwmsLoginUtil.setLastUser((String)username);
            }
            CwmsLoginUtil.setLastLoginServer((CwmsAuthenticationSource)selectedAuthenticationSource);
        }
    }

    private void handleLoginException(Exception ex) {
        String msg = "Unable to login to CWMS.";
        LOGGER.log(Level.WARNING, msg, ex);
        String message = this.expandExceptionMessage(msg + "\n", ex.getCause());
        this.addError(message);
    }

    private void updateCurrentStatus(CwmsAuthenticationSource cwmsAuthenticationSource) {
        String certificateAlias = Optional.ofNullable(this._jComboBoxUsername.getSelectedItem()).map(Object::toString).orElse(null);
        this._cwmsServiceStatusChecker.checkServerStatus(cwmsAuthenticationSource, certificateAlias).whenCompleteAsync((o, t) -> {
            if (t != null) {
                LOGGER.log(Level.SEVERE, "Error attempting unauthenticated connection to the server", (Throwable)t);
            }
            this._statusMap.put(cwmsAuthenticationSource, (CwmsServersStatus)o);
            this.setCursor(Cursor.getDefaultCursor());
            this._jComboBoxServer.repaint();
        }, SwingUtilities::invokeLater);
    }

    private final class PasswordField
    extends JPasswordField {
        private PasswordField() {
            super(15);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (b) {
                CwmsLoginDialog.this._jPasswordField.setBackground(UIManager.getColor("PasswordField.background"));
            } else {
                CwmsLoginDialog.this._jPasswordField.setBackground((Color)UIManager.get("TextField.disabledBackground"));
            }
        }
    }

    private final class CwmsServerComboBoxRenderer
    extends DefaultListCellRenderer {
        private CwmsServerComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component retval = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (retval instanceof JLabel) {
                CwmsAuthenticationSource serverInfo = !CwmsLoginDialog.this._cwmsAuthenticationSources.isEmpty() && index >= 0 && index < CwmsLoginDialog.this._cwmsAuthenticationSources.size() ? CwmsLoginDialog.this._cwmsAuthenticationSources.get(index) : (CwmsAuthenticationSource)CwmsLoginDialog.this._jComboBoxServer.getSelectedItem();
                if (LocalAuthenticationSource.getInstance().equals((Object)serverInfo)) {
                    this.setIcon(null);
                    CwmsLoginDialog.this._jComboBoxServer.setToolTipText(LocalAuthenticationSource.getInstance().getDescription());
                } else if (serverInfo != null) {
                    Object serverDescription = serverInfo.getHtmlDisplay().replace("</html>", "");
                    CwmsServersStatus cwmsServersOnline = CwmsLoginDialog.this._statusMap.get(serverInfo);
                    Image statusImage = CwmsServiceStatusChecker.getStatusImage(cwmsServersOnline);
                    ((JLabel)retval).setIcon(new ImageIcon(statusImage));
                    serverDescription = cwmsServersOnline != null ? (String)serverDescription + "<br/><br/>" + cwmsServersOnline.getMessage().replace("\n", "<br/>") : (String)serverDescription + "<br/>Server Status Unknown";
                    serverDescription = (String)serverDescription + "</html>";
                    list.setToolTipText((String)serverDescription);
                    CwmsLoginDialog.this._jComboBoxServer.setToolTipText((String)serverDescription);
                }
            }
            return retval;
        }
    }

    private final class MessagesButtonActionListener
    implements ActionListener {
        private TextEditDlg _dialog;

        private MessagesButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this._dialog == null) {
                this._dialog = new TextEditDlg((Dialog)((Object)CwmsLoginDialog.this), "Message", CwmsLoginDialog.this.isModal());
                this._dialog.setSystemClosable(false);
            }
            this._dialog.setText(CwmsLoginDialog.this._jTextStatus.getText());
            this._dialog.setEditable(false);
            this._dialog.setVisible(true);
        }
    }

    private final class DialogWindowAdapter
    extends WindowAdapter {
        private DialogWindowAdapter() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (RMAIO.getOSType() != 2) {
                CwmsLoginDialog.this._jComboBoxUsername.requestFocus();
                CwmsLoginDialog.this.toFront();
            }
            if (CwmsLoginDialog.this.isAlwaysOnTopSupported() && !CwmsLoginDialog.this.isAlwaysOnTop()) {
                CwmsLoginDialog.this.setAlwaysOnTop(true);
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CwmsLoginDialog.this.cancelDialog();
        }
    }

    private class LoginSwingWorker
    extends SwingWorker<Void, Void> {
        private LoginSwingWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            CwmsLoginDialog.this._loadingGui.start("Authenticating...");
            CwmsLoginDialog.this.login();
            CwmsLoginUtil.setLastLoginServer((CwmsAuthenticationSource)CwmsLoginDialog.this.getSelectedAuthenticationSource());
            CwmsLoginDialog.this._loadingGui.updateText("Success.");
            return null;
        }

        @Override
        protected void done() {
            try {
                CwmsLoginDialog.this._loadingGui.stop();
                UserProfile userProfile = ServerSuiteUtil.getUserProfile();
                if (userProfile != null && userProfile.getInvalidLoginAttempts() > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)CwmsLoginDialog.this), "There have been " + userProfile.getInvalidLoginAttempts() + " unsuccessful login attempts since your last login", "Information", 1);
                }
                this.get();
                CwmsLoginDialog.this.setVisible(false);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOGGER.log(Level.WARNING, "CWMS Server Login process interrupted", ex);
            }
            catch (ExecutionException ex) {
                CwmsLoginDialog.this.handleLoginException(ex);
            }
        }
    }
}

