/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.serversuite.data.CwmsAuthenticationSource;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import mil.army.usace.hec.serversuite.ui.LoginSetupPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJButton;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;

public abstract class CwmsLoginSetupPanel<T extends CwmsAuthenticationSource>
extends RmaJPanel
implements LoginSetupPanel<T> {
    static final String UPDATE_STATUS_PROPERTY_CHANGED = "UPDATE_STATUS";
    private final RmaJTextField _displayNameField = new RmaJTextField();

    @Override
    public final CwmsLoginSetupPanel<T> getPanel() {
        return this;
    }

    @Override
    public void fillPanel(T cwmsAuthenticationSource) {
        this._displayNameField.setText(cwmsAuthenticationSource.getDisplayName());
    }

    protected final void initComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildNamePanel(), "North");
        RmaJPanel center = new RmaJPanel((LayoutManager)new BorderLayout());
        center.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(0.4f), Color.BLACK), "<html><b>Connection Type: </b>" + this.getConnectionType() + "</html>"));
        center.add((Component)this.buildCenterPanel(), (Object)"Center");
        RmaJPanel status = new RmaJPanel((LayoutManager)new FlowLayout(2));
        RmaJButton statusButton = new RmaJButton("Status");
        status.add((Component)statusButton);
        statusButton.addActionListener(e -> this.firePropertyChange(UPDATE_STATUS_PROPERTY_CHANGED, null, null));
        center.add((Component)status, (Object)"South");
        this.add((Component)center, "Center");
    }

    protected abstract String getConnectionType();

    protected abstract RmaJPanel buildCenterPanel();

    private RmaJPanel buildNamePanel() {
        RmaJPanel retval = new RmaJPanel((LayoutManager)new FlowLayout(0));
        RmaJPanel namePanel = new RmaJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.anchor = 18;
        namePanel.add((Component)new RmaJLabel("<html><b>Display Name: </b></html>"), (Object)gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS0555;
        gbc.fill = 2;
        namePanel.add((Component)this._displayNameField, (Object)gbc);
        this._displayNameField.setPreferredSize(new Dimension(300, this._displayNameField.getPreferredSize().height));
        retval.add((Component)namePanel);
        return retval;
    }

    public final void disableDisplayName() {
        this._displayNameField.setEnabled(false);
    }

    public final String getDisplayName() {
        return this._displayNameField.getText().trim();
    }
}

