/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsServersStatus;
import java.awt.Image;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.ImageIcon;

final class CwmsServiceStatusChecker {
    private final ExecutorService _serverStatusExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, "CWMS Server Status Thread"));

    CwmsServiceStatusChecker() {
    }

    CompletableFuture<CwmsServersStatus> checkServerStatus(CwmsAuthenticationSource cwmsAuthenticationSource, String certificateAlias) {
        return CompletableFuture.supplyAsync(() -> {
            CwmsServersStatus retval = new CwmsServersStatus(CwmsServersStatus.CwmsServersOnline.UNKNOWN, "");
            if (cwmsAuthenticationSource != null) {
                retval = cwmsAuthenticationSource.getServerStatusCheck().testServerStatus(certificateAlias);
            }
            return retval;
        }, this._serverStatusExecutor);
    }

    void shutdown() {
        this._serverStatusExecutor.shutdownNow();
    }

    static Image getStatusImage(CwmsServersStatus cwmsServersStatus) {
        String iconPath = "hec/login/gui/setup/connection_unknown.png";
        if (cwmsServersStatus != null) {
            switch (cwmsServersStatus.getCwmsServersOnline()) {
                case UNKNOWN: {
                    iconPath = "hec/login/gui/setup/connection_unknown.png";
                    break;
                }
                case ALL_OFFLINE: {
                    iconPath = "hec/login/gui/setup/connection_invalid.png";
                    break;
                }
                case ALL_ONLINE: {
                    iconPath = "hec/login/gui/setup/connection_valid.png";
                    break;
                }
                case SOME_ONLINE: {
                    iconPath = "hec/login/gui/setup/connection_missing_servers.png";
                }
            }
        }
        URL resource = Thread.currentThread().getContextClassLoader().getResource(iconPath);
        Image image = null;
        if (resource != null) {
            image = new ImageIcon(resource).getImage();
            image = image.getScaledInstance(16, 16, 4);
        }
        return image;
    }
}

