/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.LocalAuthenticationSource;
import hec.serversuite.data.ServerInfo;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import mil.army.usace.hec.serversuite.ui.ServerInfoPanel;

class GetServerSwingWorker
extends SwingWorker<Set<ServerInfo>, Object> {
    private static final String NOT_FOUND = "Not Found";
    private final CwmsAuthenticationSource _serverInfo;
    private final Map<String, JLabel> _labelMap;

    GetServerSwingWorker(CwmsAuthenticationSource serverInfo, Map<String, JLabel> labelMap) {
        this._serverInfo = serverInfo;
        this._labelMap = labelMap;
    }

    @Override
    protected void done() {
        try {
            Set serverMap;
            this.setLabels(NOT_FOUND, null);
            if (!this.isCancelled() && (serverMap = (Set)this.get()) != null) {
                serverMap.forEach(s -> this.setServerLabel(s.getServerName(), s.getUrl()));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Logger.getLogger(ServerInfoPanel.class.getName()).log(Level.FINE, "Server Info Panel swing worker interrupted.", e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Set<ServerInfo> doInBackground() {
        return this.getServerMap(this._serverInfo);
    }

    private void setLabels(String text, ImageIcon icon) {
        BiConsumer<String, JLabel> action = (string, jLabel) -> {
            jLabel.setText(text);
            jLabel.setIcon(icon);
            jLabel.setOpaque(true);
        };
        this._labelMap.forEach(action);
    }

    private Set<ServerInfo> getServerMap(CwmsAuthenticationSource serverInfo) {
        if (serverInfo.equals(LocalAuthenticationSource.getInstance())) {
            return null;
        }
        return serverInfo.lookupServers();
    }

    private void setServerLabel(String serverName, String label) {
        JLabel jLabel = this._labelMap.get(serverName);
        if (jLabel != null) {
            jLabel.setText(label);
        }
    }
}

