/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.appInterface.AppDaddy;
import hec.gui.AbstractFileChooserField;
import hec.io.HecFile;
import hec.io.Identifier;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.serversuite.ui.RmiFileDialog;
import rma.util.RMAIO;

public class RmiFileChooserField
extends AbstractFileChooserField {
    RmiFileDialog _fileChooserDialog = null;
    boolean _bRemote = true;

    public RmiFileChooserField() {
    }

    public RmiFileChooserField(String fullpath) {
        super(fullpath);
    }

    public RmiFileChooserField(String fullpath, int cols) {
        super(fullpath, cols);
    }

    public RmiFileChooserField(String fullpath, int cols, boolean remote) {
        super(fullpath, cols);
        this._bRemote = remote;
    }

    public boolean displayFileChooserDialog() {
        if (!this.isEditable() || !this.isEnabled()) {
            return false;
        }
        String path = this.getPath();
        String filename = null;
        if (this.getDefaultPath() == null && AppDaddy.getWorkspace() != null) {
            this.setDefaultPath(AppDaddy.getWorkspace().getWorkspacePath());
        }
        if (path == null || path.trim().length() < 1) {
            path = this.getDefaultPath();
        } else {
            filename = RMAIO.getFileFromPath((String)path);
            String newPath = RMAIO.getDirectoryFromPath((String)path);
            path = path.equals(newPath) ? this.getDefaultPath() : newPath;
        }
        if (this._fileChooserDialog == null) {
            Window c = SwingUtilities.windowForComponent((Component)((Object)this));
            this._fileChooserDialog = c instanceof Frame ? new RmiFileDialog((Frame)c, true, this._bRemote) : new RmiFileDialog((Dialog)c, true, this._bRemote);
        }
        if (this.isOpening()) {
            if (this.getOpenType() == 0) {
                this._fileChooserDialog.setOpenTitle();
            } else {
                this._fileChooserDialog.setOpenDirectory();
            }
        } else {
            this._fileChooserDialog.setSaveTitle();
        }
        if (this.getChooserTitle() != null) {
            this._fileChooserDialog.setTitle(this.getChooserTitle());
        }
        this._fileChooserDialog.setStartDir(path);
        if (filename != null) {
            this._fileChooserDialog.setDefaultFilename(filename);
        }
        if (this.getFilters() != null) {
            this._fileChooserDialog.setFileMask(this.getFilters());
        }
        this._fileChooserDialog.setVisible(true);
        if (this._fileChooserDialog.isCanceled()) {
            return false;
        }
        if (this._fileChooserDialog.getIdentifier() != null) {
            Identifier id1 = null;
            Identifier id0 = this._fileChooserDialog.getIdentifier();
            id1 = AppDaddy.getWorkspace().openFile(id0, false);
            if (id1 == null) {
                id1 = AppDaddy.getWorkspace().createFile(id0);
            }
            this.setText(id1.getPath());
            this.setModified(true);
            this.fireFileChosen();
        } else {
            this.setText("");
        }
        if (this._fileChooserDialog != null) {
            this._fileChooserDialog.dispose();
            this._fileChooserDialog = null;
            System.gc();
        }
        return true;
    }

    public HecFile getSelectedFile() {
        String path = this.getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        Identifier id = new Identifier(path);
        Identifier openId = AppDaddy.getWorkspace().openFile(id, false);
        if (openId == null) {
            openId = AppDaddy.getWorkspace().createFile(id);
        }
        if (openId != null) {
            return openId.getFile();
        }
        return null;
    }
}

