/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.serversuite.RemoteServerEnum;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsLoginUtil;
import hec.serversuite.data.LocalAuthenticationSource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.csinterface.ControllableServer;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.serversuite.ui.CwmsLoginSetupDialog;
import mil.army.usace.hec.serversuite.ui.GetServerSwingWorker;
import mil.army.usace.hec.serversuite.ui.ServerPropertiesDlg;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;

public final class ServerInfoPanel
extends RmaJPanel {
    private static final String NOT_FOUND = "Not Found";
    private final JLabel _jLabelServer = new JLabel("Server:");
    private final JComboBox<CwmsAuthenticationSource> _jComboBoxServer = new JComboBox();
    private final JButton _jButtonLoginSetup = new JButton("Login Server Setup ...");
    private final JLabel _dssFileManagerUrlLabel = new JLabel("");
    private final JLabel _fileManagerUrlLabel = new JLabel("");
    private final JLabel _loginManagerUrlLabel = new JLabel("");
    private final JLabel _schedulerUrlLabel = new JLabel("");
    private final List<CwmsAuthenticationSource> _serverInfoList = new ArrayList<CwmsAuthenticationSource>();
    private final JLabel _currentUrlLabel = new JLabel("");
    private final JPanel _serverUrlPanel = new JPanel(new GridBagLayout());
    private final JButton _serverPropsBtn = new JButton("Properties");
    private final Map<String, JLabel> _labelMap = new HashMap<String, JLabel>();
    private GetServerSwingWorker _worker;

    public ServerInfoPanel() {
        this.initComponents();
        this.addListeners();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this._jLabelServer.setDisplayedMnemonic('S');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(this._jLabelServer, gbc);
        this._jLabelServer.setLabelFor(this._jComboBoxServer);
        this._jComboBoxServer.setEditable(false);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.insets((int)2, (int)2, (int)0, (int)2);
        this.add(this._jComboBoxServer, gbc);
        this._jButtonLoginSetup.setMnemonic('L');
        this._jButtonLoginSetup.setActionCommand("LoginSetup");
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.insets = RmaInsets.insets((int)2, (int)2, (int)0, (int)2);
        this.add(this._jButtonLoginSetup, gbc);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this.add(this._serverUrlPanel, gbc);
        JLabel label = new JLabel("Login Manager URL:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)this._loginManagerUrlLabel, gbc);
        this._labelMap.put(RemoteServerEnum.LOGIN_SERVER.getRemoteName(), this._loginManagerUrlLabel);
        label = new JLabel("File Manager URL:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)this._fileManagerUrlLabel, gbc);
        this._labelMap.put(RemoteServerEnum.FILE_MANAGER.getRemoteName(), this._fileManagerUrlLabel);
        label = new JLabel("Dss File Manager URL:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)this._dssFileManagerUrlLabel, gbc);
        this._labelMap.put(RemoteServerEnum.DSS_FILE_MANAGER.getRemoteName(), this._dssFileManagerUrlLabel);
        label = new JLabel("Scheduler URL:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)this._schedulerUrlLabel, gbc);
        this._labelMap.put(RemoteServerEnum.RMI_SCHEDULER.getRemoteName(), this._schedulerUrlLabel);
        JSeparator sep = new JSeparator();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._serverUrlPanel.add((Component)sep, gbc);
        label = new JLabel("Current Login URL:", 4);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)this._currentUrlLabel, gbc);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._serverUrlPanel.add((Component)this._serverPropsBtn, gbc);
        List serverUrl = CwmsLoginUtil.buildPreferenceServers();
        this._serverInfoList.addAll(serverUrl);
        for (CwmsAuthenticationSource serverInfo : this._serverInfoList) {
            this._jComboBoxServer.addItem(serverInfo);
        }
    }

    private void addListeners() {
        this._jComboBoxServer.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                if (this._worker != null) {
                    this._worker.cancel(true);
                }
                this.setModified(true);
                CwmsAuthenticationSource serverInfo = (CwmsAuthenticationSource)event.getItem();
                this.setLoadingLabels();
                this._worker = new GetServerSwingWorker(serverInfo, this._labelMap);
                this._worker.execute();
            }
        });
        this._jButtonLoginSetup.addActionListener(this::actionPerformedSetup);
        this._serverPropsBtn.addActionListener(e -> this.serverPropertiesAction());
        CwmsAuthenticationSource activeServer = ServerSuiteUtil.getCwmsAuthenticationSource();
        if (activeServer == null) {
            this._currentUrlLabel.setText("Local");
            this._serverPropsBtn.setEnabled(false);
        } else {
            this._serverPropsBtn.setEnabled(!activeServer.equals(LocalAuthenticationSource.getInstance()));
            this._currentUrlLabel.setText(activeServer.getServerInfo().getUrl());
        }
    }

    private void setLoadingLabels() {
        String text = "loading";
        ImageIcon loading = RmaImage.getImageIcon((String)"Images/loading.gif");
        this.setLabel(this._dssFileManagerUrlLabel, text, loading);
        this.setLabel(this._fileManagerUrlLabel, text, loading);
        this.setLabel(this._loginManagerUrlLabel, text, loading);
        this.setLabel(this._schedulerUrlLabel, text, loading);
    }

    private void setLabel(JLabel label, String text, ImageIcon icon) {
        label.setOpaque(true);
        label.setIcon(icon);
        label.setText(text);
    }

    public void setVisible(boolean bVis) {
        if (!bVis && this._worker != null) {
            this._worker.cancel(true);
        }
    }

    private void serverPropertiesAction() {
        String[] names = new String[]{"FileManager", "DssFileManager"};
        RmiFileManager fm = ServerSuiteUtil.getFileManager();
        DSSManager dssFm = ServerSuiteUtil.getDssManager();
        Window w = SwingUtilities.windowForComponent((Component)((Object)this));
        if (w instanceof JDialog) {
            ServerPropertiesDlg dlg = new ServerPropertiesDlg((JDialog)w, names, new ControllableServer[]{fm, dssFm});
            dlg.setVisible(true);
        }
    }

    public void setServerUrlPanelVisible(boolean visible) {
        this._serverUrlPanel.setVisible(visible);
    }

    public void setServerLabelVisible(boolean visible) {
        this._jLabelServer.setVisible(visible);
    }

    private void actionPerformedSetup(ActionEvent event) {
        Window window = SwingUtilities.windowForComponent((Component)((Object)this));
        CwmsLoginSetupDialog loginSetup = new CwmsLoginSetupDialog(window, this._serverInfoList);
        loginSetup.setVisible(true);
        List<CwmsAuthenticationSource> authenticationSources = loginSetup.getAuthenticationSources();
        CwmsLoginUtil.setLastLoginServerUrls(authenticationSources);
        this.fillForm(authenticationSources);
        CwmsAuthenticationSource selectedDataSource = loginSetup.getSelectedDataSource();
        if (selectedDataSource != null) {
            this.setSelectedServer(selectedDataSource);
        }
    }

    public void fillForm(List<CwmsAuthenticationSource> serverInfoList) {
        boolean bForward = this.forwardModifiedEvents();
        this.setFowardModifiedEvents(false);
        boolean bModified = this.isModified();
        CwmsAuthenticationSource activeServer = ServerSuiteUtil.getCwmsAuthenticationSource();
        if (activeServer == null) {
            this._currentUrlLabel.setText("Local");
            this._serverPropsBtn.setEnabled(false);
        } else {
            this._serverPropsBtn.setEnabled(!activeServer.equals(LocalAuthenticationSource.getInstance()));
            this._currentUrlLabel.setText(activeServer.getServerInfo().getUrl());
        }
        CwmsAuthenticationSource localServerInfo = null;
        if (serverInfoList != null) {
            for (CwmsAuthenticationSource sInfo : this._serverInfoList) {
                if (!sInfo.equals(LocalAuthenticationSource.getInstance())) continue;
                localServerInfo = sInfo;
            }
            boolean bLocalAdded = false;
            for (CwmsAuthenticationSource sInfo : serverInfoList) {
                if (!sInfo.equals(LocalAuthenticationSource.getInstance())) continue;
                bLocalAdded = true;
                break;
            }
            if (!bLocalAdded && localServerInfo != null) {
                serverInfoList.add(0, localServerInfo);
            }
            this._serverInfoList.clear();
            this._serverInfoList.addAll(serverInfoList);
            this.initServerCombo();
        }
        this.setModified(bModified);
        this.setFowardModifiedEvents(bForward);
    }

    private void initServerCombo() {
        CwmsAuthenticationSource selInfo = this.getSelectedServer();
        this._jComboBoxServer.removeAllItems();
        for (CwmsAuthenticationSource sInfo : this._serverInfoList) {
            this._jComboBoxServer.addItem(sInfo);
        }
        this.setSelectedServer(selInfo);
    }

    public CwmsAuthenticationSource getSelectedServer() {
        return (CwmsAuthenticationSource)this._jComboBoxServer.getSelectedItem();
    }

    public void setSelectedServer(CwmsAuthenticationSource server) {
        LocalAuthenticationSource source;
        if (server.equals(LocalAuthenticationSource.getInstance())) {
            source = LocalAuthenticationSource.getInstance();
        } else {
            Optional<CwmsAuthenticationSource> selectedSource = IntStream.range(0, this._jComboBoxServer.getItemCount()).mapToObj(this._jComboBoxServer::getItemAt).filter(o -> Objects.equals(o, server)).findFirst();
            if (!selectedSource.isPresent()) {
                selectedSource = IntStream.range(0, this._jComboBoxServer.getItemCount()).parallel().mapToObj(this._jComboBoxServer::getItemAt).filter(o -> CwmsLoginUtil.matches((CwmsAuthenticationSource)o, (CwmsAuthenticationSource)server)).findFirst();
            }
            source = selectedSource.orElse(server);
        }
        this._jComboBoxServer.getModel().setSelectedItem(source);
    }

    public String getFileManagerUrl() {
        String strServer = this._fileManagerUrlLabel.getText();
        if (strServer.equals(NOT_FOUND)) {
            strServer = "";
        }
        return strServer;
    }

    public String getDssManagerUrl() {
        String strServer = this._dssFileManagerUrlLabel.getText();
        if (strServer.equals(NOT_FOUND)) {
            strServer = "";
        }
        return strServer;
    }
}

