/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import mil.army.usace.hec.rmi.csinterface.ControllableServer;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJList;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;
import rma.util.RMAIO;

public class ServerPropertiesDlg
extends RmaJDialog {
    private ControllableServer[] _servers;
    private JTabbedPane _tabbedPane;
    private ButtonCmdPanel _cmdPanel;
    private String[] _names;

    public ServerPropertiesDlg(JDialog parent, String[] names, ControllableServer ... servers) {
        super((Dialog)parent, parent.isModal());
        this._names = names;
        this._servers = servers;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(600, 400);
        this.setLocationRelativeTo(this.getParent());
    }

    public ServerPropertiesDlg(JFrame parent, String[] names, ControllableServer ... servers) {
        super((Frame)parent, false);
        this._names = names;
        this._servers = servers;
        this.buildControls();
        this.addListeners();
        this.fillForm();
        this.pack();
        this.setSize(600, 400);
        this.setLocationRelativeTo(this.getParent());
    }

    protected void buildControls() {
        this.setTitle("Server Properties");
        this.getContentPane().setLayout(new GridBagLayout());
        this._tabbedPane = new JTabbedPane();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tabbedPane, gbc);
        for (int i = 0; i < this._servers.length; ++i) {
            ServerPropertiesPanel panel = new ServerPropertiesPanel(this._names[i], this._servers[i]);
            panel.fillProperties();
            this._tabbedPane.addTab(panel.getTabName(), panel);
        }
        this._cmdPanel = new ButtonCmdPanel(256);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    protected void addListeners() {
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 256: {
                        ServerPropertiesDlg.this.setVisible(false);
                    }
                }
            }
        });
    }

    private void fillForm() {
    }

    public class ServerPropertiesPanel
    extends JPanel {
        private RmaJList _propertiesList;
        private JButton _delButton;
        private JButton _editButton;
        private RmaJTextField _filterTxt;
        private JLabel _cpuCntLbl;
        private ControllableServer _server;
        private String _tabName;

        public ServerPropertiesPanel(String name, ControllableServer server) {
            super(new GridBagLayout());
            this._server = server;
            this._tabName = name;
            this._filterTxt = new RmaJTextField();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.INSETS5050;
            this.add((Component)this._filterTxt, gbc);
            this._propertiesList = new RmaJList((ListModel)((Object)new FilteringModel())){

                public Dimension getPreferredScrollableViewportSize() {
                    Dimension d = super.getPreferredScrollableViewportSize();
                    d.width = 100;
                    d.height = 100;
                    return d;
                }
            };
            this._propertiesList.setSelectionMode(0);
            this._propertiesList.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2 && SwingUtilities.isLeftMouseButton(e)) {
                        ServerPropertiesPanel.this.propertiesListDoubleClick();
                    }
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 5.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            JScrollPane sp = new JScrollPane((Component)this._propertiesList);
            this.add((Component)sp, gbc);
            this._filterTxt.getDocument().addDocumentListener((DocumentListener)((Object)this._propertiesList.getModel()));
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 15;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)buttonPanel, gbc);
        }

        protected void propertiesListDoubleClick() {
            String property = (String)this._propertiesList.getSelectedValue();
            if (property == null) {
                return;
            }
            String propName = RMAIO.getType((String)property, (String)"=");
            String propValue = RMAIO.getParam((String)property, (String)"=");
            boolean editable = this.isSystemProperty(propName);
            String sep = "/";
            try {
                sep = this._server.getServerProperty("path.separator");
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (sep == null || sep.isEmpty()) {
                sep = "/";
            }
            if (RMAIO.countCharacters((String)propValue, (char)sep.charAt(0)) > 1) {
                this.editListProperty(propName, propValue, editable, sep);
            }
        }

        private void editListProperty(String propName, String propValue, boolean editable, String sepChar) {
            Dialog parent = (Dialog)SwingUtilities.windowForComponent(this);
            PropListDialog dialog = new PropListDialog(parent);
            dialog.fillForm(propName, propValue, editable, sepChar);
            dialog.setVisible(true);
        }

        boolean isSystemProperty(String propName) {
            if (Boolean.getBoolean("expertUser")) {
                return false;
            }
            if (propName == null) {
                return false;
            }
            return propName.startsWith("user.") || propName.startsWith("java.") || propName.startsWith("sun.") || propName.startsWith("os.") || propName.startsWith("file.") || propName.startsWith("line.") || propName.startsWith("awt.") || propName.startsWith("path.");
        }

        void fillProperties() {
            Properties props = null;
            if (this._server != null) {
                try {
                    String s = this._server.toString();
                    System.out.println("fillProperties:" + s);
                    props = this._server.getServerProperties();
                }
                catch (RemoteException re) {
                    System.out.println("fillProperties:error retrieving server properties " + re);
                    return;
                }
            }
            if (props != null) {
                Enumeration<?> e = props.propertyNames();
                FilteringModel model = (FilteringModel)((Object)this._propertiesList.getModel());
                model.clear();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String prop = props.getProperty(key);
                    model.addElement(key + "=" + prop);
                }
            }
        }

        public String getTabName() {
            return this._tabName;
        }

        private class FilteringModel
        extends RmaListModel
        implements DocumentListener {
            List<Object> filteredList;
            String lastFilter;

            public FilteringModel(boolean sort) {
                super(sort);
                this.lastFilter = "";
                this.filteredList = new ArrayList<Object>();
            }

            public FilteringModel() {
                this(true);
            }

            public void addElement(Object element) {
                super.addElement(element);
                this.filter(this.lastFilter);
            }

            public int getSize() {
                return this.filteredList.size();
            }

            public Object getElementAt(int index) {
                Object returnValue = index < this.filteredList.size() ? this.filteredList.get(index) : null;
                return returnValue;
            }

            void filter(String search) {
                this.filteredList.clear();
                for (Object element : this.delegate) {
                    if (element.toString().indexOf(search, 0) == -1) continue;
                    this.filteredList.add(element);
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                Document doc = event.getDocument();
                try {
                    this.lastFilter = doc.getText(0, doc.getLength());
                    this.filter(this.lastFilter);
                }
                catch (BadLocationException ble) {
                    System.err.println("Bad location: " + ble);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                Document doc = event.getDocument();
                try {
                    this.lastFilter = doc.getText(0, doc.getLength());
                    this.filter(this.lastFilter);
                }
                catch (BadLocationException ble) {
                    System.err.println("Bad location: " + ble);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
            }
        }

        public class PropListDialog
        extends RmaJDialog {
            private RmaJTextField _propNameFld;
            private RmaJList _propValuesList;
            private ButtonCmdPanel _cmdPanel;
            private RmaJTextField _searchFld;

            public PropListDialog(Dialog parent) {
                super(parent, true);
                this.buildControls();
                this.addListeners();
                this.pack();
                this.setLocationRelativeTo(parent);
            }

            protected void buildControls() {
                this.getContentPane().setLayout(new GridBagLayout());
                JLabel label = new JLabel("Property:");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)label, gbc);
                this._propNameFld = new RmaJTextField();
                this._propNameFld.setEditable(false);
                label.setLabelFor((Component)this._propNameFld);
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)this._propNameFld, gbc);
                label = new JLabel("Property Value:");
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.weightx = 0.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)label, gbc);
                this._propValuesList = new RmaJList((ListModel)((Object)new FilteringModel()));
                label.setLabelFor((Component)this._propValuesList);
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.gridwidth = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.anchor = 18;
                gbc.fill = 1;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)new JScrollPane((Component)this._propValuesList), gbc);
                this._searchFld = new RmaJTextField();
                gbc.gridx = 0;
                gbc.gridy = 3;
                gbc.gridwidth = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)this._searchFld, gbc);
                this._cmdPanel = new ButtonCmdPanel(256);
                gbc.gridx = 0;
                gbc.gridy = 10;
                gbc.weightx = 1.0;
                gbc.weighty = 0.0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.INSETS5555;
                this.getContentPane().add((Component)this._cmdPanel, gbc);
            }

            protected void addListeners() {
                this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                    public void buttonCmdActionPerformed(ActionEvent e) {
                        switch (e.getID()) {
                            case 256: {
                                PropListDialog.this.setVisible(false);
                            }
                        }
                    }
                });
            }

            public void fillForm(String propName, String propValue, boolean editable, String sepChar) {
                this.setTitle(propName);
                this._propNameFld.setText(propName);
                StringTokenizer tokenizer = new StringTokenizer(propValue, sepChar);
                FilteringModel newModel = new FilteringModel(false);
                while (tokenizer.hasMoreTokens()) {
                    newModel.addElement(tokenizer.nextToken());
                }
                this._propValuesList.setModel((ListModel)((Object)newModel));
                this._searchFld.getDocument().addDocumentListener((DocumentListener)((Object)this._propValuesList.getModel()));
            }
        }

        public class PropDialog
        extends RmaJDialog {
            private RmaJTextField propertyName;
            private RmaJTextField propertyValue;
            private boolean _canceled;

            public PropDialog(Dialog parent) {
                super(parent, true);
                this.getContentPane().setLayout(new GridBagLayout());
                JLabel label = new JLabel("Property:");
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.INSETS5500;
                this.getContentPane().add((Component)label, gbc);
                this.propertyName = new RmaJTextField(30);
                this.propertyName.setTrimWhiteSpace(true);
                this.propertyName.setEmptyOk(false);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)this.propertyName, gbc);
                label = new JLabel("Property Value:");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.anchor = 18;
                gbc.fill = 0;
                gbc.insets = RmaInsets.INSETS5500;
                this.getContentPane().add((Component)label, gbc);
                this.propertyValue = new RmaJTextField(30);
                this.propertyValue.setTrimWhiteSpace(true);
                this.propertyName.setEmptyOk(false);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.insets = RmaInsets.INSETS5505;
                this.getContentPane().add((Component)this.propertyValue, gbc);
                ButtonCmdPanel cmdPanel = new ButtonCmdPanel(12);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.anchor = 16;
                gbc.fill = 2;
                gbc.gridwidth = 2;
                gbc.insets = RmaInsets.INSETS5555;
                this.getContentPane().add((Component)cmdPanel, gbc);
                cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                    public void buttonCmdActionPerformed(ActionEvent e) {
                        switch (e.getID()) {
                            case 8: {
                                PropDialog.this._canceled = false;
                                PropDialog.this.setVisible(false);
                                break;
                            }
                            case 4: {
                                PropDialog.this._canceled = true;
                                PropDialog.this.setVisible(false);
                            }
                        }
                    }
                });
                this.setTitle("New Property");
                this.pack();
                this.setLocation();
                this.setResizable(false);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        PropDialog.this._canceled = true;
                        PropDialog.this.setVisible(false);
                    }
                });
            }

            public boolean isCanceled() {
                return this._canceled;
            }

            public String getPropertyName() {
                return this.propertyName.getText();
            }

            public String getPropertyValue() {
                return this.propertyValue.getText();
            }

            public void fillForm(String name, String value) {
                this.propertyName.setText(name);
                this.propertyValue.setText(value);
                this.setTitle("Edit Property");
            }
        }
    }
}

