/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.serversuite.ui;

import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsAuthenticationSourceBuilder;
import hec.serversuite.data.CwmsServersStatus;
import hec.serversuite.data.LocalAuthenticationSource;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import mil.army.usace.hec.serversuite.ui.CwmsLoginSetupNoopPanel;
import mil.army.usace.hec.serversuite.ui.CwmsLoginSetupPanel;
import mil.army.usace.hec.serversuite.ui.CwmsLoginSetupPanelFactory;
import mil.army.usace.hec.serversuite.ui.CwmsServiceStatusChecker;
import mil.army.usace.hec.serversuite.ui.LoginSetupException;
import mil.army.usace.hec.serversuite.ui.LoginSetupPanel;
import rma.swing.RmaJButton;
import rma.swing.RmaJDialog;
import rma.swing.RmaJPanel;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

abstract class ServerSuiteSetupDialog
extends RmaJDialog {
    private static final Logger LOGGER = Logger.getLogger(ServerSuiteSetupDialog.class.getName());
    final JList<CwmsAuthenticationSource> _cwmsAuthenticationSourceJList = new JList();
    final RmaJButton _okButton = new RmaJButton(this.getConfirmButtonText());
    private final DefaultListModel<CwmsAuthenticationSource> _listModel = new DefaultListModel();
    private final JMenuItem _copyMenuItem = new JMenuItem("Copy Data Source");
    private final JMenuItem _deleteMenuItem = new JMenuItem("Delete Data Source(s)");
    private final JMenuItem _moveUpMenuItem = new JMenuItem("Move Up");
    private final JMenuItem _moveDownMenuItem = new JMenuItem("Move Down");
    private final RmaJButton _applyButton = new RmaJButton("Apply");
    private final RmaJButton _cancelButton = new RmaJButton("Cancel");
    private final JMenu _addMenuItem = new JMenu("Add Data Source");
    private final Map<CwmsAuthenticationSource, CwmsServersStatus> _statusMap = new HashMap<CwmsAuthenticationSource, CwmsServersStatus>();
    private final PropertyChangeListener _propertyChangeListener = this::updateCurrentStatus;
    private final CwmsServiceStatusChecker _cwmsServiceStatusChecker = new CwmsServiceStatusChecker();
    private CwmsLoginSetupPanel<?> _center = new CwmsLoginSetupNoopPanel();
    private CwmsAuthenticationSource _selectedDataSource;
    private boolean _ignoreSelectionChanges;

    ServerSuiteSetupDialog(Window owner, List<CwmsAuthenticationSource> cwmsAuthenticationSourceList) {
        super(owner, "CWMS Server Setup", true);
        this.initComponents();
        this.fillForm(cwmsAuthenticationSourceList);
        this.addListeners();
        this.setSize(600, 300);
        this.setMinimumSize(new Dimension(600, 300));
        this.setLocationRelativeTo(owner);
        this.updateMenuItems();
    }

    List<CwmsAuthenticationSource> getAuthenticationSources() {
        return IntStream.range(0, this._listModel.getSize()).mapToObj(this._listModel::getElementAt).collect(Collectors.toList());
    }

    CwmsAuthenticationSource getSelectedDataSource() {
        return this._selectedDataSource;
    }

    void addListeners() {
        this._cwmsAuthenticationSourceJList.addListSelectionListener(this::selectionChanged);
        Lookup.getDefault().lookupAll(CwmsAuthenticationSourceBuilder.class).stream().map(CwmsAuthenticationSourceBuilder::newEmptySource).forEach(s -> {
            if (Lookups.forPath((String)s.getLookup()).lookup(LoginSetupPanel.class) != null) {
                JMenuItem jMenuItem = new JMenuItem(s.getDescription());
                jMenuItem.addActionListener(e -> this.addDataSource((CwmsAuthenticationSource)s));
                this._addMenuItem.add(jMenuItem);
            }
        });
        this._copyMenuItem.addActionListener(e -> this.copyDataSource());
        this._deleteMenuItem.addActionListener(e -> this.deleteDataSource());
        this._moveUpMenuItem.addActionListener(e -> this.moveSelectedItemUp());
        this._moveDownMenuItem.addActionListener(e -> this.moveSelectedItemDown());
        this._okButton.addActionListener(e -> this.okAction());
        this._applyButton.addActionListener(e -> this.applyAction());
        this._cancelButton.addActionListener(e -> this.setVisible(false));
    }

    private void copyDataSource() {
        if (this._selectedDataSource != null) {
            CwmsAuthenticationSource newDataSource = ((CwmsAuthenticationSourceBuilder)Lookups.forPath((String)this._selectedDataSource.getLookup()).lookup(CwmsAuthenticationSourceBuilder.class)).copy(this._selectedDataSource);
            this.addDataSource(newDataSource);
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this._center.removePropertyChangeListener(this._propertyChangeListener);
            this._cwmsServiceStatusChecker.shutdown();
        }
        super.setVisible(visible);
    }

    private void moveSelectedItemDown() {
        int index;
        if (this._selectedDataSource != null && (index = this._listModel.indexOf(this._selectedDataSource)) >= 0 && index < this._listModel.size() - 1) {
            try {
                this._ignoreSelectionChanges = true;
                this._listModel.remove(index);
                this._listModel.add(index + 1, this._selectedDataSource);
            }
            finally {
                this._ignoreSelectionChanges = false;
            }
        }
    }

    private void moveSelectedItemUp() {
        int index;
        if (this._selectedDataSource != null && (index = this._listModel.indexOf(this._selectedDataSource)) > 0 && index < this._listModel.size()) {
            try {
                this._ignoreSelectionChanges = true;
                this._listModel.remove(index);
                this._listModel.add(index - 1, this._selectedDataSource);
            }
            finally {
                this._ignoreSelectionChanges = false;
            }
        }
    }

    private void deleteDataSource() {
        if (this._selectedDataSource != null) {
            try {
                this._ignoreSelectionChanges = true;
                this._listModel.removeElement(this._selectedDataSource);
            }
            finally {
                this._ignoreSelectionChanges = false;
            }
            this._selectedDataSource = null;
            this.selectionChanged(null);
            this.setModified(false);
        }
    }

    private void applyAction() {
        if (this.saveCurrentlySelected()) {
            this._cwmsAuthenticationSourceJList.setSelectedValue(this._selectedDataSource, true);
            this._applyButton.setEnabled(false);
        }
    }

    private void okAction() {
        if (this.promptToSave()) {
            this.saveCurrentlySelected();
        }
        if (!this.isModified()) {
            this.setVisible(false);
        }
    }

    private void addDataSource(CwmsAuthenticationSource cwmsAuthenticationSource) {
        if (this.tryToSaveCurrentlySelected()) {
            this._selectedDataSource = cwmsAuthenticationSource;
            this._listModel.addElement(cwmsAuthenticationSource);
            this._cwmsAuthenticationSourceJList.setSelectedValue(cwmsAuthenticationSource, true);
            this.setModified(true);
        }
    }

    private void selectionChanged(ListSelectionEvent e) {
        if (!this._ignoreSelectionChanges) {
            boolean lastDataSourceSaved = this.tryToSaveCurrentlySelected();
            if (lastDataSourceSaved) {
                Optional<CwmsLoginSetupPanel<CwmsAuthenticationSource>> opt;
                this._selectedDataSource = this._cwmsAuthenticationSourceJList.getSelectedValue();
                this.updateMenuItems();
                CwmsLoginSetupPanel center = new CwmsLoginSetupNoopPanel();
                CwmsAuthenticationSource selectedValue = this._cwmsAuthenticationSourceJList.getSelectedValue();
                if (selectedValue != null && (opt = CwmsLoginSetupPanelFactory.getPanelForAuthenticationSource(selectedValue)).isPresent()) {
                    center = opt.get();
                    center.setEnabled(!selectedValue.equals(LocalAuthenticationSource.getInstance()));
                }
                this.remove((Component)((Object)this._center));
                this._center.removePropertyChangeListener(this._propertyChangeListener);
                this._center = center;
                this._center.addPropertyChangeListener(this._propertyChangeListener);
                this.add((Component)((Object)this._center), "Center");
                this.revalidate();
                this.repaint();
            } else {
                this._ignoreSelectionChanges = true;
                this._cwmsAuthenticationSourceJList.setSelectedValue(this._selectedDataSource, true);
                this._ignoreSelectionChanges = false;
            }
        }
    }

    private void updateMenuItems() {
        boolean canEdit = this._selectedDataSource != null && !this._selectedDataSource.equals(LocalAuthenticationSource.getInstance());
        this._copyMenuItem.setEnabled(canEdit);
        this._deleteMenuItem.setEnabled(canEdit);
        this._moveUpMenuItem.setEnabled(canEdit);
        this._moveDownMenuItem.setEnabled(canEdit);
    }

    private boolean tryToSaveCurrentlySelected() {
        boolean lastDataSourceSaved = true;
        this._ignoreSelectionChanges = true;
        if (this._selectedDataSource != null && this.isModified()) {
            if (this.promptToSave()) {
                if (!this.saveCurrentlySelected()) {
                    lastDataSourceSaved = false;
                }
            } else {
                lastDataSourceSaved = false;
            }
        }
        this._ignoreSelectionChanges = false;
        return lastDataSourceSaved;
    }

    private boolean promptToSave() {
        boolean retval = false;
        if (this.isModified()) {
            int save = JOptionPane.showConfirmDialog((Component)((Object)this), "Configuration has changed. Would you like to save?", "Save", 0, 1);
            retval = save == 0;
        }
        return retval;
    }

    private boolean saveCurrentlySelected() {
        try {
            CwmsAuthenticationSource updatedAuthenticationSource = this._center.savePanel();
            if (updatedAuthenticationSource != null) {
                this.ensureNotDuplicate(updatedAuthenticationSource);
                this.setModified(false);
                this._applyButton.setEnabled(false);
                this.replaceSelectedSource(updatedAuthenticationSource);
            }
            return true;
        }
        catch (LoginSetupException e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Error in CWMS Data Source setup\n" + e.getMessage(), "Error", 2);
            LOGGER.log(Level.FINE, "Improper login server setup", e);
            return false;
        }
    }

    private void ensureNotDuplicate(CwmsAuthenticationSource updatedAuthenticationSource) throws LoginSetupException {
        CwmsAuthenticationSource selected = this._cwmsAuthenticationSourceJList.getSelectedValuesList().get(0);
        boolean duplicateFound = this.getAuthenticationSources().stream().filter(s -> !s.equals(selected)).map(CwmsAuthenticationSource::getDisplayName).anyMatch(s -> s.equalsIgnoreCase(updatedAuthenticationSource.getDisplayName()));
        if (duplicateFound) {
            throw new LoginSetupException("Duplicate Name: " + updatedAuthenticationSource.getDisplayName());
        }
    }

    public void setModified(boolean modified) {
        super.setModified(modified);
        this._applyButton.setEnabled(modified);
        if (modified) {
            this.clearCurrentStatus();
        }
    }

    private void clearCurrentStatus() {
        if (this._selectedDataSource != null) {
            this._statusMap.remove(this._selectedDataSource);
            this._cwmsAuthenticationSourceJList.repaint();
        }
    }

    private void updateCurrentStatus(PropertyChangeEvent evt) {
        if ("UPDATE_STATUS".equals(evt.getPropertyName()) && this.saveCurrentlySelected() && this._selectedDataSource != null) {
            SwingUtilities.invokeLater(() -> this.setCursor(Cursor.getPredefinedCursor(3)));
            this._cwmsServiceStatusChecker.checkServerStatus(this._selectedDataSource, null).whenCompleteAsync((o, t) -> {
                if (t != null) {
                    LOGGER.log(Level.SEVERE, "Error attempting unauthenticated connection to the server", (Throwable)t);
                }
                this._statusMap.put(this._selectedDataSource, (CwmsServersStatus)o);
                this.setCursor(Cursor.getDefaultCursor());
                this._cwmsAuthenticationSourceJList.repaint();
                JOptionPane.showMessageDialog((Component)((Object)this), o.getMessage(), "Server Status", 1);
            }, SwingUtilities::invokeLater);
        }
    }

    private void replaceSelectedSource(CwmsAuthenticationSource updatedAuthenticationSource) {
        int index = this._listModel.indexOf(this._selectedDataSource);
        if (this._selectedDataSource != null && index >= 0) {
            this._ignoreSelectionChanges = true;
            boolean updateSelected = index == this._cwmsAuthenticationSourceJList.getSelectedIndex();
            this._listModel.remove(index);
            this._listModel.add(index, updatedAuthenticationSource);
            if (updateSelected) {
                this._cwmsAuthenticationSourceJList.setSelectedValue(updatedAuthenticationSource, false);
            }
            this._ignoreSelectionChanges = false;
        }
        this._selectedDataSource = updatedAuthenticationSource;
    }

    private void fillForm(List<CwmsAuthenticationSource> cwmsAuthenticationSourceList) {
        cwmsAuthenticationSourceList.removeIf(c -> Lookups.forPath((String)c.getLookup()).lookup(LoginSetupPanel.class) == null);
        cwmsAuthenticationSourceList.forEach(this._listModel::addElement);
        this._cwmsAuthenticationSourceJList.setModel(this._listModel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.buildWestPanel(), "West");
        this.add((Component)((Object)this._center), "Center");
        this.add((Component)this.buildSouthPanel(), "South");
        this.addMenuItems();
        this._cwmsAuthenticationSourceJList.setCellRenderer(new CwmsAuthenticationSourceCellRenderer());
    }

    private RmaJPanel buildSouthPanel() {
        RmaJPanel retval = new RmaJPanel((LayoutManager)new FlowLayout(2));
        retval.add((Component)this._okButton);
        retval.add((Component)this._applyButton);
        retval.add((Component)this._cancelButton);
        this._okButton.setPreferredSize(this._cancelButton.getPreferredSize());
        this._applyButton.setPreferredSize(this._cancelButton.getPreferredSize());
        this._applyButton.setEnabled(false);
        return retval;
    }

    private void addMenuItems() {
        JMenu edit = new JMenu("Edit");
        edit.add(this._addMenuItem);
        edit.add(this._copyMenuItem);
        edit.add(this._deleteMenuItem);
        edit.add(new JSeparator());
        edit.add(this._moveUpMenuItem);
        edit.add(this._moveDownMenuItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(edit);
        this.setJMenuBar(menuBar);
    }

    private RmaJPanel buildWestPanel() {
        RmaJPanel leftPanel = new RmaJPanel((LayoutManager)new BorderLayout());
        leftPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createStrokeBorder(new BasicStroke(0.4f), Color.BLACK), "CWMS Data Sources"));
        JScrollPane scrollPane = new JScrollPane(this._cwmsAuthenticationSourceJList);
        leftPanel.add((Component)scrollPane, (Object)"Center");
        leftPanel.setPreferredSize(new Dimension(160, 300));
        return leftPanel;
    }

    Map<CwmsAuthenticationSource, CwmsServersStatus> getServerStatus() {
        return this._statusMap;
    }

    abstract String getConfirmButtonText();

    private final class CwmsAuthenticationSourceCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7799441088157759804L;
        private final JLabel _label = new JLabel();

        private CwmsAuthenticationSourceCellRenderer() {
            this._label.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean expanded) {
            if (LocalAuthenticationSource.getInstance().equals(value)) {
                this._label.setIcon(null);
                this._label.setText(LocalAuthenticationSource.getInstance().getDisplayName());
                this._label.setToolTipText(LocalAuthenticationSource.getInstance().getDescription());
            } else if (value instanceof CwmsAuthenticationSource) {
                CwmsAuthenticationSource cwmsAuthenticationSource = (CwmsAuthenticationSource)value;
                CwmsServersStatus defaultStatus = new CwmsServersStatus(CwmsServersStatus.CwmsServersOnline.UNKNOWN, "");
                CwmsServersStatus status = ServerSuiteSetupDialog.this._statusMap.getOrDefault(cwmsAuthenticationSource, defaultStatus);
                Image image = CwmsServiceStatusChecker.getStatusImage(status);
                this._label.setIcon(new ImageIcon(image));
                this._label.setText(cwmsAuthenticationSource.getDisplayName());
                this._label.setToolTipText(cwmsAuthenticationSource.getDescription());
            }
            if (selected) {
                this._label.setBackground(UIManager.getColor("List.selectionBackground"));
                this._label.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this._label.setBackground(UIManager.getColor("List.background"));
                this._label.setForeground(UIManager.getColor("List.foreground"));
            }
            return this._label;
        }
    }
}

