/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport;

import hec.client.RunObserver;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.SimulationRun;
import hec.event.ActiveRunChangeListener;
import hec.lang.ClientAppCheck;
import hec.model.RunInfo;
import hec.rss.client.RSS;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.plugins.factories.AltPluginDataFactory;
import hec.rss.plugins.model.AltPluginData;
import hec.rss.plugins.opsupport.OpSupportPlugin$1;
import hec.rss.plugins.opsupport.client.OpSupportFrame;
import hec.rss.plugins.opsupport.model.OSAltPluginData;
import hec.rss.plugins.opsupport.model.OpSupportConfig;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class OpSupportPlugin
implements RunObserver,
ActiveRunChangeListener,
ActionListener,
MenuListener {
    private static OpSupportPlugin _plugin = new OpSupportPlugin();
    private JMenu _reportMenu;
    private static RSimSimulationMode _simMode;
    private static OpSupportFrame _osf;

    private OpSupportPlugin() {
        AltPluginDataFactory.getFactory().addAltPluginData("Operation Support", OSAltPluginData.class);
    }

    public void runComplete(Object object) {
        this.updateReportMenu();
    }

    public void activeRunChanged(ChangeEvent changeEvent) {
        this.updateReportMenu();
    }

    private void updateReportMenu() {
    }

    @Override
    public void actionPerformed(ActionEvent object) {
        if ((object = ((EventObject)object).getSource()) instanceof JMenuItem && "opSupportFrame".equalsIgnoreCase(((AbstractButton)(object = (JMenuItem)object)).getActionCommand())) {
            if (_simMode == null) {
                return;
            }
            object = _simMode.getRssRun();
            this.displayOpSupportFrame((RssRun)object);
        }
    }

    public void displayOpSupportFrame(RssRun rssRun) {
        this.displayOsiFrame(rssRun);
    }

    public OpSupportFrame displayOsiFrame(RssRun rssRun) {
        if (_simMode == null) {
            return null;
        }
        if (rssRun == null) {
            String string = "";
            SimulationRun simulationRun = _simMode.getActiveRun();
            if (simulationRun != null) {
                string = simulationRun.getUserName();
            }
            ClientApp.app().postWarning("<html>No Compute Results found. The Alternative <b>" + string + "</b> must be computed before using the OSI.</html>", "OSI Unavailable");
            return null;
        }
        _simMode.getForceRecompute();
        rssRun.updateReleaseOverrides();
        RssAlt rssAlt = rssRun.getAlternative();
        if (rssAlt == null) {
            return null;
        }
        RssSystem rssSystem = rssAlt.getSystem();
        if (_osf == null) {
            _osf = new OpSupportPlugin$1(this);
            _osf.setLocation();
        }
        _osf.setSimMode(_simMode);
        OSAltPluginData oSAltPluginData = (OSAltPluginData)rssAlt.getAltPluginData("Operation Support");
        if (oSAltPluginData == null) {
            oSAltPluginData = new OSAltPluginData();
            oSAltPluginData.setAlt(rssAlt);
            oSAltPluginData.getOSConfig().getActionsScripts().initialize();
            rssAlt.addAltPluginData((AltPluginData)oSAltPluginData);
            rssAlt.setModified(true);
        }
        oSAltPluginData.setSimMode(_simMode);
        _osf.setOSPluginData(oSAltPluginData);
        OpSupportConfig opSupportConfig = oSAltPluginData.getOSConfig();
        opSupportConfig.setRssSystem(rssSystem);
        opSupportConfig.setOSPluginData(oSAltPluginData);
        opSupportConfig.setRssAlt(rssAlt);
        opSupportConfig.initCompute(rssRun);
        _osf.fillForm(opSupportConfig);
        _osf.setVisible(true);
        EventQueue.invokeLater(() -> _osf.toFront());
        return _osf;
    }

    public static void main(String[] object) {
        if (!ClientAppCheck.haveClientApp()) {
            return;
        }
        if (!(ClientApp.app() instanceof RSS)) {
            return;
        }
        _simMode = (RSimSimulationMode)ClientApp.frame().getModeByClass(RSimSimulationMode.class);
        if (_simMode != null) {
            _simMode.addRunObserver((RunObserver)_plugin);
            _simMode.addActiveRunChangedListener((ActiveRunChangeListener)_plugin);
            OpSupportPlugin._plugin._reportMenu = new JMenu("Operations Support");
            object = new JMenuItem("Operation Support Interface");
            ((AbstractButton)object).setActionCommand("opSupportFrame");
            ((AbstractButton)object).addActionListener(_plugin);
            _simMode.addMenuToSimulation((JMenuItem)object);
        }
    }

    public static void main(Object[] objectArray) {
    }

    public static OpSupportPlugin getPlugin() {
        return _plugin;
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
    }

    public static OpSupportFrame getOSI() {
        return _osf;
    }

    public static OpSupportFrame openOSI(RssAlt rssAlt) {
        if (rssAlt == null) {
            return null;
        }
        if (_simMode == null) {
            return null;
        }
        Vector vector = _simMode.getRssRunNames(false);
        String string = null;
        String string2 = rssAlt.getName();
        int n = string2.indexOf(58);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        for (int i = 0; i < vector.size(); ++i) {
            RunInfo runInfo = (RunInfo)vector.get(i);
            if (!runInfo.simRunName.equals(string2)) continue;
            string = runInfo.runName;
            break;
        }
        if (string == null) {
            System.out.println("openOSI:no RssRun found for RssAlt " + string2);
            return null;
        }
        RssRun rssRun = _simMode.getRssRun(string);
        if (rssRun != null) {
            return _plugin.displayOsiFrame(rssRun);
        }
        return null;
    }

    public static OpSupportFrame openOSI(RssRun rssRun) {
        if (rssRun == null) {
            return null;
        }
        if (_simMode == null) {
            return null;
        }
        return _plugin.displayOsiFrame(rssRun);
    }
}

