/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.client;

import hec.client.RunObserver;
import hec.clientapp.client.ClientApp;
import hec.clientapp.model.SimulationRun;
import hec.io.Identifier;
import hec.rss.model.RssAlt;
import hec.rss.plugins.opsupport.client.ActionOrScript;
import hec.rss.plugins.opsupport.client.OSIScriptButton;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$1;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$10;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$11;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$12;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$2;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$3;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$4;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$5;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$6;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$7;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$8;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel$9;
import hec.rss.plugins.opsupport.client.OpSupportMainPanel;
import hec.rss.plugins.opsupport.client.OpSupportPlotPanel;
import hec.rss.plugins.opsupport.client.OpSupportTabPanel;
import hec.rss.plugins.opsupport.client.OpSupportTablePanel;
import hec.rss.plugins.opsupport.client.OpSupportTablePanel$OpSupportTable;
import hec.rss.plugins.opsupport.model.AbstractType;
import hec.rss.plugins.opsupport.model.OSAltPluginData;
import hec.rss.plugins.opsupport.model.OpSupportConfig;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import hec.script.ScriptIdentifier;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJButton;
import rma.swing.RmaJCheckBox;
import rma.swing.table.CellLocation;
import rma.util.RMAIO;

public class OpSupportActionPanel
extends JPanel
implements ItemListener,
ListSelectionListener,
TableModelListener {
    private OpSupportTabConfig _tabConfig;
    private int _runCtr = 0;
    private transient OpSupportTabPanel a;
    private boolean _autoCompute;
    private RmaJCheckBox _autoCalcCheckBox;
    private RmaJButton _computeButton;
    private RmaJButton _calcAllLocalsButton;
    private RmaJButton _calcSelLocalsButton;
    private RmaJButton _hydroRecessionButton;
    private RmaJButton _clearSelectedButton;
    private RmaJButton _clearBelowButton;
    private RmaJButton _clearVariableButton;
    private RmaJButton _clearAllButton;
    private RmaJButton _refreshPlotButton;
    private Action _followupAction;
    private Action _computeLocalFollowupAction;
    private Action _restoreTableSelectionAction;
    private List<ActionOrScript> _labelToAction;
    private Action _computeAction;
    private Action _calcAllLocalsAction;
    private Action _calcSelLocalsAction;
    private Action _hydroRecessionAction;
    private Action _clearSelectedAction;
    private Action _clearBelowAction;
    private Action _clearVariableAction;
    private Action _clearAllAction;
    private Action _refreshPlotAction;
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String DISPLAY_IN_MENU = "displayinmenu";
    public static final String DISPLAY_TO_USER = "displaytouser";
    public static final String DISPLAY_IN_SELECTOR = "displayinselector";
    public static final String ICON_NAME = "iconname";
    public static final String BG_COLOR = "backgroundColor";
    public static final String GROUP = "group";
    public static final String COMPUTE_LABEL = "Compute";
    public static final String CALC_ALL_LOCALS_LABEL = "Calculate All Locals";
    public static final String CALC_LOCAL_LABEL = "Calculate Selected Locals";
    public static final String RECESSION_LABEL = "Hydrograph Recession";
    public static final String CLEAR_SELECTIONS_LABEL = "Clear Selection";
    public static final String CLEAR_BELOW_LABEL = "Clear Below";
    public static final String CLEAR_VARIABLE_LABEL = "Clear Variable";
    public static final String CLEAR_ALL_LABEL = "Clear All";
    public static final String REFRESH_LABEL = "Refresh Plot";
    public static final String AUTOMATIC_CALC_LABEL = "Automatic Calculation on Edit";
    public static final String CALC_LOCAL_FOLLOWUP_LABEL = "CalcLocalFollowup";
    public static final String CALC_RESTORE_TABLE_LABEL = "RestoreTableSelectionFollowup";
    public static final String COMPUTE = "Compute";
    public static final String CALC_ALL_LOCALS = "calcWithObsTSData";
    public static final String CALC_LOCAL = "CalcLocal";
    public static final String RECESSION = "Recession";
    public static final String CLEAR_SELECTIONS = "ClearTimeSeriesSelected";
    public static final String CLEAR_BELOW = "ClearTimeSeriesBelow";
    public static final String CLEAR_VARIABLE = "ClearTimeSeriesVariable";
    public static final String CLEAR_ALL = "ClearTimeSeriesAll";
    public static final String REFRESH = "RefreshPlot";
    public static final String AUTOMATIC_CALC = "CalcLocalFollowup";
    private Vector<Vector<CellLocation>> _selectedCellRange;

    public OpSupportActionPanel(OpSupportTabPanel opSupportTabPanel) {
        super(new GridBagLayout());
        this.createActions();
        this.a = opSupportTabPanel;
        this.createLabelToAction();
        OpSupportActionPanel opSupportActionPanel = this;
        opSupportActionPanel.buildControls(opSupportActionPanel._labelToAction, false);
    }

    public List<ActionOrScript> getLabelToActionList() {
        return this._labelToAction;
    }

    public void createLabelToAction() {
        this._labelToAction = new ArrayList<ActionOrScript>(9);
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, "Compute", "Compute"));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, CALC_ALL_LOCALS_LABEL, CALC_ALL_LOCALS));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, CALC_LOCAL_LABEL, CALC_LOCAL));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, RECESSION_LABEL, RECESSION));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, CLEAR_SELECTIONS_LABEL, CLEAR_SELECTIONS));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, CLEAR_BELOW_LABEL, CLEAR_BELOW));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, CLEAR_VARIABLE_LABEL, CLEAR_VARIABLE));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, CLEAR_ALL_LABEL, CLEAR_ALL));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, REFRESH_LABEL, REFRESH));
        this._labelToAction.add(new ActionOrScript(AbstractType.ACTION, AUTOMATIC_CALC_LABEL, "CalcLocalFollowup"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ScriptIdentifier getScriptId(Identifier identifier) {
        ScriptIdentifier scriptIdentifier;
        if (identifier == null) {
            return null;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(identifier.getPath()));
            scriptIdentifier = new ScriptIdentifier();
            scriptIdentifier.setFileName(identifier.getPath());
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) {
                    if ((string = string.substring(1)).indexOf("=") == -1) continue;
                    String string2 = RMAIO.getType((String)string, (String)"=");
                    string = RMAIO.getParam((String)string, (String)"=");
                    if (NAME.equalsIgnoreCase(string2)) {
                        scriptIdentifier.setUserDisplayedName(string);
                        scriptIdentifier.setName(string);
                        continue;
                    }
                    if (DESCRIPTION.equalsIgnoreCase(string2)) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer = stringBuffer.append("\n");
                        }
                        stringBuffer.append(string);
                        continue;
                    }
                    if (DISPLAY_IN_MENU.equalsIgnoreCase(string2)) {
                        scriptIdentifier.setDisplayedInMenu("true".equalsIgnoreCase(string));
                        continue;
                    }
                    if (DISPLAY_TO_USER.equalsIgnoreCase(string2)) {
                        scriptIdentifier.setDisplayedToUser("true".equalsIgnoreCase(string));
                        continue;
                    }
                    if (DISPLAY_IN_SELECTOR.equalsIgnoreCase(string2)) {
                        scriptIdentifier.setDisplayedInSelector("true".equalsIgnoreCase(string));
                        continue;
                    }
                    if (!ICON_NAME.equalsIgnoreCase(string2)) continue;
                    scriptIdentifier.setIconName(string);
                    continue;
                }
                if (string.length() == 0 || string.startsWith(" ")) continue;
            }
            if (scriptIdentifier.getUserDisplayedName() == null) {
                scriptIdentifier.setUserDisplayedName(RMAIO.getFileNameNoExtension((String)identifier.getPath()));
            }
            scriptIdentifier.setDescription(stringBuffer.toString());
        }
        catch (IOException iOException) {
            try {
                if (bufferedReader == null) return null;
                bufferedReader.close();
                return null;
            }
            catch (IOException iOException2) {}
            return null;
        }
        catch (Throwable throwable) {
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bufferedReader.close();
            return scriptIdentifier;
        }
        catch (IOException iOException) {
            return scriptIdentifier;
        }
    }

    protected void createActions() {
        this._computeLocalFollowupAction = new OpSupportActionPanel$1(this, "CalcLocalFollowup");
        this._restoreTableSelectionAction = new OpSupportActionPanel$2(this, CALC_RESTORE_TABLE_LABEL);
        this._computeAction = new OpSupportActionPanel$3(this, "Compute");
        this._computeAction.putValue("ShortDescription", "<html>Save all data and call the ResSim Compute.</html>");
        this._computeButton = new RmaJButton(this._computeAction);
        this._calcAllLocalsAction = new OpSupportActionPanel$4(this, CALC_ALL_LOCALS_LABEL);
        this._calcAllLocalsAction.putValue("ShortDescription", "<html>Force Observed Flow at Junctions and calculate Local Flows across all Tabs.</html>");
        this._calcAllLocalsButton = new RmaJButton(this._calcAllLocalsAction);
        this._calcSelLocalsAction = new OpSupportActionPanel$5(this, CALC_LOCAL_LABEL);
        this._calcSelLocalsAction.putValue("ShortDescription", "<html>Calculate only the selected Local Flows on the current tab at and above the selected row.<br>If no cells are selected, all locals on the current tab are calculated for all time steps.</html>");
        this._calcSelLocalsButton = new RmaJButton(this._calcSelLocalsAction);
        this._hydroRecessionAction = new OpSupportActionPanel$6(this, RECESSION_LABEL);
        this._hydroRecessionAction.putValue("ShortDescription", "<html>Calculate recession for the selected Local Flows on the current tab below the selected row.<br>If no cells are selected, nothing is done.</html>");
        this._hydroRecessionButton = new RmaJButton(this._hydroRecessionAction);
        this._clearSelectedAction = new OpSupportActionPanel$7(this, CLEAR_SELECTIONS_LABEL);
        this._clearSelectedAction.putValue("ShortDescription", "<html>Clear the selected editable data on the current tab.</html>");
        this._clearSelectedButton = new RmaJButton(this._clearSelectedAction);
        this._clearBelowAction = new OpSupportActionPanel$8(this, CLEAR_BELOW_LABEL);
        this._clearBelowAction.putValue("ShortDescription", "<html>Clear the editable data on the current tab at and below the selected row.</html>");
        this._clearBelowButton = new RmaJButton(this._clearBelowAction);
        this._clearAllAction = new OpSupportActionPanel$9(this, CLEAR_ALL_LABEL);
        this._clearAllAction.putValue("ShortDescription", "<html>Clear all editable data on the current tab.</html>");
        this._clearAllButton = new RmaJButton(this._clearAllAction);
        this._clearVariableAction = new OpSupportActionPanel$10(this, CLEAR_VARIABLE_LABEL);
        this._clearVariableAction.putValue("ShortDescription", "<html>Clear all editable data in the selected variable.</html>");
        this._clearVariableButton = new RmaJButton(this._clearVariableAction);
        this._refreshPlotAction = new OpSupportActionPanel$11(this, REFRESH_LABEL);
        this._refreshPlotAction.putValue("ShortDescription", "<html>Reset axis limits in Graphical Editor Plot.</html>");
        this._refreshPlotButton = new RmaJButton(this._refreshPlotAction);
    }

    public void buildControls(List<ActionOrScript> list, boolean bl) {
        this.removeAll();
        if (list == null) {
            this.revalidate();
            this.repaint();
            return;
        }
        if (bl) {
            this.revalidate();
            this.repaint();
            return;
        }
        Insets insets = new Insets(5, 2, 5, 2);
        int n = 0;
        insets = new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0);
        for (int i = 0; i < list.size(); ++i) {
            ((RmaGridBagConstraints)insets).gridy = n;
            if (list.get(i).getType() == AbstractType.SCRIPT) {
                var5_6 = new Identifier(ClientApp.Workspace().getRelativePath(list.get(i).getValue()));
                ScriptIdentifier scriptIdentifier = OpSupportActionPanel.getScriptId(var5_6);
                if (scriptIdentifier != null) {
                    var5_6 = new OSIScriptButton(scriptIdentifier);
                    if (i == list.size() - 1) {
                        ((RmaGridBagConstraints)insets).weighty = 1.0;
                    }
                    this.add((Component)var5_6, insets);
                }
            } else {
                var5_6 = null;
                boolean bl2 = true;
                if (list.get(i).getValue().equals("Compute")) {
                    var5_6 = this._computeButton;
                } else if (list.get(i).getValue().equals(CALC_ALL_LOCALS)) {
                    var5_6 = this._calcAllLocalsButton;
                } else if (list.get(i).getValue().equals(CALC_LOCAL)) {
                    var5_6 = this._calcSelLocalsButton;
                    bl2 = false;
                } else if (list.get(i).getValue().equals(RECESSION)) {
                    var5_6 = this._hydroRecessionButton;
                    bl2 = false;
                } else if (list.get(i).getValue().equals(CLEAR_SELECTIONS)) {
                    var5_6 = this._clearSelectedButton;
                    bl2 = false;
                } else if (list.get(i).getValue().equals(CLEAR_BELOW)) {
                    var5_6 = this._clearBelowButton;
                    bl2 = false;
                } else if (list.get(i).getValue().equals(CLEAR_VARIABLE)) {
                    var5_6 = this._clearVariableButton;
                    bl2 = false;
                } else if (list.get(i).getValue().equals(CLEAR_ALL)) {
                    var5_6 = this._clearAllButton;
                } else if (list.get(i).getValue().equals(REFRESH)) {
                    var5_6 = this._refreshPlotButton;
                } else if (list.get(i).getValue().equals("CalcLocalFollowup")) {
                    this._autoCalcCheckBox = new RmaJCheckBox(AUTOMATIC_CALC_LABEL);
                    this._autoCalcCheckBox.addItemListener((ItemListener)this);
                    if (i == list.size() - 1) {
                        ((RmaGridBagConstraints)insets).weighty = 1.0;
                    }
                    OpSupportActionPanel opSupportActionPanel = this;
                    opSupportActionPanel.add((Component)opSupportActionPanel._autoCalcCheckBox, insets);
                }
                if (var5_6 != null) {
                    var5_6.setEnabled(bl2);
                    if (i == list.size() - 1) {
                        ((RmaGridBagConstraints)insets).weighty = 1.0;
                    }
                    this.add((Component)var5_6, insets);
                }
            }
            ++n;
        }
        this.revalidate();
        this.repaint();
    }

    public void clearTimeSeriesSelected() {
        if (!this._clearSelectedButton.isEnabled()) {
            return;
        }
        OpSupportActionPanel opSupportActionPanel = this;
        opSupportActionPanel.clearTimeSeries(opSupportActionPanel.getTablePanel()::clearTimeSeriesSelected);
    }

    public void clearTimeSeriesBelow() {
        if (!this._clearBelowButton.isEnabled()) {
            return;
        }
        OpSupportActionPanel opSupportActionPanel = this;
        opSupportActionPanel.clearTimeSeries(opSupportActionPanel.getTablePanel()::clearTimeSeriesBelow);
    }

    public void clearTimeSeriesVariable() {
        if (!this._clearVariableButton.isEnabled()) {
            return;
        }
        OpSupportActionPanel opSupportActionPanel = this;
        opSupportActionPanel.clearTimeSeries(opSupportActionPanel.getTablePanel()::clearTimeSeriesVariable);
    }

    private void clearTimeSeries(Runnable object) {
        if (this._tabConfig == null) {
            return;
        }
        this.saveTableSelection();
        this.getTablePanel().removeTableListener(this);
        object.run();
        this.getTablePanel().fireTableDataChanged();
        object = this._tabConfig.getOSAltPluginData();
        boolean bl = this._tabConfig.getOsConfig().getComputeOnClear();
        if (object != null && bl) {
            RssAlt rssAlt = this._tabConfig.getOsConfig().getRssAlt();
            rssAlt.setUseObsTSData(false);
            this.getMainPanel().saveForm();
            rssAlt = ((OSAltPluginData)((Object)object)).getSimMode();
            rssAlt = rssAlt.getActiveRun();
            this._followupAction = this._restoreTableSelectionAction;
            ((OSAltPluginData)((Object)object)).getSimMode().computeRun((SimulationRun)rssAlt, -1, true);
            ++this._runCtr;
        }
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
        }
    }

    public void clearTimeSeriesAll() {
        if (!this._clearAllButton.isEnabled()) {
            return;
        }
        OpSupportActionPanel opSupportActionPanel = this;
        opSupportActionPanel.clearTimeSeries(opSupportActionPanel.getTablePanel()::clearTimeSeriesAll);
    }

    public void refreshPlot() {
        if (this._tabConfig == null) {
            return;
        }
        if (!this._refreshPlotButton.isEnabled()) {
            return;
        }
        OpSupportPlotPanel opSupportPlotPanel = this.getPlotPanel();
        opSupportPlotPanel.refreshData(true);
    }

    public void calcWithObsTSData() {
        if (this._tabConfig == null) {
            return;
        }
        if (!this._calcAllLocalsButton.isEnabled()) {
            return;
        }
        RssAlt rssAlt = this._tabConfig.getOsConfig().getRssAlt();
        OpSupportActionPanel$12 opSupportActionPanel$12 = null;
        if (this._tabConfig.getOsConfig().getRssAlt().getComputeHoldout()) {
            int n = JOptionPane.showConfirmDialog((Component)((Object)this.getMainPanel()), "<html>Alternative " + rssAlt.getName() + " has Compute Holdouts turned on.<br>To Calculate All Locals, Compute Holdouts must be turned off.<br><br>Do you want to turn off Compute Holdouts temporarily?</html>", "Compute Incompatibility ", 0, 3);
            if (n == 0) {
                rssAlt.setComputeHoldout(false);
                opSupportActionPanel$12 = new OpSupportActionPanel$12(rssAlt);
            } else {
                return;
            }
        }
        this.saveTableSelection();
        this.getTablePanel().removeTableListener(this);
        this._followupAction = this._computeLocalFollowupAction;
        this.getMainPanel().computeResSim(true, opSupportActionPanel$12);
        ++this._runCtr;
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
        }
    }

    public void calcLocal() {
        if (this._tabConfig == null) {
            return;
        }
        if (!this._calcSelLocalsButton.isEnabled()) {
            return;
        }
        this.saveTableSelection();
        this.getTablePanel().removeTableListener(this);
        this._tabConfig.getOSAltPluginData();
        this.getTablePanel().calcLocal();
        this.getTablePanel().fireTableDataChanged();
        this._followupAction = this._restoreTableSelectionAction;
        this.getMainPanel().computeResSim(false);
        ++this._runCtr;
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
        }
    }

    protected void calcLocalFollowup() {
        if (this._tabConfig == null) {
            return;
        }
        this.getTablePanel().removeTableListener(this);
        OSAltPluginData oSAltPluginData = this._tabConfig.getOSAltPluginData();
        if (oSAltPluginData != null) {
            oSAltPluginData = this._tabConfig.getOsConfig().getRssAlt();
            oSAltPluginData.setUseObsTSData(false);
        }
        this.getTablePanel().calcLocal();
        this.getTablePanel().fireTableDataChanged();
        this._followupAction = null;
    }

    protected void setToObs() {
        if (this._tabConfig == null) {
            return;
        }
        this.getTablePanel().removeTableListener(this);
        this.getTablePanel().setToObs();
        this.getTablePanel().fireTableDataChanged();
        OSAltPluginData oSAltPluginData = this._tabConfig.getOSAltPluginData();
        if (oSAltPluginData != null) {
            RssAlt rssAlt = this._tabConfig.getOsConfig().getRssAlt();
            rssAlt.setUseObsTSData(false);
            this.getMainPanel().saveForm();
            rssAlt = oSAltPluginData.getSimMode();
            rssAlt = rssAlt.getActiveRun();
            this._followupAction = null;
            oSAltPluginData.getSimMode().computeRun((SimulationRun)rssAlt, -1, true);
            ++this._runCtr;
        }
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
        }
    }

    public void computeMethod() {
        this.computeMethod(null);
    }

    public void computeMethod(RunObserver runObserver) {
        if (this._tabConfig == null) {
            return;
        }
        this.getTablePanel().removeTableListener(this);
        this.saveTableSelection();
        this._followupAction = this._restoreTableSelectionAction;
        this.getMainPanel().computeResSim(false, runObserver);
        ++this._runCtr;
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
        }
    }

    public void recessionMethod() {
        if (this._tabConfig == null) {
            return;
        }
        if (!this._hydroRecessionButton.isEnabled()) {
            return;
        }
        this.saveTableSelection();
        this.getTablePanel().removeTableListener(this);
        this.getTablePanel().computeRession();
        this.getTablePanel().fireTableDataChanged();
        this._followupAction = this._restoreTableSelectionAction;
        this.getMainPanel().computeResSim(false);
        ++this._runCtr;
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
        }
    }

    public OpSupportMainPanel getMainPanel() {
        return this.a.getMainPanel();
    }

    public OpSupportTablePanel getTablePanel() {
        return this.a.getTablePanel();
    }

    public OpSupportPlotPanel getPlotPanel() {
        return this.a.getPlotPanel();
    }

    public void fillForm(OpSupportTabConfig opSupportTabConfig) {
        this._tabConfig = opSupportTabConfig;
        this._followupAction = null;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this._autoCompute = this._autoCalcCheckBox.isSelected();
        if (this._autoCompute) {
            this.getTablePanel().addTableListener(this);
            return;
        }
        this.getTablePanel().removeTableListener(this);
    }

    public void runFollowupAction() {
        if (this._followupAction != null) {
            this._followupAction.actionPerformed(null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.enableActionsByTableSelection();
    }

    public void enableActionsByTableSelection() {
        OpSupportConfig opSupportConfig;
        OpSupportTablePanel$OpSupportTable opSupportTable = this.getTablePanel().getTable();
        if (opSupportTable == null || this._tabConfig == null) {
            this._clearSelectedButton.setEnabled(false);
            this._clearVariableButton.setEnabled(false);
            this._clearBelowButton.setEnabled(false);
            this._hydroRecessionButton.setEnabled(false);
            this._calcSelLocalsButton.setEnabled(false);
        }
        int[] nArray = opSupportTable.getSelectedColumns();
        opSupportTable.getSelectedColumn();
        int n = opSupportTable.getSelectedRow();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (nArray != null && nArray.length > 0) {
            for (var9_9 = 0; var9_9 < nArray.length; ++var9_9) {
                OpSupportModelVariable opSupportModelVariable = this._tabConfig.getModelVariable(nArray[var9_9]);
                if (opSupportModelVariable == null) continue;
                if (opSupportModelVariable.getVarType() != 3) {
                    bl = true;
                    bl2 = true;
                }
                if (opSupportModelVariable.getVarType() != 1) continue;
                bl3 = true;
                bl4 = true;
            }
        } else if (n >= 0) {
            var9_9 = opSupportTable.getModel().getColumnCount();
            for (int i = 0; i < var9_9; ++i) {
                OpSupportModelVariable opSupportModelVariable = this._tabConfig.getModelVariable(i);
                if (opSupportModelVariable == null) continue;
                if (opSupportModelVariable.getVarType() != 3) {
                    bl = true;
                    bl2 = true;
                }
                if (opSupportModelVariable.getVarType() != 1) continue;
                bl3 = true;
                bl4 = true;
            }
        }
        if ((opSupportConfig = this._tabConfig.getOsConfig()).getProtectLookback()) {
            if (opSupportConfig.stepIsInLookback(n)) {
                bl = false;
            }
            if (opSupportConfig.stepIsInLookback(n + 1)) {
                bl2 = false;
                bl3 = false;
            }
        }
        this._clearSelectedButton.setEnabled(bl);
        this._clearBelowButton.setEnabled(bl2);
        this._hydroRecessionButton.setEnabled(bl3);
        this._clearVariableButton.setEnabled(opSupportTable.getSelectedColumn() != -1);
        this._calcSelLocalsButton.setEnabled(bl4);
        this._calcAllLocalsButton.setEnabled(true);
    }

    protected void clearSaveTableSelection() {
        this._selectedCellRange = null;
    }

    protected void saveTableSelection() {
        this._selectedCellRange = null;
        OpSupportTablePanel$OpSupportTable opSupportTablePanel$OpSupportTable = this.a.getTable();
        if (opSupportTablePanel$OpSupportTable == null) {
            return;
        }
        this._selectedCellRange = opSupportTablePanel$OpSupportTable.getSelectedCellRangeVector();
    }

    protected void restoreTableSelection() {
        if (this._selectedCellRange == null) {
            return;
        }
        OpSupportTablePanel$OpSupportTable opSupportTablePanel$OpSupportTable = this.a.getTable();
        if (opSupportTablePanel$OpSupportTable == null) {
            return;
        }
        boolean bl = false;
        if (this._selectedCellRange != null && this._selectedCellRange.size() > 0) {
            for (int i = 0; i < this._selectedCellRange.size(); ++i) {
                Vector<CellLocation> vector = this._selectedCellRange.get(i);
                if (vector == null || vector.size() <= 0) continue;
                for (int j = 0; j < vector.size(); ++j) {
                    CellLocation cellLocation = vector.get(j);
                    if (cellLocation != null) {
                        opSupportTablePanel$OpSupportTable.updateSelection(cellLocation.getRow(), cellLocation.getCol(), false, bl);
                    }
                    bl = true;
                }
            }
        }
    }
}

