/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.client;

import hec.client.RunObserver;
import hec.clientapp.model.Manager;
import hec.clientapp.model.SimulationRun;
import hec.gui.NameDialog;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.plugins.opsupport.client.ListOrderDlg;
import hec.rss.plugins.opsupport.client.OpSupportTabPanel;
import hec.rss.plugins.opsupport.client.OpSupportTabbedPane;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor;
import hec.rss.plugins.opsupport.model.OSAltPluginData;
import hec.rss.plugins.opsupport.model.OpSupportConfig;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJPanel;

public class OpSupportMainPanel
extends RmaJPanel {
    Frame _parentFrame;
    OpSupportTabbedPane _tabbedPane;
    OpSupportConfig _osConfig;
    private OSAltPluginData _osAltPluginData;

    public OpSupportMainPanel(Frame frame) {
        this._parentFrame = frame;
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        this._tabbedPane = new OpSupportTabbedPane(this);
        Insets insets = new Insets(0, 0, 0, 0);
        OpSupportMainPanel opSupportMainPanel = this;
        opSupportMainPanel.add(opSupportMainPanel._tabbedPane, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
    }

    public void fillForm(OpSupportConfig opSupportConfig) {
        this._osConfig = opSupportConfig;
        if (this._tabbedPane != null) {
            this._tabbedPane.fillForm(opSupportConfig);
        }
    }

    public boolean saveForm() {
        RssRun rssRun;
        boolean bl;
        boolean bl2 = true;
        if (this._tabbedPane != null && !(bl = this._tabbedPane.saveForm())) {
            bl2 = false;
        }
        if ((rssRun = this._osConfig.getRssRun()) == null) {
            return false;
        }
        ReleaseOverrides releaseOverrides = rssRun.getReleaseOverrides();
        if (releaseOverrides != null) {
            releaseOverrides.setForceWrite(true);
            releaseOverrides.storeOverrides();
        }
        if ((releaseOverrides = rssRun.getElevationOverrides()) != null) {
            releaseOverrides.setForceWrite(true);
            releaseOverrides.storeOverrides();
        }
        if ((releaseOverrides = rssRun.getDiversionOverrides()) != null) {
            releaseOverrides.setForceWrite(true);
            releaseOverrides.storeOverrides();
        }
        RssRun rssRun2 = rssRun;
        rssRun2.writeFile(rssRun2.getIdentifier());
        rssRun = this._osConfig.getRssAlt();
        if (rssRun != null) {
            RssRun rssRun3 = rssRun;
            rssRun3.writeFile(rssRun3.getIdentifier());
        }
        return bl2;
    }

    public void deleteCurrentTab() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabConfig opSupportTabConfig = this._osConfig.getTabConfig(n);
        int n2 = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), "Delete Tab \"" + opSupportTabConfig.getName() + "\"?", "Delete Tab", 2);
        if (n2 == 0) {
            this._tabbedPane.remove(n);
            if (this._osConfig != null) {
                this._osConfig.deleteTab(n);
            }
        }
    }

    public void deleteCurrentVariable() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabPanel opSupportTabPanel = (OpSupportTabPanel)this._tabbedPane.getComponentAt(n);
        if (opSupportTabPanel == null) {
            return;
        }
        opSupportTabPanel.deleteCurrentVariable();
    }

    public void addTab() {
        if (this._osConfig == null) {
            return;
        }
        NameDialog nameDialog = this._osConfig.getTabConfigList();
        Object object = new ArrayList(nameDialog.size());
        nameDialog.stream().forEach(opSupportTabConfig -> object.add(opSupportTabConfig.getName()));
        nameDialog = new NameDialog(this._parentFrame, true);
        nameDialog.setTitle("Enter a name for new Operations Support Tab");
        nameDialog.setExistingNames(object);
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        object = nameDialog.getName();
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        object = this._osConfig.addTab((String)object);
        object.setDescription(nameDialog.getDescription());
        this._tabbedPane.addTabConfig((OpSupportTabConfig)object);
        if (this._osConfig != null) {
            this._osConfig.setModified(true);
        }
    }

    public void addVariable() {
        if (this._osConfig == null) {
            return;
        }
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Object object = (OpSupportTabPanel)this._tabbedPane.getSelectedComponent();
        OpSupportTabConfig opSupportTabConfig = ((OpSupportTabPanel)object).getTabConfig();
        NameDialog nameDialog = opSupportTabConfig.getModelVariableList();
        Object object2 = new ArrayList(nameDialog.size());
        nameDialog.stream().forEach(opSupportModelVariable -> object2.add(opSupportModelVariable.getName()));
        nameDialog = new NameDialog(this._parentFrame, true);
        nameDialog.setExistingNames(object2);
        nameDialog.setTitle("New Operations Support Variable");
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        object2 = nameDialog.getName();
        if (object2 == null || ((String)object2).isEmpty()) {
            return;
        }
        object2 = opSupportTabConfig.addModelVariable((String)object2);
        object2.setDescription(nameDialog.getDescription());
        ((OpSupportTabPanel)object).fillForm(opSupportTabConfig);
        if (this._osConfig != null) {
            this._osConfig.setModified(true);
        }
        object = new OpSupportVariableEditor(this._parentFrame, true);
        ((OpSupportVariableEditor)object).setTabConfig(opSupportTabConfig);
        ((OpSupportVariableEditor)object).selectVariable((OpSupportModelVariable)object2);
        ((OpSupportVariableEditor)object).setVisible(true);
        this._osConfig.initCompute();
        this.refreshData();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setOSAltPluginData(OSAltPluginData oSAltPluginData) {
        this._osAltPluginData = oSAltPluginData;
    }

    public void refreshData() {
        if (this._tabbedPane != null) {
            this._tabbedPane.refreshData();
        }
        if (this._osConfig == null) {
            return;
        }
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabPanel opSupportTabPanel = (OpSupportTabPanel)this._tabbedPane.getComponentAt(n);
        if (opSupportTabPanel == null) {
            return;
        }
        opSupportTabPanel.runFollowupAction();
    }

    public void refreshPlot() {
        if (this._tabbedPane != null) {
            this._tabbedPane.refreshPlot();
        }
    }

    public void editVariable() {
        if (this._osConfig == null) {
            return;
        }
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Object object = (OpSupportTabPanel)this._tabbedPane.getComponentAt(n);
        if (object == null) {
            return;
        }
        OpSupportTabConfig opSupportTabConfig = ((OpSupportTabPanel)object).getTabConfig();
        if (opSupportTabConfig == null) {
            return;
        }
        if ((object = ((OpSupportTabPanel)object).getCurrentVariable()) == null) {
            object = opSupportTabConfig.getModelVariable(0);
        }
        OpSupportVariableEditor opSupportVariableEditor = new OpSupportVariableEditor(this._parentFrame, true);
        opSupportVariableEditor.setTabConfig(opSupportTabConfig);
        opSupportVariableEditor.selectVariable((OpSupportModelVariable)object);
        opSupportVariableEditor.setVisible(true);
        if (!opSupportVariableEditor.isCanceled()) {
            if (this._osConfig != null) {
                this._osConfig.setModified(true);
            }
            this._osConfig.initCompute();
            this.refreshData();
        }
    }

    public void saveToFile() {
        ReleaseOverrides releaseOverrides;
        this.saveForm();
        if (this._osConfig == null) {
            return;
        }
        RssAlt rssAlt = this._osConfig.getRssAlt();
        if (rssAlt == null) {
            return;
        }
        this._osAltPluginData.setAlt(rssAlt);
        rssAlt.getProxyList().saveManager(UserId.getUserId(), (Manager)rssAlt);
        rssAlt = this._osConfig.getRssRun();
        if (rssAlt != null) {
            RssAlt rssAlt2 = rssAlt;
            rssAlt2.writeFile(rssAlt2.getIdentifier());
        }
        if ((releaseOverrides = rssAlt.getReleaseOverrides()) != null) {
            releaseOverrides.setForceWrite(true);
            releaseOverrides.storeOverrides();
        }
        rssAlt.setModified(true);
    }

    public void setColWidth() {
        int n;
        String string = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "Enter Column Width", this._osConfig.getColumnWidth());
        if (string != null && (n = Integer.parseInt(string)) > 0) {
            this._tabbedPane.setColWidth(n);
            this._osConfig.setColumnWidth(n);
        }
    }

    public void showDecimalChange(int n) {
        if (this._tabbedPane != null) {
            this._tabbedPane.setDecimalPosition(n);
            this._osConfig.setDecimalPrecision(n);
        }
    }

    protected void computeResSim(boolean bl) {
        this.computeResSim(bl, null);
    }

    protected void computeResSim(boolean bl, RunObserver runObserver) {
        if (this._osAltPluginData == null || this._osConfig == null) {
            return;
        }
        OSAltPluginData oSAltPluginData = this._osAltPluginData;
        if (oSAltPluginData != null) {
            RssAlt rssAlt = this._osConfig.getRssAlt();
            rssAlt.setUseObsTSData(bl);
            this.saveForm();
            RSimSimulationMode rSimSimulationMode = oSAltPluginData.getSimMode();
            if (runObserver != null) {
                rSimSimulationMode.addRunObserver(runObserver);
            }
            rSimSimulationMode = rSimSimulationMode.getActiveRun();
            oSAltPluginData.getSimMode().computeRun((SimulationRun)rSimSimulationMode, -1, true);
        }
    }

    public void calcLocalFollowup() {
        if (this._tabbedPane != null) {
            this._tabbedPane.calcLocalFollowup();
        }
        this.computeResSim(false);
    }

    public void renameCurrentTab() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabConfig opSupportTabConfig2 = this._osConfig.getTabConfig(n);
        if (opSupportTabConfig2 == null) {
            return;
        }
        NameDialog nameDialog = this._osConfig.getTabConfigList();
        Object object = new ArrayList(nameDialog.size());
        nameDialog.stream().forEach(opSupportTabConfig -> object.add(opSupportTabConfig.getName()));
        nameDialog = new NameDialog(this._parentFrame, true);
        nameDialog.setTitle("Enter a new name for Tab " + opSupportTabConfig2.getName());
        nameDialog.setExistingNames(object);
        nameDialog.setName(opSupportTabConfig2.getName());
        nameDialog.setDescription(opSupportTabConfig2.getDescription());
        nameDialog.setVisible(true);
        if (nameDialog.isCanceled()) {
            return;
        }
        object = nameDialog.getName();
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        opSupportTabConfig2.setName((String)object);
        opSupportTabConfig2.setDescription(nameDialog.getDescription());
        this._tabbedPane.setTitleAt(n, (String)object);
    }

    public void orderTabs() {
        if (this._osConfig == null) {
            return;
        }
        List<NamedType> list = this._osConfig.getTabConfigList();
        if (list == null || list.size() <= 0) {
            return;
        }
        ListOrderDlg listOrderDlg = new ListOrderDlg(this._parentFrame, true);
        listOrderDlg.fillForm(list);
        listOrderDlg.setVisible(true);
        if (!listOrderDlg.isCanceled()) {
            if (this._osConfig != null) {
                this._osConfig.setModified(true);
            }
            OpSupportMainPanel opSupportMainPanel = this;
            opSupportMainPanel.fillForm(opSupportMainPanel._osConfig);
        }
    }

    public void renameCurrentVariable() {
        if (this._osConfig == null) {
            return;
        }
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabPanel opSupportTabPanel = (OpSupportTabPanel)this._tabbedPane.getComponentAt(n);
        if (opSupportTabPanel == null) {
            return;
        }
        Object object = opSupportTabPanel.getTabConfig();
        if (object == null) {
            return;
        }
        OpSupportModelVariable opSupportModelVariable2 = opSupportTabPanel.getCurrentVariable();
        if (opSupportModelVariable2 == null) {
            opSupportModelVariable2 = ((OpSupportTabConfig)object).getModelVariable(0);
        }
        object = ((OpSupportTabConfig)object).getModelVariableList();
        Object object2 = new ArrayList(object.size());
        object.stream().forEach(opSupportModelVariable -> object2.add(opSupportModelVariable.getName()));
        object = new NameDialog(this._parentFrame, true);
        object.setTitle("Enter a new name for Variable " + opSupportModelVariable2.getName());
        object.setName(opSupportModelVariable2.getName());
        object.setExistingNames(object2);
        object.setDescription(opSupportModelVariable2.getDescription());
        object.setVisible(true);
        if (object.isCanceled()) {
            return;
        }
        object2 = object.getName();
        if (object2 == null || ((String)object2).length() <= 0) {
            return;
        }
        opSupportModelVariable2.setName((String)object2);
        opSupportModelVariable2.setDescription(object.getDescription());
        opSupportTabPanel.modelVariableModified(opSupportModelVariable2);
    }

    public void orderVariables() {
        if (this._osConfig == null) {
            return;
        }
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabPanel opSupportTabPanel = (OpSupportTabPanel)this._tabbedPane.getComponentAt(n);
        if (opSupportTabPanel == null) {
            return;
        }
        OpSupportTabConfig opSupportTabConfig = opSupportTabPanel.getTabConfig();
        if (opSupportTabConfig == null) {
            return;
        }
        if (opSupportTabConfig.getNumModelVariables() <= 0) {
            return;
        }
        ListOrderDlg listOrderDlg = new ListOrderDlg(this._parentFrame, true);
        listOrderDlg.fillForm(opSupportTabConfig.getModelVariableList());
        listOrderDlg.setVisible(true);
        if (!listOrderDlg.isCanceled()) {
            if (this._osConfig != null) {
                this._osConfig.setModified(true);
            }
            opSupportTabPanel.fillForm(opSupportTabConfig);
        }
    }

    public void protectLookback() {
        if (this._osConfig == null) {
            return;
        }
        this._osConfig.setProtectLookback(!this._osConfig.getProtectLookback());
        int n = this._tabbedPane.getSelectedIndex();
        if (n < 0) {
            return;
        }
        OpSupportTabPanel opSupportTabPanel = (OpSupportTabPanel)this._tabbedPane.getComponentAt(n);
        if (opSupportTabPanel == null) {
            return;
        }
        opSupportTabPanel.getTable().repaint();
    }

    public boolean isProtectLookbackSelected() {
        if (this._osConfig == null) {
            return false;
        }
        return this._osConfig.getProtectLookback();
    }

    public void protectLookbackDefault(boolean bl) {
        if (this._osConfig == null) {
            return;
        }
        this._osConfig.setProtectLookbackDefault(bl);
    }

    public boolean isProtectLookbackDefaultSelected() {
        if (this._osConfig == null) {
            return false;
        }
        return this._osConfig.getProtectLookbackDefault();
    }
}

