/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.client;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.dataui.tx.awt.InterpolationLineData;
import hec.dataui.tx.awt.InterpolationLineGlyph;
import hec.dataui.tx.awt.ScrollViewData;
import hec.dataui.tx.awt.ScrollViewGlyph;
import hec.dataui.tx.awt.VerifyTimeSeriesGlyph;
import hec.gfx2d.DataTypeFactory;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dGlyphDrawProp;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.ObjectSelectionEvent;
import hec.gfx2d.ObjectSelectionListener;
import hec.gfx2d.PlotLayout;
import hec.gfx2d.TimeSeriesDataSet;
import hec.gfx2d.ToolbarButtonProp;
import hec.gfx2d.Viewport;
import hec.gfx2d.ViewportLayout;
import hec.heclib.dss.DSSPathname;
import hec.io.TimeSeriesContainer;
import hec.model.TSRecord;
import hec.rss.model.RssRun;
import hec.rss.plugins.opsupport.client.OpSupportPlotLine;
import hec.rss.plugins.opsupport.client.OpSupportPlotPanel$1;
import hec.rss.plugins.opsupport.client.OpSupportPlotPanel$MyG2dPanel;
import hec.rss.plugins.opsupport.client.OpSupportTabPanel;
import hec.rss.plugins.opsupport.model.OSVariableTSRef;
import hec.rss.plugins.opsupport.model.OSVerifyTSDataSet;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import hec.rss.plugins.opsupport.model.OsiDataType;
import hec.rss.plugins.opsupport.model.OsiDataTypeFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTable;
import rma.services.ServiceLookup;
import rma.services.units.UnitsDisplayService;
import rma.swing.RmaGridBagConstraints;

public class OpSupportPlotPanel
extends JPanel
implements ObjectSelectionListener {
    private OpSupportTabPanel _tabPanel;
    private OpSupportPlotPanel$MyG2dPanel _plot1;
    private ScrollViewData _scrollViewData = null;
    private List<G2dObject> _plotVec;
    private List<G2dObject> _plotVecWithComparison;
    private List<Color> _colorVec;
    private PlotLayout _plotLayout;
    private List<OpSupportPlotLine> _plotLines;
    private int _editMVIndex = 0;
    private boolean _hasEditableTimeSeries;
    private OpSupportTabConfig _tabConfig;
    private OSVerifyTSDataSet _vts;
    private TimeSeriesContainer _tsc;
    FocusListener _plotFocusListener = new OpSupportPlotPanel$1(this);

    public OpSupportPlotPanel(OpSupportTabPanel opSupportTabPanel) {
        this._tabPanel = opSupportTabPanel;
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        this._plot1 = new OpSupportPlotPanel$MyG2dPanel(this);
        this.buildPlotComponents();
        OpSupportPlotPanel opSupportPlotPanel = this;
        opSupportPlotPanel.add((Component)((Object)opSupportPlotPanel._plot1), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
    }

    public void fillForm(OpSupportTabConfig opSupportTabConfig, int n) {
        this._tabConfig = opSupportTabConfig;
        if (this._tabConfig == null) {
            return;
        }
        this.buildPlotData(n);
        this.buildPlotComponents();
        opSupportTabConfig = ServiceLookup.getTimeZoneDisplayService();
        UnitsDisplayService unitsDisplayService = ServiceLookup.getUnitsDisplayService();
        this._plot1.setTimeZone(opSupportTabConfig.getTimeZone());
        this._plot1.setDisplayUnitsSystem(unitsDisplayService.getDisplayUnitsSystem());
    }

    private void buildPlotComponents() {
        boolean bl;
        OsiDataType osiDataType;
        if (this._plot1 == null) {
            return;
        }
        this._plot1.removeObjectSelectionListener(this);
        this._plot1.removeFocusListener(this._plotFocusListener);
        this._plot1.setVisible(false);
        this._plot1.clearPanel();
        if (this._plotLayout == null) {
            this._plot1.buildDefaultComponents();
        } else {
            this._plot1.buildComponents(this._plotLayout);
        }
        OsiDataTypeFactory osiDataTypeFactory = OsiDataTypeFactory.getFactory();
        G2dLineProperties g2dLineProperties = osiDataTypeFactory.getLineProperties("ALL", "Visible Table Range");
        G2dLineProperties g2dLineProperties2 = osiDataTypeFactory.getLineProperties("ALL", "Time Associated with Selected Table Row");
        OsiDataType osiDataType2 = osiDataTypeFactory.getDataType("ALL", "Visible Table Range");
        int n = (osiDataType2 != null ? osiDataType2.isDrawn() : 0) ? 1 : 0;
        OsiDataType osiDataType3 = osiDataTypeFactory.getDataType("ALL", "Time Associated with Selected Table Row");
        boolean bl2 = osiDataType3 != null ? osiDataType3.isDrawn() : false;
        Viewport[] viewportArray = this._plot1.getViewports();
        if (n != 0 || bl2) {
            if (n == 0) {
                g2dLineProperties._drawLine = false;
                g2dLineProperties._drawPoints = false;
                g2dLineProperties.setFillType(0);
            }
            if (!bl2) {
                g2dLineProperties2._drawLine = false;
                g2dLineProperties2._drawPoints = false;
            }
            for (n = 0; this._scrollViewData != null && viewportArray != null && n < viewportArray.length; ++n) {
                viewportArray[n].getGlyphVector();
                ScrollViewGlyph scrollViewGlyph = new ScrollViewGlyph(viewportArray[n], this._scrollViewData, viewportArray[n].getScale());
                G2dGlyphDrawProp g2dGlyphDrawProp = scrollViewGlyph.getProperties();
                scrollViewGlyph.getProperties().polygonProperties = new G2dPolygonProperties();
                g2dGlyphDrawProp.lineProperties = new ArrayList();
                g2dGlyphDrawProp.lineProperties.add(g2dLineProperties2);
                g2dGlyphDrawProp.polygonProperties.setDrawBackground(g2dLineProperties.getFillType() != 0);
                g2dGlyphDrawProp.polygonProperties.setLineColor(g2dLineProperties.getLineColor());
                g2dGlyphDrawProp.polygonProperties.setBackgroundColor(g2dLineProperties.getFillColor());
                g2dGlyphDrawProp.polygonProperties.setBackgroundFill(g2dLineProperties.getFillPattern());
                scrollViewGlyph.setProperties(g2dGlyphDrawProp);
                viewportArray[n].insertG2dGlyph((G2dGlyph)scrollViewGlyph, 0);
                viewportArray[n].setDoubleBuffered(false);
            }
        }
        boolean bl3 = (osiDataType = osiDataTypeFactory.getDataType("ALL", "Revised Time Series")) != null ? osiDataType.isDrawn() : false;
        OsiDataType osiDataType4 = osiDataTypeFactory.getDataType("ALL", "Selected Data Point");
        boolean bl4 = bl = osiDataType4 != null ? osiDataType4.isDrawn() : false;
        if (this._hasEditableTimeSeries && (bl3 || bl)) {
            osiDataTypeFactory = new ToolbarButtonProp();
            new ToolbarButtonProp().up = "Images/edit.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).down = "Images/edit.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).over = "Images/edit.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).on = "Images/edit.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).adapter = "hec.dataui.tx.awt.ValidationEditAdapter";
            ((ToolbarButtonProp)osiDataTypeFactory).toolTipText = "Single Point Edit";
            this._plot1.addTool((ToolbarButtonProp)osiDataTypeFactory);
            osiDataTypeFactory = new ToolbarButtonProp();
            new ToolbarButtonProp().up = "Images/drawLine.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).down = "Images/drawLine.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).over = "Images/drawLine.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).on = "Images/drawLine.gif";
            ((ToolbarButtonProp)osiDataTypeFactory).adapter = "hec.dataui.tx.awt.InterpolationLineAdapter";
            ((ToolbarButtonProp)osiDataTypeFactory).toolTipText = "Multi-point Edit";
            this._plot1.addTool((ToolbarButtonProp)osiDataTypeFactory);
        }
        this._plot1.addObjectSelectionListener(this);
        this._plot1.addFocusListener(this._plotFocusListener);
        this._plot1.setVisible(true);
    }

    public void reloadPlotData() {
        if (this._tabConfig == null || this._editMVIndex < 0 || this._vts == null) {
            return;
        }
        Object object = this._tabConfig.getModelVariable(this._editMVIndex);
        if (object == null) {
            this._editMVIndex = 0;
            object = this._tabConfig.getModelVariable(0);
        }
        if (object == null) {
            return;
        }
        boolean bl = false;
        Object object2 = ((OpSupportModelVariable)object).getEditableTSContainer();
        if (object2 != null && ((TimeSeriesContainer)object2).values != null) {
            this._vts.setDataValues(((TimeSeriesContainer)object2).values);
            bl = !OsiDataTypeFactory.PER_AVER.equals(((TimeSeriesContainer)object2).type);
        }
        Object object3 = OsiDataTypeFactory.getFactory().getLineProperties("ALL", "Editable Time Series", "", bl, true);
        object2 = new Vector();
        ((OpSupportModelVariable)object).getSupportingPlotTSRecords((List<OpSupportPlotLine>)object2, (G2dLineProperties)object3);
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            object3 = (OpSupportPlotLine)object.next();
            Viewport[] viewportArray = this._plot1.getViewports();
            object2 = viewportArray;
            object2 = viewportArray;
            int n = viewportArray.length;
            block1: for (int i = 0; i < n; ++i) {
                Iterator iterator = object2[i];
                iterator = iterator.getGlyphVector();
                iterator = ((Vector)((Object)iterator)).iterator();
                while (iterator.hasNext()) {
                    G2dGlyph g2dGlyph = (G2dGlyph)iterator.next();
                    G2dObject g2dObject = g2dGlyph.getG2dObject();
                    if (!((OpSupportPlotLine)object3).getG2dObject().getName().equals(g2dObject.getName()) || !(g2dObject instanceof TimeSeriesDataSet)) continue;
                    ((TimeSeriesDataSet)g2dObject).times = ((TimeSeriesDataSet)((OpSupportPlotLine)object3).getG2dObject()).times;
                    ((TimeSeriesDataSet)g2dObject).ydata = ((OpSupportPlotLine)object3).getG2dObject().getYValues(0);
                    g2dGlyph.update(null, (Object)"reset data");
                    continue block1;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildPlotData(int n) {
        Object object;
        int n2;
        void var3_8;
        if (this._tabConfig == null || this._tabPanel == null) {
            return;
        }
        this._editMVIndex = n;
        OpSupportModelVariable object2 = this._tabConfig.getModelVariable(this._editMVIndex);
        if (object2 == null) {
            this._editMVIndex = 0;
            object2 = this._tabConfig.getModelVariable(0);
        }
        if (object2 == null) {
            this._plotLayout = null;
            return;
        }
        OsiDataTypeFactory osiDataTypeFactory = OsiDataTypeFactory.getFactory();
        boolean n3 = false;
        RssRun rssRun = this._tabConfig.getOsConfig().getRssRun();
        rssRun = rssRun.getRunTimeWindow();
        int n4 = rssRun.getLookbackTime().value();
        int n5 = rssRun.getEndTime().value();
        this._plotLines = new ArrayList<OpSupportPlotLine>();
        this._hasEditableTimeSeries = false;
        this._tsc = object2.getEditableTSContainer();
        if (this._tsc != null && this._tsc.times != null) {
            this._hasEditableTimeSeries = true;
            if (OsiDataTypeFactory.PER_AVER.equals(this._tsc.type)) {
                boolean object6 = false;
            } else {
                boolean bl = true;
            }
        }
        Object object3 = osiDataTypeFactory.getLineProperties("ALL", "Editable Time Series", "", (boolean)var3_8, true);
        OsiDataType osiDataType = osiDataTypeFactory.getDataType("ALL", "Editable Time Series");
        boolean bl = osiDataType != null ? osiDataType.isDrawn() : false;
        if (!bl) {
            object3 = null;
        }
        object2.getSupportingPlotTSRecords(this._plotLines, (G2dLineProperties)object3);
        if (this._hasEditableTimeSeries) {
            this._vts = new OSVerifyTSDataSet(n4, n5, null, this._tsc);
            try {
                this._vts.setYParameterId(new Parameter(this._tsc.getParameterName()).getParameterId());
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                Logger.getLogger(OpSupportPlotPanel.class.getName()).log(Level.SEVERE, null, dataSetIllegalArgumentException);
            }
            this._vts.setDirectEdit(true);
            G2dLineProperties g2dLineProperties = osiDataTypeFactory.getLineProperties("ALL", "Revised Time Series", "", (boolean)var3_8, true);
            G2dLineProperties g2dLineProperties2 = osiDataTypeFactory.getLineProperties("ALL", "Selected Data Point", "", (boolean)var3_8, true);
            this._vts.setSelectedDrawProperties(g2dLineProperties2);
            object3 = osiDataTypeFactory.getDataType("ALL", "Revised Time Series");
            bl = object3 != null ? ((OsiDataType)((Object)object3)).isDrawn() : false;
            OsiDataType osiDataType2 = osiDataTypeFactory.getDataType("ALL", "Selected Data Point");
            int n6 = n2 = (int)((osiDataType2 != null ? osiDataType2.isDrawn() : 0) ? 1 : 0);
            if (bl || n2 != 0) {
                if (!bl) {
                    g2dLineProperties._drawLine = false;
                    g2dLineProperties._drawPoints = false;
                }
                if (n2 == 0) {
                    g2dLineProperties2._drawLine = false;
                    g2dLineProperties2._drawPoints = false;
                }
                object3 = new ArrayList<G2dLineProperties>();
                object3.add(g2dLineProperties);
                object3.add(g2dLineProperties2);
                object3.add(g2dLineProperties2);
                this._plotLines.add(new OpSupportPlotLine(object2.getViewport(), (G2dObject)this._vts, (List<G2dLineProperties>)object3));
            }
            object3 = new InterpolationLineData((G2dObject)this._vts);
            g2dLineProperties = osiDataTypeFactory.getLineProperties("ALL", "Selected Data Point", "", (boolean)var3_8, true);
            this._plotLines.add(new OpSupportPlotLine(object2.getViewport(), (G2dObject)object3, g2dLineProperties));
            if (this._scrollViewData == null) {
                this._scrollViewData = new ScrollViewData();
            }
            this._scrollViewData.setData((JTable)((Object)this._tabPanel.getTablePanel().getTable()), this._tabPanel.getTablePanel().getTable().getScrollPane(), 0, (G2dObject)this._vts);
        }
        this._plotLayout = new PlotLayout();
        this._plotLayout.setTitle(object2.getName());
        int n7 = -1;
        for (OpSupportPlotLine opSupportPlotLine : this._plotLines) {
            n2 = opSupportPlotLine.getViewport();
            if (n7 >= n2) continue;
            n7 = n2;
        }
        Object object4 = new int[n7 + 1];
        ViewportLayout[] viewportLayoutArray = new ViewportLayout[n7 + 1];
        for (OpSupportPlotLine opSupportPlotLine : this._plotLines) {
            int n8 = opSupportPlotLine.getViewport();
            if (viewportLayoutArray[n8] != null) continue;
            object4[n8] = true;
        }
        for (int i = 0; i < ((Object)object4).length; ++i) {
            if (object4[i] <= 0) continue;
            viewportLayoutArray[i] = this._plotLayout.addViewport();
            viewportLayoutArray[i].setAxisName("Y1", "Y1Axis" + i);
            viewportLayoutArray[i].setAxisName("Y2", "Y2Axis" + i);
        }
        DataTypeFactory.getFactory().reset();
        DataTypeFactory dataTypeFactory = DataTypeFactory.getFactory();
        for (OpSupportPlotLine opSupportPlotLine : this._plotLines) {
            G2dObject g2dObject = opSupportPlotLine.getG2dObject();
            String string = g2dObject.getYAxisName();
            object2 = viewportLayoutArray[opSupportPlotLine.getViewport()];
            object2.getAxisName("Y1");
            object2.getAxisName("Y2");
            int n9 = g2dObject.getCurveCount();
            List<G2dLineProperties> list = opSupportPlotLine.getLineProperties();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < n9; ++i) {
                if (list == null || i >= list.size() || list.get(i) == null) {
                    if (g2dObject instanceof TimeSeriesDataSet) {
                        object = ((TimeSeriesDataSet)g2dObject).getData().parameter;
                        object = dataTypeFactory.getParameter((String)object);
                    } else {
                        object = null;
                    }
                    object = dataTypeFactory.getLineProperties(g2dObject, (String)object, true);
                    if (rssRun.isPerAvgTimeStep() && !string.toUpperCase().startsWith("ELEV") && !string.toUpperCase().startsWith("STOR")) {
                        object.setLineStepStyle(1);
                    } else {
                        object.setLineStepStyle(0);
                    }
                    arrayList.add(object);
                    continue;
                }
                arrayList.add(list.get(i));
            }
            List list2 = object2.getY1Data("X1");
            object = object2.getY2Data("X1");
            if (list2 == null || list2.size() == 0 || ((G2dData)list2.get(0)).getYParameterId() == g2dObject.getYParameterId()) {
                object2.addCurve("Y1", g2dObject, arrayList);
                continue;
            }
            if (object != null && object.size() != 0 && ((G2dData)object.get(0)).getYParameterId() != g2dObject.getYParameterId()) continue;
            object2.addCurve("Y2", g2dObject, arrayList);
        }
        Object object5 = osiDataTypeFactory.getDataType("ALL", "Start of Forecast");
        boolean bl2 = object5 != null ? ((OsiDataType)((Object)object5)).isDrawn() : false;
        if (bl2) {
            int n9 = this._tabConfig.getOsConfig().getRssRun().getRunTimeWindow().getStartTime().value();
            osiDataTypeFactory = OsiDataTypeFactory.getFactory().getMarkerProperties("ALL", "Start of Forecast");
            ViewportLayout[] viewportLayoutArray2 = viewportLayoutArray;
            int n10 = viewportLayoutArray.length;
            for (int i = 0; i < n10; ++i) {
                object = viewportLayoutArray2[i];
                if (object == null) continue;
                object.addMarkerLine("X1", (double)n9, (G2dMarkerProperties)osiDataTypeFactory);
            }
        }
    }

    public void refreshData() {
        Object object;
        Object object2 = this._tabConfig.getModelVariable(this._editMVIndex);
        if (object2 == null) {
            this._editMVIndex = 0;
            object2 = this._tabConfig.getModelVariable(0);
        }
        Object object3 = this._plot1.getPlotObjects();
        ArrayList<String> arrayList = new ArrayList<String>();
        object3 = ((Vector)object3).iterator();
        while (object3.hasNext()) {
            object = object3.next();
            if (!(object instanceof TimeSeriesDataSet)) continue;
            arrayList.add(((TimeSeriesDataSet)object).getData().fullName);
        }
        object3 = ((OpSupportModelVariable)object2).getSupportingTSRefList();
        if (object3.size() != arrayList.size()) {
            this.refreshData(true);
            return;
        }
        object = new ArrayList();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object3 = (OSVariableTSRef)object2.next();
            TSRecord tSRecord = ((OSVariableTSRef)object3).getTSRecord();
            if (tSRecord != null) {
                ((ArrayList)object).add((String)tSRecord.getTimeSeriesContainer().fullName);
                continue;
            }
            System.out.println("WARNING: Did not find TSRecord for Supplemental Plot Variable: " + object3.toString());
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object3 = (String)object2.next();
            boolean bl = true;
            for (String string : object) {
                if (!DSSPathname.areSamePathnames((String)object3, (String)string, (boolean)false)) continue;
                bl = false;
            }
            if (!bl) continue;
            this.refreshData(true);
            return;
        }
        this.refreshData(false);
    }

    public void refreshData(boolean bl) {
        if (this._tabConfig == null) {
            return;
        }
        if (this._vts != null && !bl) {
            this.reloadPlotData();
            this._plot1.paintGfx();
        } else {
            OpSupportPlotPanel opSupportPlotPanel = this;
            opSupportPlotPanel.buildPlotData(opSupportPlotPanel._editMVIndex);
            this.buildPlotComponents();
        }
        ServiceLookup.getUnitsDisplayService().updateUnitSystem((Container)((Object)this._plot1));
        this._plot1.paintGfx();
    }

    public void objectSelectionChanged(ObjectSelectionEvent object) {
        if (object != null && object.getSource() instanceof VerifyTimeSeriesGlyph) {
            object = (VerifyTimeSeriesGlyph)object.getSource();
            int[] nArray = object.getSelectedPoints();
            object = nArray;
            if (nArray == null || ((ObjectSelectionEvent)object).length <= 0) {
                return;
            }
            this._tabPanel.setSelectedRows((int[])object);
            return;
        }
        if (object != null && object.getSource() instanceof InterpolationLineGlyph) {
            object = (InterpolationLineGlyph)object.getSource();
            double[][] dArray = object.getInterpolationLine();
            object = dArray;
            if (dArray != null) {
                this._tabPanel.interpolateToLine(this._editMVIndex, (double[])object[0], (double[])object[1]);
            }
        }
    }
}

