/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.client;

import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dMarkerProperties;
import hec.gfx2d.LineProperties;
import hec.gfx2d.PlotProperties;
import hec.gfx2d.Symbol;
import hec.rss.plugins.opsupport.client.OpSupportPropsEditor;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import rma.swing.RmaJTable;
import rma.util.FillPatternFactory;

class OpSupportPropsEditor$LinePropertiesRenderer
extends JPanel
implements TableCellRenderer {
    String _sampleText;
    int strLen;
    PlotProperties _props;
    final /* synthetic */ OpSupportPropsEditor this$0;

    OpSupportPropsEditor$LinePropertiesRenderer(OpSupportPropsEditor opSupportPropsEditor) {
        this.this$0 = opSupportPropsEditor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setBorder(BorderFactory.createLineBorder(jTable.getSelectionBackground()));
        } else {
            this.setBorder(null);
        }
        this._props = (PlotProperties)jTable.getValueAt(n, n2);
        object = jTable.getCellRect(n, n2, false);
        this.setSize(((Rectangle)object).width, ((Rectangle)object).height);
        this.setBackground(((RmaJTable)jTable).getCellBackground(n, n2));
        if (this._props == null) {
            return new JLabel();
        }
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Color color = graphics.getColor();
        if (this._props instanceof G2dLineProperties) {
            this.paintLine(graphics, (G2dLineProperties)this._props);
        } else if (this._props instanceof G2dMarkerProperties) {
            this.paintMarker(graphics, (G2dMarkerProperties)this._props);
        }
        graphics.setColor(color);
    }

    public void paintMarker(Graphics graphics, G2dMarkerProperties g2dMarkerProperties) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.white);
        graphics.fillRect(15, 20, dimension.width - 30, dimension.height - 30);
        graphics.setColor(g2dMarkerProperties.getLineColor());
        this.drawCenterCenter(graphics, (LineProperties)g2dMarkerProperties);
    }

    protected void paintLine(Graphics graphics, G2dLineProperties g2dLineProperties) {
        Dimension dimension = this.getSize();
        if (g2dLineProperties.getFillType() != 0) {
            graphics.setColor(g2dLineProperties.getFillColor());
            Paint paint = ((Graphics2D)graphics).getPaint();
            ((Graphics2D)graphics).setPaint(FillPatternFactory.createFillPattern((int)g2dLineProperties.getFillType(), (Color)g2dLineProperties.getFillColor()));
            graphics.fillRect(15, 20, dimension.width - 30, dimension.height - 30);
            ((Graphics2D)graphics).setPaint(paint);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(15, 20, dimension.width - 30, dimension.height - 30);
        }
        graphics.setColor(g2dLineProperties.getLineColor());
        if (g2dLineProperties.hasLabel()) {
            this._sampleText = g2dLineProperties.getLabel();
            this.strLen = graphics.getFontMetrics().stringWidth(this._sampleText);
        } else {
            this._sampleText = null;
            this.strLen = 0;
        }
        if (g2dLineProperties.getLabelPosition() == 0 && g2dLineProperties.getLabelAlignment() == 0) {
            this.drawAboveLeft(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 0 && g2dLineProperties.getLabelAlignment() == 2) {
            this.drawAboveCenter(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 0 && g2dLineProperties.getLabelAlignment() == 1) {
            this.drawAboveRight(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 1 && g2dLineProperties.getLabelAlignment() == 0) {
            this.drawBelowLeft(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 1 && g2dLineProperties.getLabelAlignment() == 2) {
            this.drawBelowCenter(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 1 && g2dLineProperties.getLabelAlignment() == 1) {
            this.drawBelowRight(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 2 && g2dLineProperties.getLabelAlignment() == 2) {
            this.drawCenterCenter(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 2 && g2dLineProperties.getLabelAlignment() == 1) {
            this.drawCenterRight(graphics, (LineProperties)g2dLineProperties);
            return;
        }
        if (g2dLineProperties.getLabelPosition() == 2 && g2dLineProperties.getLabelAlignment() == 0) {
            this.drawCenterLeft(graphics, (LineProperties)g2dLineProperties);
        }
    }

    private void drawAboveLeft(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, 15, dimension.height / 2 + 2 - graphics.getFontMetrics().getDescent());
        }
    }

    private void drawAboveCenter(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, dimension.width / 2 - this.strLen / 2, dimension.height / 2 + 2 - graphics.getFontMetrics().getDescent());
        }
    }

    private void drawAboveRight(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, dimension.width - 15 - this.strLen, dimension.height / 2 + 2 - graphics.getFontMetrics().getDescent());
        }
    }

    private void drawBelowLeft(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, 10, dimension.height / 2 + 2 + graphics.getFontMetrics().getAscent());
        }
    }

    private void drawBelowCenter(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, dimension.width / 2 - this.strLen / 2, dimension.height / 2 + 2 + graphics.getFontMetrics().getAscent());
        }
    }

    private void drawBelowRight(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, dimension.width - 10 - this.strLen, dimension.height / 2 + 2 + graphics.getFontMetrics().getAscent());
        }
    }

    private void drawCenterRight(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width - 12 - this.strLen, dimension.height / 2 + 2);
        this.drawLine(graphics, lineProperties, dimension.width - 10 + 2, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, dimension.width - 15 - this.strLen, dimension.height / 2 + 2 + graphics.getFontMetrics().getAscent() / 2 - 1);
        }
    }

    private void drawCenterCenter(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, dimension.width / 2 - this.strLen / 2 - 2, dimension.height / 2 + 2);
        this.drawLine(graphics, lineProperties, dimension.width / 2 + this.strLen / 2 + 2, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, dimension.width / 2 - this.strLen / 2, dimension.height / 2 + 2 + graphics.getFontMetrics().getAscent() / 2 - 1);
        }
    }

    private void drawCenterLeft(Graphics graphics, LineProperties lineProperties) {
        Dimension dimension = this.getSize();
        this.drawLine(graphics, lineProperties, 5, dimension.height / 2 + 2, 8, dimension.height / 2 + 2);
        this.drawLine(graphics, lineProperties, 10 + this.strLen + 2, dimension.height / 2 + 2, dimension.width - 5, dimension.height / 2 + 2);
        if (this._sampleText != null) {
            graphics.setColor(Color.black);
            graphics.drawString(this._sampleText, 15, dimension.height / 2 + 2 + graphics.getFontMetrics().getAscent() / 2 - 1);
        }
    }

    private void drawLine(Graphics graphics, LineProperties lineProperties, int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        Object object3;
        int n5 = lineProperties.getFillType();
        Color color = graphics.getColor();
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n5 != 0) {
            Paint paint = lineProperties.getFillColor();
            if (lineProperties.getFillPattern() == 0) {
                graphics2D.setColor((Color)paint);
                if (n5 == 1) {
                    graphics2D.fillRect(5, 2, dimension.width - 9, dimension.height / 2);
                } else if (n5 == 2) {
                    graphics2D.fillRect(5, dimension.height / 2 + 2, dimension.width - 9, dimension.height / 2 - 2);
                }
            } else {
                object3 = ((Graphics2D)graphics).getComposite();
                object2 = AlphaComposite.getInstance(3, 0.5f);
                object = graphics2D.getPaint();
                int n6 = lineProperties.getFillPattern();
                paint = FillPatternFactory.createFillPattern((int)n6, (Color)paint);
                graphics2D.setPaint(paint);
                ((Graphics2D)graphics).setComposite((Composite)object2);
                if (n5 == 1) {
                    graphics2D.fillRect(5, 2, dimension.width - 9, dimension.height / 2);
                } else if (n5 == 2) {
                    graphics2D.fillRect(5, dimension.height / 2 + 2, dimension.width - 9, dimension.height / 2 - 2);
                }
                graphics2D.setComposite((Composite)object3);
                graphics2D.setPaint((Paint)object);
            }
        }
        if (lineProperties.drawLine()) {
            float f = lineProperties.getLineWidth();
            object3 = lineProperties.getLinePattern();
            graphics.setColor(lineProperties.getLineColor());
            object2 = graphics2D.getStroke();
            object = new BasicStroke(f, 0, 0, 10.0f, (float[])object3, 0.0f);
            graphics2D.setStroke((Stroke)object);
            graphics.drawLine(n, n2, n3, n4);
            graphics2D.setStroke((Stroke)object2);
        }
        if (lineProperties.drawPoints()) {
            Symbol.draw((Graphics)graphics, (int)(dimension.width / 2), (int)(dimension.height / 2 + 2), (int)lineProperties.getSymbolType(), (Color)lineProperties.getPointLineColor(), (Color)lineProperties.getPointFillColor(), (float)lineProperties.getSymbolSize());
        }
        graphics.setColor(color);
    }
}

