/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.client;

import com.google.common.flogger.FluentLogger;
import hec.rss.plugins.opsupport.client.ActionOrScript;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel;
import hec.rss.plugins.opsupport.client.OpSupportMainPanel;
import hec.rss.plugins.opsupport.client.OpSupportPlotPanel;
import hec.rss.plugins.opsupport.client.OpSupportTabPanel$1;
import hec.rss.plugins.opsupport.client.OpSupportTabbedPane;
import hec.rss.plugins.opsupport.client.OpSupportTablePanel;
import hec.rss.plugins.opsupport.client.OpSupportTablePanel$OpSupportTable;
import hec.rss.plugins.opsupport.model.OpSupportActionsScripts;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import rma.swing.RmaGridBagConstraints;

public class OpSupportTabPanel
extends JPanel {
    private static final FluentLogger a = FluentLogger.forEnclosingClass();
    private OpSupportTabConfig _tabConfig;
    private int _editingMVIndex = -1;
    OpSupportTablePanel _tablePanel;
    OpSupportActionPanel _actionPanel;
    OpSupportPlotPanel _plotPanel;
    OpSupportTabbedPane _parent;
    private CountDownLatch _computeCountDownLatch;
    private boolean _computeRv;

    public OpSupportTabPanel(OpSupportTabbedPane opSupportTabbedPane) {
        this._parent = opSupportTabbedPane;
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOneTouchExpandable(true);
        JSplitPane jSplitPane2 = jSplitPane;
        jSplitPane2.setDividerSize(jSplitPane2.getDividerSize() + 3);
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(0.0);
        this._plotPanel = new OpSupportPlotPanel(this);
        this._plotPanel.setPreferredSize(new Dimension(400, 300));
        this._plotPanel.setPreferredSize(new Dimension(600, 350));
        jSplitPane.setTopComponent(this._plotPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._tablePanel = new OpSupportTablePanel(this);
        this._tablePanel.setPreferredSize(new Dimension(400, 350));
        jPanel.add((Component)this._tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this._actionPanel = new OpSupportActionPanel(this);
        this._actionPanel.setPreferredSize(new Dimension(200, 350));
        jPanel.add((Component)this._actionPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 18, 3, new Insets(5, 5, 5, 5), 0, 0));
        jSplitPane.setBottomComponent(jPanel);
        jSplitPane.setDividerLocation(300);
        this.add((Component)jSplitPane, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        this._tablePanel.getTable().getSelectionModel().addListSelectionListener(this._actionPanel);
        this._tablePanel.getTable().getColumnModel().getSelectionModel().addListSelectionListener(this._actionPanel);
    }

    public OpSupportMainPanel getMainPanel() {
        return this._parent.getMainPanel();
    }

    public void fillForm(OpSupportTabConfig opSupportTabConfig) {
        this._tabConfig = opSupportTabConfig;
        this.updateActionPanel();
        this._editingMVIndex = 0;
        if (this._tablePanel != null) {
            this._tablePanel.fillForm(opSupportTabConfig);
        }
        if (this._actionPanel != null) {
            this._actionPanel.fillForm(opSupportTabConfig);
        }
        if (this._plotPanel != null) {
            this._plotPanel.fillForm(opSupportTabConfig, 0);
        }
    }

    public boolean saveForm() {
        boolean bl;
        boolean bl2 = true;
        if (this._tablePanel != null && !(bl = this._tablePanel.saveForm())) {
            bl2 = false;
        }
        return bl2;
    }

    public OpSupportTabConfig getTabConfig() {
        return this._tabConfig;
    }

    public void refreshPlot() {
        if (this._plotPanel != null) {
            this._plotPanel.refreshData(true);
        }
    }

    public void refreshData() {
        if (this._tablePanel != null) {
            this._tablePanel.refreshData();
        }
        if (this._plotPanel != null) {
            this._plotPanel.refreshData();
        }
    }

    public OpSupportTablePanel getTablePanel() {
        return this._tablePanel;
    }

    public OpSupportPlotPanel getPlotPanel() {
        return this._plotPanel;
    }

    public void deleteCurrentVariable() {
        if (this._tablePanel == null || this._tabConfig == null) {
            return;
        }
        OpSupportModelVariable opSupportModelVariable = this._tablePanel.getSelectedModelVariable();
        if (opSupportModelVariable == null) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), "Delete Model Variable \"" + opSupportModelVariable.getName() + "\"?", "Delete Model Variable", 2);
        if (n == 0) {
            this._tabConfig.deleteModelVariable(opSupportModelVariable);
            OpSupportTabPanel opSupportTabPanel = this;
            opSupportTabPanel.fillForm(opSupportTabPanel._tabConfig);
        }
    }

    public OpSupportModelVariable getCurrentVariable() {
        OpSupportModelVariable opSupportModelVariable = this._tablePanel.getSelectedModelVariable();
        return opSupportModelVariable;
    }

    public void setDecimalPosition(int n) {
        if (this._tablePanel != null) {
            this._tablePanel.setDecimalPosition(n);
        }
    }

    public void setColWidth(int n) {
        if (this._tablePanel != null) {
            this._tablePanel.setColWidth(n);
        }
    }

    public void setSelectedRows(int[] nArray) {
        if (this._tablePanel != null) {
            this._tablePanel.setSelectedRows(nArray);
        }
    }

    public void interpolateToLine(int n, double[] dArray, double[] dArray2) {
        if (this._tablePanel != null) {
            this._tablePanel.interpolateToLine(n, dArray, dArray2);
        }
    }

    public boolean isTableEditing() {
        if (this._tablePanel == null) {
            return false;
        }
        return this._tablePanel.isTableEditing();
    }

    public void commitTableEdit(boolean bl) {
        if (this._tablePanel != null) {
            this._tablePanel.commitTableEdit(bl);
        }
    }

    public void updateModelVariableSelection(int n) {
        if (this._plotPanel != null && n != this._editingMVIndex) {
            this._editingMVIndex = n;
            this._plotPanel.fillForm(this._tabConfig, n);
            this.updateActionPanel();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateActionPanel() {
        OpSupportModelVariable opSupportModelVariable = this.getCurrentVariable();
        if (opSupportModelVariable == null) {
            OpSupportTabConfig opSupportTabConfig = this.getTabConfig();
            if (opSupportTabConfig.getModelVariableList() != null && opSupportTabConfig.getModelVariableList().size() > 0 && opSupportTabConfig.getModelVariable(0).getListHierarchy().size() > 0) {
                List<ActionOrScript> list = opSupportTabConfig.getModelVariable(0).getListHierarchy();
                this._actionPanel.buildControls(list, opSupportTabConfig.getActionsScripts().noActionsValue());
                return;
            }
            if (opSupportTabConfig.getListNoHierarchy() != null && opSupportTabConfig.getListHierarchy().size() > 0) {
                List<ActionOrScript> list = opSupportTabConfig.getListHierarchy();
                this._actionPanel.buildControls(list, opSupportTabConfig.getActionsScripts().noActionsValue());
                return;
            }
            OpSupportActionsScripts opSupportActionsScripts = new OpSupportActionsScripts(true);
            opSupportActionsScripts.initialize();
            this._actionPanel.buildControls(opSupportActionsScripts.getList(), opSupportTabConfig.getActionsScripts().noActionsValue());
            return;
        }
        List<ActionOrScript> list = opSupportModelVariable.getListHierarchy();
        if (list == null) {
            return;
        }
        if (list.size() > 0) {
            this._actionPanel.buildControls(list, opSupportModelVariable.getActionsScripts().noActionsValue());
            return;
        }
        OpSupportActionsScripts opSupportActionsScripts = new OpSupportActionsScripts(false);
        opSupportActionsScripts.initialize();
        this._actionPanel.buildControls(opSupportActionsScripts.getList(), opSupportModelVariable.getActionsScripts().noActionsValue());
    }

    public void runFollowupAction() {
        if (this._actionPanel != null) {
            this._actionPanel.runFollowupAction();
        }
    }

    public void calcLocalFollowup() {
        if (this._actionPanel != null) {
            this._actionPanel.calcLocalFollowup();
        }
    }

    public void modelVariableModified(OpSupportModelVariable opSupportModelVariable) {
        this._tablePanel.modelVariableModified(opSupportModelVariable);
        this._plotPanel.refreshData(true);
    }

    public OpSupportTablePanel$OpSupportTable getTable() {
        return this._tablePanel.getTable();
    }

    public OpSupportActionPanel getActionPanel() {
        return this._actionPanel;
    }

    public void calcLocal() {
        this._actionPanel.calcLocal();
    }

    public void calcWithObsTSData() {
        this._actionPanel.calcWithObsTSData();
    }

    public void computeMethod() {
        this._actionPanel.computeMethod();
    }

    public boolean computeAndWait() {
        this._computeCountDownLatch = new CountDownLatch(1);
        this._computeRv = false;
        OpSupportTabPanel$1 opSupportTabPanel$1 = new OpSupportTabPanel$1(this);
        this._actionPanel.computeMethod(opSupportTabPanel$1);
        try {
            this._computeCountDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            ((FluentLogger.Api)a.atInfo()).log("Compute Countdown latch interrupted. Compute RV might not be correct. Error: %s", (Object)interruptedException.getMessage());
        }
        return this._computeRv;
    }

    public void recessionMethod() {
        this._actionPanel.recessionMethod();
    }

    public void clearTimeSeriesAll() {
        this._actionPanel.clearTimeSeriesAll();
    }

    public void clearTimeSeriesBelow() {
        this._actionPanel.clearTimeSeriesBelow();
    }

    public void clearTimeSeriesSelected() {
        this._actionPanel.clearTimeSeriesSelected();
    }
}

