/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.client;

import hec.rss.model.Element;
import hec.rss.model.IndependentVariable;
import hec.rss.model.RssSystem;
import hec.rss.plugins.opsupport.client.OSModelVariableDlg;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$OVComputedPanel;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$OVDiversionPanel;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$OVElevTargetPanel;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$OVLocalFlowPanel;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$OVReleasePanel;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$OVSupportingTSPanel;
import hec.rss.plugins.opsupport.client.OpSupportVariableEditor$SymWindow;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.ClosableDialog;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJDialog;
import rma.swing.RmaJLabel;
import rma.swing.RmaJPanel;
import rma.swing.RmaJTextField;
import rma.swing.RmaNavigationPanel;
import rma.util.RMAIO;

public class OpSupportVariableEditor
extends RmaJDialog
implements ItemListener,
ButtonCmdPanelListener,
ClosableDialog {
    private JPanel _namePanel;
    private JLabel _nameLabel;
    private RmaJComboBox<String> _variableChoice;
    private RmaNavigationPanel _navPanel;
    private RmaJDescriptionField _descriptionTxt;
    private JPanel _contentPanel;
    private ButtonCmdPanel _cmdPanel;
    private OpSupportModelVariable _osmv;
    private OpSupportTabConfig _tabConfig;
    private RmaJComboBox<String> _typeChoice;
    private Frame _myFrame;
    private RmaJTextField _minTsTextfld;
    private RmaJTextField _maxTsTextfld;
    private RmaJTextField _offsetTextfld;
    private RmaJTextField _viewportTextfld;
    private RmaJComboBox<String> _elemTypeChoice;
    private RmaJComboBox<Element> _elemChoice;
    private RmaJPanel _typeContentPanel;
    private OpSupportVariableEditor$OVLocalFlowPanel _localFlowCardPanel;
    private OpSupportVariableEditor$OVReleasePanel _releaseCardPanel;
    private OpSupportVariableEditor$OVElevTargetPanel _elevTargetCardPanel;
    private OpSupportVariableEditor$OVComputedPanel _computedCardPanel;
    private OpSupportVariableEditor$OVDiversionPanel _divCardPanel;
    private RmaJPanel _blankCardPanel;
    private OpSupportVariableEditor$OVSupportingTSPanel _supportingTSPanel;
    private boolean _isCanceled;

    public OpSupportVariableEditor(Frame frame, boolean bl) {
        super(frame, bl);
        this._myFrame = frame;
        this.buildControls();
        OpSupportVariableEditor opSupportVariableEditor = this;
        opSupportVariableEditor.setLocationRelativeTo(opSupportVariableEditor.getParent());
    }

    private void buildControls() {
        this.setTitle("OSI Variable Editor");
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(480, 480);
        Object object = new Insets(0, 5, 5, 5);
        Serializable serializable = new Insets(0, 5, 0, 0);
        Insets insets = new Insets(0, 0, 5, 5);
        Object object2 = new Insets(5, 5, 0, 5);
        Insets insets2 = new Insets(5, 5, 5, 5);
        this._namePanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this._namePanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, insets2, 0, 0));
        this._nameLabel = new RmaJLabel("Name");
        this._nameLabel.setDisplayedMnemonic('N');
        this._namePanel.add((Component)this._nameLabel, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, (Insets)serializable, 0, 0));
        this._variableChoice = new RmaJComboBox();
        this._variableChoice.setModifiable(false);
        this._nameLabel.setLabelFor((Component)this._variableChoice);
        this._namePanel.add((Component)this._variableChoice, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)object2, 0, 0));
        this._navPanel = new RmaNavigationPanel();
        this._navPanel.fillForm(this._variableChoice);
        this._namePanel.add((Component)this._navPanel, new RmaGridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)object2, 0, 0));
        serializable = new JLabel("Description");
        ((JLabel)serializable).setDisplayedMnemonic('D');
        this._namePanel.add((Component)serializable, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, (Insets)object2, 0, 0));
        this._descriptionTxt = new RmaJDescriptionField();
        ((JLabel)serializable).setLabelFor((Component)this._descriptionTxt);
        this._descriptionTxt.setMargin(new Insets(0, 0, 0, 0));
        this._descriptionTxt.setLineWrap(true);
        this._descriptionTxt.setWrapStyleWord(true);
        this._namePanel.add((Component)this._descriptionTxt, new RmaGridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, (Insets)object2, 200, 0));
        this._contentPanel = new JPanel(new GridBagLayout());
        serializable = new RmaJLabel("Element Type:");
        this._contentPanel.add((Component)serializable, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)object, 0, 0));
        object2 = OpSupportModelVariable.ELEM_TYPE_STRARRAY;
        this._elemTypeChoice = new RmaJComboBox((Object[])object2);
        this._elemTypeChoice.setModifiable(false);
        serializable.setLabelFor((Component)this._elemTypeChoice);
        this._contentPanel.add((Component)this._elemTypeChoice, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)object, 0, 0));
        serializable = new RmaJLabel("Element:");
        this._contentPanel.add((Component)serializable, new RmaGridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._elemChoice = new RmaJComboBox();
        this._elemChoice.setModifiable(false);
        serializable.setLabelFor((Component)this._elemChoice);
        this._contentPanel.add((Component)this._elemChoice, new RmaGridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, (Insets)object, 0, 0));
        serializable = new RmaJLabel("Type:");
        this._contentPanel.add((Component)serializable, new RmaGridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, (Insets)object, 0, 0));
        object2 = OpSupportModelVariable.OPVAR_TYPE_STRARRAY;
        this._typeChoice = new RmaJComboBox((Object[])object2);
        this._typeChoice.setModifiable(false);
        serializable.setLabelFor((Component)this._typeChoice);
        this._contentPanel.add((Component)this._typeChoice, new RmaGridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._typeContentPanel = new RmaJPanel();
        this._typeContentPanel.setLayout((LayoutManager)new CardLayout());
        this._blankCardPanel = new RmaJPanel();
        this._typeContentPanel.add((Component)this._blankCardPanel, (Object)"blank");
        this._localFlowCardPanel = new OpSupportVariableEditor$OVLocalFlowPanel(this);
        this._typeContentPanel.add((Component)((Object)this._localFlowCardPanel), (Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[1]);
        this._releaseCardPanel = new OpSupportVariableEditor$OVReleasePanel(this);
        this._typeContentPanel.add((Component)((Object)this._releaseCardPanel), (Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[2]);
        this._elevTargetCardPanel = new OpSupportVariableEditor$OVElevTargetPanel(this);
        this._typeContentPanel.add((Component)((Object)this._elevTargetCardPanel), (Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[4]);
        this._computedCardPanel = new OpSupportVariableEditor$OVComputedPanel(this);
        this._typeContentPanel.add((Component)((Object)this._computedCardPanel), (Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[3]);
        this._divCardPanel = new OpSupportVariableEditor$OVDiversionPanel(this);
        this._typeContentPanel.add((Component)((Object)this._divCardPanel), (Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[6]);
        this._contentPanel.add((Component)this._typeContentPanel, new RmaGridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        serializable = new RmaJLabel("Min Target:");
        this._contentPanel.add((Component)serializable, new RmaGridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._minTsTextfld = new RmaJTextField();
        this._contentPanel.add((Component)this._minTsTextfld, new RmaGridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        serializable = new RmaJLabel("Max Target:");
        this._contentPanel.add((Component)serializable, new RmaGridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._maxTsTextfld = new RmaJTextField();
        this._contentPanel.add((Component)this._maxTsTextfld, new RmaGridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        serializable = new RmaJLabel("Time Shift:");
        this._contentPanel.add((Component)serializable, new RmaGridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._offsetTextfld = new RmaJTextField();
        this._contentPanel.add((Component)this._offsetTextfld, new RmaGridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        object2 = new JPanel(new GridBagLayout());
        serializable = new RmaJLabel("Viewport for Graphical Display:");
        ((Container)object2).add((Component)serializable, new RmaGridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)object, 0, 0));
        this._viewportTextfld = new RmaJTextField();
        ((Container)object2).add((Component)this._viewportTextfld, new RmaGridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this._contentPanel.add((Component)object2, new RmaGridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._supportingTSPanel = new OpSupportVariableEditor$OVSupportingTSPanel(this);
        this._contentPanel.add((Component)((Object)this._supportingTSPanel), new RmaGridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 18, 1, insets2, 0, 0));
        this.getContentPane().add((Component)this._contentPanel, new RmaGridBagConstraints(0, 1, 1, 1, 2.0, 2.0, 18, 1, insets2, 0, 0));
        this._cmdPanel = new ButtonCmdPanel(14);
        this.getContentPane().add((Component)this._cmdPanel, new RmaGridBagConstraints(0, 3, 1, 0, 1.0, 0.0, 15, 2, insets2, 0, 0));
        this.pack();
        object = new OpSupportVariableEditor$SymWindow(this);
        this.addWindowListener((WindowListener)object);
        this._elemTypeChoice.addItemListener((ItemListener)this);
        this._elemChoice.addItemListener((ItemListener)this);
        this._typeChoice.addItemListener((ItemListener)this);
        this._variableChoice.addItemListener((ItemListener)this);
        this._cmdPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
    }

    protected IndependentVariable editIndependentVariable(IndependentVariable independentVariable) {
        OSModelVariableDlg oSModelVariableDlg = new OSModelVariableDlg(this._myFrame, true, 3, "Operation Support Model Variable");
        oSModelVariableDlg.setNetwork(this._tabConfig.getOsConfig().getRssSystem());
        oSModelVariableDlg.setIndependentVariable(independentVariable);
        oSModelVariableDlg.setVisible(true);
        independentVariable = null;
        if (!oSModelVariableDlg.isCanceled()) {
            independentVariable = oSModelVariableDlg.getIndependentVariable();
        }
        return independentVariable;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this._isCanceled = false;
        }
        super.setVisible(bl);
    }

    public boolean isCanceled() {
        return this._isCanceled;
    }

    void dialogClosing(WindowEvent windowEvent) {
        this.handleCancelAction();
    }

    public boolean closeDialog() {
        this.setVisible(false);
        return true;
    }

    public void buttonCmdActionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getID() == 8) {
            this.handleOkAction();
            return;
        }
        if (actionEvent.getID() == 4) {
            this.handleCancelAction();
            return;
        }
        if (actionEvent.getID() == 2) {
            this.handleApplyAction();
        }
    }

    boolean handleApplyAction() {
        if (this.validateComponents()) {
            boolean bl = this.storeForm();
            return bl;
        }
        return false;
    }

    private boolean storeForm() {
        if (this._osmv == null) {
            this.setModified(false);
            return true;
        }
        this._osmv.setElementType(this._elemTypeChoice.getSelectedIndex());
        this._osmv.setElement((Element)this._elemChoice.getSelectedItem());
        String string = (String)this._typeChoice.getSelectedItem();
        int n = OpSupportModelVariable.getTypeIDbyName(string);
        this._osmv.setVarType(n);
        switch (n) {
            case 1: {
                this._localFlowCardPanel.storeForm(this._osmv);
                break;
            }
            case 2: {
                this._releaseCardPanel.storeForm(this._osmv);
                break;
            }
            case 4: {
                this._elevTargetCardPanel.storeForm(this._osmv);
                break;
            }
            case 3: {
                this._computedCardPanel.storeForm(this._osmv);
                break;
            }
            case 6: {
                this._divCardPanel.storeForm(this._osmv);
            }
        }
        this._supportingTSPanel.storeForm(this._osmv);
        try {
            this._osmv.setMaxLimit(Double.parseDouble(this._maxTsTextfld.getText()));
        }
        catch (Exception exception) {
            this._osmv.setMaxLimit(Double.NEGATIVE_INFINITY);
        }
        try {
            this._osmv.setMinLimit(Double.parseDouble(this._minTsTextfld.getText()));
        }
        catch (Exception exception) {
            this._osmv.setMinLimit(Double.NEGATIVE_INFINITY);
        }
        try {
            this._osmv.setTimeShift(Integer.parseInt(this._offsetTextfld.getText()));
        }
        catch (Exception exception) {
            this._osmv.setTimeShift(0);
        }
        try {
            this._osmv.setViewport(Integer.parseInt(this._viewportTextfld.getText()));
        }
        catch (Exception exception) {
            this._osmv.setViewport(0);
        }
        this.setModified(false);
        return true;
    }

    void handleOkAction() {
        if (this.handleApplyAction()) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
    }

    public void handleCancelAction() {
        this._isCanceled = true;
        if (this.isModified() && this.isVisible() && this._osmv != null) {
            OpSupportVariableEditor opSupportVariableEditor = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)opSupportVariableEditor), "Model Variable " + opSupportVariableEditor._osmv.getName() + " has changed.  Save Changes?", "Save Changes to Model Variable", 1);
            if (n == 0) {
                this._isCanceled = false;
                this.handleApplyAction();
            } else if (n != 1) {
                return;
            }
        }
        this.setVisible(false);
    }

    @Override
    public void itemStateChanged(ItemEvent object) {
        if ((object = ((EventObject)object).getSource()) == this._variableChoice) {
            this.variableChoiceStateChange();
            return;
        }
        if (object == this._elemTypeChoice) {
            this.elemTypeChoiceStateChange();
            return;
        }
        if (object == this._elemChoice) {
            this.elementChoiceStateChange();
            return;
        }
        if (object == this._typeChoice) {
            this.typeChoiceStateChange();
        }
    }

    private void elementChoiceStateChange() {
        if (this._typeChoice.getSelectedIndex() < 0) {
            return;
        }
        String string = this._typeChoice.getSelectedItem().toString();
        Element element = (Element)this._elemChoice.getSelectedItem();
        if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[1])) {
            this._localFlowCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[2])) {
            this._releaseCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[4])) {
            this._elevTargetCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[3])) {
            this._computedCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[6])) {
            this._divCardPanel.elemChoiceChanged(element);
        }
        this.setModified(true);
    }

    private void elemTypeChoiceStateChange() {
        if (this._tabConfig == null) {
            return;
        }
        int n = this._elemTypeChoice.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string = (String)this._elemTypeChoice.getSelectedItem();
        String string2 = OpSupportModelVariable.ELEM_TYPE_CLASSSTR[n];
        this.fillElementChoice(string2);
        this.fillTypeChoice(string);
        this._elemChoice.setSelectedIndex(-1);
        this._typeChoice.setSelectedIndex(-1);
        this.setModified(true);
    }

    private void typeChoiceStateChange() {
        if (this._tabConfig == null) {
            return;
        }
        String string = (String)this._typeChoice.getSelectedItem();
        if (string == null) {
            return;
        }
        Element element = (Element)this._elemChoice.getSelectedItem();
        if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[1])) {
            this._localFlowCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[2])) {
            this._releaseCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[4])) {
            this._elevTargetCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[3])) {
            this._computedCardPanel.elemChoiceChanged(element);
        } else if (string.equals(OpSupportModelVariable.OPVAR_TYPE_STRARRAY[6])) {
            this._divCardPanel.elemChoiceChanged(element);
        }
        ((CardLayout)this._typeContentPanel.getLayout()).show((Container)this._typeContentPanel, string);
        this.setModified(true);
    }

    private void fillElementChoice(String iterator) {
        RssSystem rssSystem = this._tabConfig.getOsConfig().getRssSystem();
        iterator = rssSystem.getElementVectorByClass((String)((Object)iterator));
        this._elemChoice.removeAllItems();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                rssSystem = (Element)iterator.next();
                this._elemChoice.addItem((Object)rssSystem);
            }
        }
    }

    private void fillTypeChoice(String string) {
        this._typeChoice.removeAllItems();
        int n = -1;
        switch (string.hashCode()) {
            case -173110412: {
                if (!string.equals("Junction")) break;
                n = 0;
                break;
            }
            case -268033969: {
                if (!string.equals("Reservoir")) break;
                n = 1;
                break;
            }
            case 310247571: {
                if (!string.equals("Diversion")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                this._typeChoice.addItem((Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[1]);
                break;
            }
            case 1: {
                this._typeChoice.addItem((Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[2]);
                this._typeChoice.addItem((Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[4]);
                break;
            }
            case 2: {
                this._typeChoice.addItem((Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[6]);
            }
        }
        this._typeChoice.addItem((Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[3]);
    }

    private void variableChoiceStateChange() {
        String string;
        if (this.isModified() && this.isVisible() && this._osmv != null) {
            OpSupportVariableEditor opSupportVariableEditor = this;
            int n = JOptionPane.showConfirmDialog((Component)((Object)opSupportVariableEditor), "Model Variable " + opSupportVariableEditor._osmv.getName() + " has changed.  Save Changes?", "Save Changes to Model Variable", 0);
            if (n == 0) {
                this.handleApplyAction();
            }
        }
        if ((string = this._variableChoice.getSelectedItem().toString()) == null) {
            return;
        }
        if (this._tabConfig == null) {
            return;
        }
        this._osmv = this._tabConfig.getModelVariable(string);
        this.clearForm();
        if (this._osmv != null) {
            OpSupportVariableEditor opSupportVariableEditor = this;
            opSupportVariableEditor.fillForm(opSupportVariableEditor._osmv);
        }
    }

    public void clearForm() {
        this._elemTypeChoice.removeItemListener((ItemListener)this);
        this._elemChoice.removeItemListener((ItemListener)this);
        this._typeChoice.removeItemListener((ItemListener)this);
        this._descriptionTxt.setText("");
        this._elemTypeChoice.setSelectedIndex(-1);
        this._elemChoice.removeAllItems();
        this._typeChoice.removeAllItems();
        this._localFlowCardPanel.clearForm();
        this._releaseCardPanel.clearForm();
        this._elevTargetCardPanel.clearForm();
        this._computedCardPanel.clearForm();
        this._divCardPanel.clearForm();
        ((CardLayout)this._typeContentPanel.getLayout()).show((Container)this._typeContentPanel, "blank");
        this._offsetTextfld.setText("");
        this._maxTsTextfld.setText("");
        this._minTsTextfld.setText("");
        this._elemTypeChoice.addItemListener((ItemListener)this);
        this._elemChoice.addItemListener((ItemListener)this);
        this._typeChoice.addItemListener((ItemListener)this);
    }

    public void fillForm(OpSupportModelVariable opSupportModelVariable) {
        this.clearForm();
        this._osmv = opSupportModelVariable;
        if (opSupportModelVariable == null) {
            this.setModified(false);
            return;
        }
        this._elemTypeChoice.removeItemListener((ItemListener)this);
        this._elemChoice.removeItemListener((ItemListener)this);
        this._typeChoice.removeItemListener((ItemListener)this);
        this._descriptionTxt.setText(opSupportModelVariable.getDescription());
        int n = opSupportModelVariable.getElementType();
        this._elemTypeChoice.setSelectedIndex(n);
        if (n < 0) {
            this._elemTypeChoice.addItemListener((ItemListener)this);
            this._elemChoice.addItemListener((ItemListener)this);
            this._typeChoice.addItemListener((ItemListener)this);
            this.setModified(false);
            return;
        }
        this.fillElementChoice(OpSupportModelVariable.ELEM_TYPE_CLASSSTR[n]);
        this.fillTypeChoice(OpSupportModelVariable.ELEM_TYPE_STRARRAY[n]);
        Element element = opSupportModelVariable.getElement();
        if (element != null) {
            this._elemChoice.setSelectedItem((Object)element);
            int n2 = opSupportModelVariable.getVarType();
            if (n2 >= 0) {
                this._typeChoice.setSelectedItem((Object)OpSupportModelVariable.OPVAR_TYPE_STRARRAY[n2]);
                this.typeChoiceStateChange();
            } else {
                this._typeChoice.setSelectedIndex(-1);
            }
            switch (n2) {
                case 1: {
                    this._localFlowCardPanel.fillForm(this._osmv);
                    break;
                }
                case 2: {
                    this._releaseCardPanel.fillForm(this._osmv);
                    break;
                }
                case 4: {
                    this._elevTargetCardPanel.fillForm(this._osmv);
                    break;
                }
                case 3: {
                    this._computedCardPanel.fillForm(this._osmv);
                    break;
                }
                case 6: {
                    this._divCardPanel.fillForm(this._osmv);
                }
            }
            this._supportingTSPanel.fillForm(this._osmv);
        } else {
            this._elemChoice.setSelectedIndex(-1);
            this._typeChoice.setSelectedIndex(-1);
        }
        this._minTsTextfld.setText(RMAIO.setPrecision2((double)this._osmv.getMinLimit(), (int)3));
        this._maxTsTextfld.setText(RMAIO.setPrecision2((double)this._osmv.getMaxLimit(), (int)3));
        this._offsetTextfld.setText(Integer.toString(this._osmv.getTimeShift()));
        this._viewportTextfld.setText(Integer.toString(this._osmv.getViewport()));
        this._elemTypeChoice.addItemListener((ItemListener)this);
        this._elemChoice.addItemListener((ItemListener)this);
        this._typeChoice.addItemListener((ItemListener)this);
        this.setModified(false);
    }

    public void setTabConfig(OpSupportTabConfig opSupportTabConfig) {
        this._tabConfig = opSupportTabConfig;
        this._variableChoice.removeItemListener((ItemListener)this);
        this._variableChoice.removeAllItems();
        if (this._tabConfig == null) {
            this.setTitle("OSI Variable Editor");
        } else {
            OpSupportVariableEditor opSupportVariableEditor = this;
            opSupportVariableEditor.setTitle("OSI Variable Editor - Tab: " + opSupportVariableEditor._tabConfig.getName());
            int n = this._tabConfig.getNumModelVariables();
            for (int i = 0; i < n; ++i) {
                OpSupportModelVariable opSupportModelVariable = this._tabConfig.getModelVariable(i);
                if (opSupportModelVariable == null) continue;
                this._variableChoice.addItem((Object)opSupportModelVariable.getName());
            }
        }
        this._variableChoice.addItemListener((ItemListener)this);
    }

    public void selectVariable(OpSupportModelVariable opSupportModelVariable) {
        if (this._tabConfig == null || this._tabConfig.getNumModelVariables() <= 0) {
            this.clearForm();
        }
        if (opSupportModelVariable == null) {
            opSupportModelVariable = this._tabConfig.getModelVariable(0);
        }
        this._variableChoice.setSelectedItem((Object)opSupportModelVariable.getName());
        this.fillForm(opSupportModelVariable);
    }

    public static void main(String[] object) {
        object = new OpSupportVariableEditor(null, false);
        object.setLocation(250, 250);
        ((OpSupportVariableEditor)object).setVisible(true);
    }

    public static void runProgram() {
    }
}

