/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordImpl;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.model.ModelVariable;
import hec.model.RunTimeWindow;
import hec.model.TSLocation;
import hec.model.TSRecord;
import hec.rss.model.DiversionElement;
import hec.rss.model.Element;
import hec.rss.model.GVDataSet;
import hec.rss.model.IndependentVariable;
import hec.rss.model.Junction;
import hec.rss.model.JunctionElement;
import hec.rss.model.ReleaseOverrides;
import hec.rss.model.ReservoirElement;
import hec.rss.model.RssAlt;
import hec.rss.model.RssModelVariableSet;
import hec.rss.model.RssNode;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSLocation;
import hec.rss.model.RssTSRecordImpl;
import hec.rss.model.StateVariable;
import hec.rss.model.Storage;
import hec.rss.model.globalvariable.AltTimeSeriesGlobalData;
import hec.rss.model.globalvariable.GlobalVariable;
import hec.rss.model.globalvariable.GlobalVariableData;
import hec.rss.model.globalvariable.GlobalVariableType;
import hec.rss.plugins.opsupport.model.OpSupportConfig;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import rma.lang.Modifiable;
import rma.lang.RmaMath;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class OSVariableTSRef
implements RssTSLocation,
Cloneable,
Modifiable {
    public static final int SIGNIFICANT_DIGITS = 100000000;
    private String a;
    private int b;
    private int c = 0;
    private int d = -1;
    private int e = -1;
    private int f = -1;
    private int g = -1;
    private int h = -1;
    private String i;
    private String j;
    private String k;
    private String l;
    private int m = 0;
    private transient boolean n;
    private transient TSRecord o;
    private transient doubleArrayContainer p;
    private transient ReleaseOverrides q;
    private transient Hashtable<Integer, Double> r;
    private transient Integer[] s = null;
    private transient double[] t = null;
    private transient OpSupportModelVariable u;
    private transient TSRecordProxy v;
    private transient double w = 1.0;
    private transient RssRun x;
    private transient OpSupportTabConfig y;

    public OSVariableTSRef() {
    }

    public OSVariableTSRef(OpSupportModelVariable opSupportModelVariable, String string, int n) {
        this.u = opSupportModelVariable;
        this.a = string;
        this.b = n;
    }

    public int getViewport() {
        return this.m;
    }

    public void setViewport(int n) {
        this.m = n;
    }

    public OpSupportConfig getOSConfig() {
        return this.u.getOSConfig();
    }

    public OSVariableTSRef clone() {
        try {
            OSVariableTSRef oSVariableTSRef = (OSVariableTSRef)super.clone();
            ((OSVariableTSRef)super.clone()).a = new String(this.a);
            oSVariableTSRef.c = this.c;
            oSVariableTSRef.d = this.d;
            oSVariableTSRef.e = this.e;
            oSVariableTSRef.f = this.f;
            oSVariableTSRef.g = this.g;
            oSVariableTSRef.h = this.h;
            if (this.i != null) {
                oSVariableTSRef.i = new String(this.i);
            }
            if (this.j != null) {
                oSVariableTSRef.j = new String(this.j);
            }
            if (this.k != null) {
                oSVariableTSRef.k = new String(this.k);
            }
            if (this.l != null) {
                oSVariableTSRef.l = new String(this.l);
            }
            return oSVariableTSRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("OpSupportTabConfig.clone: Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    public void clearData() {
        this.d = -1;
        this.e = -1;
        this.f = -1;
        this.g = -1;
        this.h = -1;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
    }

    public void setTSDataType(int n) {
        this.c = n;
    }

    public int getTSDataType() {
        return this.c;
    }

    public void setByIndependentVariable(IndependentVariable independentVariable) {
        if (independentVariable == null) {
            return;
        }
        this.d = independentVariable.getType();
        this.e = independentVariable.getElementId();
        this.f = independentVariable.getModelVariableId();
        this.g = independentVariable.getStateVariableId();
        this.h = independentVariable.getGlobalVariableId();
        this.i = independentVariable.getTSProxyName();
        this.j = independentVariable.getTimeSeriesName();
        this.k = independentVariable.getStateVariableName();
        this.l = independentVariable.getGlobalVariableName();
    }

    public String getName() {
        return this.a;
    }

    public void setName(String string) {
        this.a = string;
    }

    public int getTSType() {
        return this.b;
    }

    public void setTSType(int n) {
        this.b = n;
    }

    public int getTypeID() {
        return this.d;
    }

    public void setTypeID(int n) {
        this.d = n;
    }

    public int[] getHECMinutes() {
        if (this.s == null) {
            return null;
        }
        int[] nArray = new int[this.s.length];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.s[i];
        }
        return nArray;
    }

    public int getElementID() {
        return this.e;
    }

    public void setElementID(int n) {
        this.e = n;
    }

    public int getModelVariableID() {
        return this.f;
    }

    public void setModelVariableID(int n) {
        this.f = n;
    }

    public int getStateVariableID() {
        return this.g;
    }

    public void setStateVariableID(int n) {
        this.g = n;
    }

    public int getGlobalVariableID() {
        return this.h;
    }

    public void setGlobalVariableID(int n) {
        this.h = n;
    }

    public String getProxyName() {
        return this.i;
    }

    public void setProxyName(String string) {
        this.i = string;
    }

    public String getTimeSeriesName() {
        return this.j;
    }

    public void setTimeSeriesName(String string) {
        this.j = string;
    }

    public String getStateVariableName() {
        return this.k;
    }

    public void setStateVariableName(String string) {
        this.k = string;
    }

    public String getGlobalVariableName() {
        return this.l;
    }

    public void setGlobalVariableName(String string) {
        this.l = string;
    }

    public void read(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.length() == 0) {
                string = bufferedReader.readLine();
                continue;
            }
            String string2 = RMAIO.getType((String)string, (String)":");
            string = RMAIO.getParam((String)string, (String)":");
            if (string2.equals("OSVariableTSRefEnd")) {
                return;
            }
            if (string2.equals("VarType") || string2.equals("TSType")) {
                this.b = RMAIO.parseInt((String)string);
            } else if (string2.equals("TSDataTypeID")) {
                this.c = RMAIO.parseInt((String)string);
            } else if (string2.equals("TypeID")) {
                this.d = RMAIO.parseInt((String)string);
            } else if (string2.equals("ElementID")) {
                this.e = RMAIO.parseInt((String)string);
            } else if (string2.equals("ModelVariableID")) {
                this.f = RMAIO.parseInt((String)string);
            } else if (string2.equals("StateVariableID")) {
                this.g = RMAIO.parseInt((String)string);
            } else if (string2.equals("GlobalVariableID")) {
                this.h = RMAIO.parseInt((String)string);
            } else if (string2.equals("ProxyName")) {
                this.i = string;
            } else if (string2.equals("TSName")) {
                this.j = string;
            } else if (string2.equals("SVName")) {
                this.k = string;
            } else if (string2.equals("GVName")) {
                this.l = string;
            } else if (string2.equals("ViewportIndex")) {
                this.m = Integer.parseInt(string);
            }
            string = bufferedReader.readLine();
        }
        this.setModified(false);
    }

    public void write(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TSType:" + Integer.toString(this.b)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TSDataTypeID:" + Integer.toString(this.c)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TypeID:" + Integer.toString(this.d)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ElementID:" + Integer.toString(this.e)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ModelVariableID:" + Integer.toString(this.f)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("StateVariableID:" + Integer.toString(this.g)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("GlobalVariableID:" + Integer.toString(this.h)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ProxyName:" + this.i));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("TSName:" + this.j));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("SVName:" + this.k));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("GVName:" + this.l));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ViewportIndex:" + Integer.toString(this.m)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSVariableTSRefEnd:" + this.getName()));
        this.setModified(false);
    }

    public boolean isModified() {
        return this.n;
    }

    public void setModified(boolean bl) {
        this.n = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initCompute(RssRun object, OpSupportTabConfig opSupportTabConfig, int n) {
        Object object2;
        block32: {
            String[] stringArray;
            Object object3;
            RssSystem rssSystem;
            block31: {
                Object object4;
                block25: {
                    block30: {
                        int n2;
                        block26: {
                            block27: {
                                block29: {
                                    block28: {
                                        if (object == null) {
                                            return;
                                        }
                                        rssSystem = object.getAlternative().getSystem();
                                        this.x = object;
                                        this.y = opSupportTabConfig;
                                        if (rssSystem == null) {
                                            return;
                                        }
                                        object2 = this.u.getElement();
                                        if (object2 == null) {
                                            return;
                                        }
                                        n2 = this.u.getVarType();
                                        this.c = n;
                                        if (this.b == 5) {
                                            this.initComp((RssRun)object, opSupportTabConfig, n, rssSystem);
                                            return;
                                        }
                                        if (n2 == 1) {
                                            if (!(object2 instanceof JunctionElement)) {
                                                return;
                                            }
                                            JunctionElement junctionElement = (JunctionElement)object2;
                                            if (this.b == 0) {
                                                object2 = junctionElement.getDownstreamNode().getTSRecordProxy(0);
                                                this.initTSProxy(opSupportTabConfig, rssSystem, (TSRecordProxy)object2, this.c);
                                                return;
                                            }
                                            if (this.b != 1 && this.b != 6) {
                                                if (this.b != 2) return;
                                                object2 = junctionElement.getFunction().getTSRecordProxy(65);
                                                this.initTSProxy(opSupportTabConfig, rssSystem, (TSRecordProxy)object2, this.c);
                                                return;
                                            }
                                            object2 = this.u.getLocalFlowName();
                                            Vector vector = junctionElement.getNodeVector();
                                            Iterator iterator = vector.iterator();
                                            while (true) {
                                                if (!iterator.hasNext()) {
                                                    this.w = ((Junction)junctionElement.getFunction()).getTotalLocalFlowFactor((String)object2);
                                                    return;
                                                }
                                                object = (RssNode)iterator.next();
                                                TSRecordProxy tSRecordProxy = object.getTSRecordProxy(4);
                                                if (tSRecordProxy == null || !tSRecordProxy.getName().equalsIgnoreCase((String)object2)) continue;
                                                this.initTSProxy(opSupportTabConfig, rssSystem, tSRecordProxy, this.c);
                                            }
                                        }
                                        if (n2 != 2 && n2 != 6) break block26;
                                        if (!(object2 instanceof ReservoirElement)) break block27;
                                        ReservoirElement cfr_ignored_0 = (ReservoirElement)object2;
                                        this.q = object.getReleaseOverrides();
                                        this.q.setRun((RssRun)object);
                                        String string = this.u.getReleaseName();
                                        if (string == null) return;
                                        if (string.length() <= 0) {
                                            return;
                                        }
                                        object3 = string;
                                        object2 = object;
                                        stringArray = this;
                                        if (object2 != null && object2.getAlternative().getSystem() != null) break block28;
                                        object4 = object3;
                                        break block25;
                                    }
                                    if (object3 != null) break block29;
                                    object4 = null;
                                    break block25;
                                }
                                object2 = object2.getAlternative().getSystem();
                                stringArray = stringArray.q;
                                stringArray = stringArray.getReleaseNames();
                                break block30;
                            }
                            if (!(object2 instanceof DiversionElement)) return;
                            object3 = (DiversionElement)object2;
                            this.q = object.getDiversionOverrides();
                            this.q.setRun((RssRun)object);
                            stringArray = this.getSystem().getKeyStringForObject((Object)object3.getControlElement().getElement().getDownstreamNode());
                            object2 = rssSystem.getObjectForKeyString((String)stringArray);
                            break block31;
                        }
                        if (n2 == 4) {
                            if (!(object2 instanceof ReservoirElement)) {
                                return;
                            }
                            ReservoirElement reservoirElement = (ReservoirElement)object2;
                            this.q = object.getElevationOverrides();
                            this.q.setRun((RssRun)object);
                            ReservoirElement reservoirElement2 = reservoirElement;
                            object2 = reservoirElement2.getKeyStringForObject((Object)reservoirElement2.getStorageFunction());
                            Storage storage = reservoirElement.getStorageFunction();
                            if (this.b == 0) return;
                            if (this.b != 3 && this.b != 6) {
                                if (this.b != 2) return;
                                if (!(storage instanceof Storage)) return;
                                TSRecordProxy tSRecordProxy = storage.getTSRecordProxy(10);
                                this.initTSProxy(opSupportTabConfig, rssSystem, tSRecordProxy, this.c);
                                return;
                            }
                            this.r = this.q.getReleaseValues((String)object2);
                            if (this.r == null) {
                                this.r = new Hashtable();
                                this.q.setReleaseValues((String)object2, this.r);
                            }
                            break block32;
                        } else {
                            if (n2 != 3) return;
                            if (this.b == 0) {
                                this.initComp((RssRun)object, opSupportTabConfig, n, rssSystem);
                                return;
                            }
                            if (this.b != 2) return;
                            this.initComp((RssRun)object, opSupportTabConfig, n, rssSystem);
                            return;
                        }
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!((String)object3).equals(object2.getNameForKeyString(stringArray[i]))) continue;
                        object4 = stringArray[i];
                        break block25;
                    }
                    object4 = object3;
                }
                stringArray = object4;
                object2 = rssSystem.getObjectForKeyString((String)stringArray);
            }
            if (this.b == 0) return;
            if (this.b == 3 || this.b == 6) {
                this.r = this.q.getReleaseValues((String)stringArray);
                if (this.r == null) {
                    this.r = new Hashtable();
                    this.q.setReleaseValues((String)stringArray, this.r);
                }
            } else {
                if (this.b != 2) return;
                if (object2 instanceof Storage) {
                    object3 = ((Storage)object2).getTSRecordProxy(21);
                    this.initTSProxy(opSupportTabConfig, rssSystem, (TSRecordProxy)object3, this.c);
                    return;
                }
                if (object2 instanceof Element) {
                    object3 = object2.getDownstreamNode().getTSRecordProxy(0);
                    this.initTSProxy(opSupportTabConfig, rssSystem, (TSRecordProxy)object3, this.c);
                    return;
                }
                if (!(object2 instanceof RssNode)) return;
                object3 = ((RssNode)object2).getTSRecordProxy(0);
                this.initTSProxy(opSupportTabConfig, rssSystem, (TSRecordProxy)object3, this.c);
                return;
            }
            object3 = object.getRunTimeWindow();
            HecTime hecTime = object3.getLookbackTime();
            int n3 = object3.getTimeStepMinutes();
            int n4 = hecTime.value();
            int n5 = object3.getNumSteps();
            this.s = new Integer[n5 + 1];
            this.t = this.getOSConfig().getOverrideArray("rel-" + (String)stringArray, n5 + 1);
            int n6 = 0;
            while (n6 <= n5) {
                rssSystem = new HecTime(1);
                rssSystem.set(n4);
                this.s[n6] = rssSystem.value();
                n4 += n3;
                object2 = this.s[n6];
                object2 = this.r.get(object2);
                this.t[n6] = object2 == null ? -901.0 : (Double)object2;
                ++n6;
            }
            return;
        }
        RunTimeWindow runTimeWindow = object.getRunTimeWindow();
        object = runTimeWindow.getLookbackTime();
        int n7 = runTimeWindow.getTimeStepMinutes();
        int n8 = object.value();
        int n9 = runTimeWindow.getNumSteps();
        this.s = new Integer[n9 + 1];
        this.t = this.getOSConfig().getOverrideArray("elev-" + (String)object2, n9 + 1);
        int n10 = 0;
        while (n10 <= n9) {
            object2 = new HecTime(1);
            object2.set(n8);
            this.s[n10] = object2.value();
            n8 += n7;
            object2 = this.s[n10];
            object = this.r.get(object2);
            this.t[n10] = object == null ? -901.0 : (Double)object;
            ++n10;
        }
    }

    public void initTSProxy(OpSupportTabConfig object, RssSystem rssSystem, TSRecordProxy tSRecordProxy, int n) {
        if (tSRecordProxy == null) {
            rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to find TSRecordProxy");
            return;
        }
        this.o = ((OpSupportTabConfig)object).getOsConfig().loadTSProxy(tSRecordProxy, n);
        if (this.o == null) {
            object = rssSystem.getNameForKeyString(tSRecordProxy.getName());
            String string = this.getName();
            int n2 = tSRecordProxy.getVariableId();
            int n3 = n;
            rssSystem.printWarningMessage("OpSupportModelVariable.initializeCompute(" + string + "): failed to load TSRecordProxy. Name: " + (String)object + ", Varid: " + n2 + ", DataType: " + (switch (n3) {
                case 0 -> "Input TS Data";
                case 1 -> "Output TS Data";
                case 2 -> "Observed TS Data";
                default -> "Unknown TS Data";
            }) + ". To calculate Local Inflow in the OSI, the " + (String)object + " location's observed data must be turned on.");
            return;
        }
        if (this.b == 6 && this.o instanceof RssTSRecordImpl) {
            this.o = OSVariableTSRef.a((RssTSRecordImpl)this.o);
        }
        this.p = this.o.getTSContainer();
        if (this.p == null) {
            rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to find Model Variable Time Series data for " + rssSystem.getNameForKeyString(tSRecordProxy.getName()));
            return;
        }
    }

    private static RssTSRecordImpl a(RssTSRecordImpl rssTSRecordImpl) {
        if (rssTSRecordImpl == null) {
            return null;
        }
        RssTSRecordImpl rssTSRecordImpl2 = new RssTSRecordImpl((TSRecordImpl)rssTSRecordImpl);
        rssTSRecordImpl.copyInto(rssTSRecordImpl2);
        return rssTSRecordImpl2;
    }

    public void initComp(RssRun object, OpSupportTabConfig opSupportTabConfig, int n, RssSystem rssSystem) {
        this.c = n;
        switch (this.d) {
            case 2: {
                object = rssSystem.getTSRecordProxy(this.i, this.f);
                if (object == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to find TSRecordProxy");
                    return;
                }
                if (object.isInput()) {
                    this.c = 0;
                }
                this.o = opSupportTabConfig.getOsConfig().loadTSProxy((TSRecordProxy)object, this.c);
                if (this.o == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to load TSRecordProxy");
                    return;
                }
                if (this.b == 6 && this.o instanceof RssTSRecordImpl) {
                    this.o = OSVariableTSRef.a((RssTSRecordImpl)this.o);
                }
                this.p = this.o.getTSContainer();
                if (this.p != null) break;
                rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to find Model Variable Time Series");
                return;
            }
            case 3: {
                this.c = 0;
                object = this.j;
                if (object == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") external time series name is null");
                    return;
                }
                if ((object = rssSystem.getTSRecordProxy((String)object, 85)) == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to find TSRecordProxy");
                    return;
                }
                this.o = opSupportTabConfig.getOsConfig().loadTSProxy((TSRecordProxy)object, this.c);
                if (this.o == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute(" + this.getName() + "): failed to load TSRecordProxy");
                    return;
                }
                if (this.o.getParamName() == null || this.o.getParamName().length() <= 0) {
                    object = new DSSPathname(this.o.getDSSPathname());
                    this.o.setParamName(object.cPart());
                }
                this.p = this.o.getTSContainer();
                if (this.p != null) break;
                rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") failed to find Time Series");
                return;
            }
            case 4: {
                int n2 = this.g;
                StateVariable stateVariable = rssSystem.getStateVariable(n2);
                if (stateVariable == null) {
                    stateVariable = rssSystem.getStateVariable(this.k);
                }
                if (stateVariable == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") failed to find State Variable => " + this.k);
                    return;
                }
                stateVariable = stateVariable.getTSRecordProxy(97);
                this.o = opSupportTabConfig.getOsConfig().loadTSProxy((TSRecordProxy)stateVariable, this.c);
                this.p = this.o.getTSContainer();
                if (this.p != null) break;
                rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") failed to find State Variable Time Series");
                return;
            }
            case 6: {
                int n3 = this.h;
                GVDataSet gVDataSet = object.getInputGVData();
                if (gVDataSet == null) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") failed to find Global Variable Data Set");
                    return;
                }
                GlobalVariableData globalVariableData = gVDataSet.getGlobalVariableData(n3, GlobalVariableType.TIME_SERIES);
                if (globalVariableData == null) {
                    globalVariableData = gVDataSet.getGlobalVariableData(this.l, GlobalVariableType.TIME_SERIES);
                }
                if (!(globalVariableData instanceof AltTimeSeriesGlobalData)) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") failed to find Time Series Global Variable => " + this.l);
                    return;
                }
                gVDataSet = (globalVariableData = (AltTimeSeriesGlobalData)globalVariableData).getTimeSeriesContainer();
                if (gVDataSet == null || gVDataSet.numberValues == 0) {
                    object = object.getRunTimeWindow();
                    globalVariableData.loadTSData(object.getLookbackTime(), object.getEndTime());
                }
                if ((gVDataSet = globalVariableData.getTimeSeriesContainer()) != null && gVDataSet.numberValues > 0) {
                    this.p = new doubleArrayContainer(gVDataSet.values);
                }
                if (this.p == null || this.p.length == 0) {
                    rssSystem.printErrorMessage("OpSupportModelVariable.initializeCompute:(" + this.getName() + ") failed to find Global Variable Time Series");
                    return;
                }
                this.o = globalVariableData;
            }
        }
    }

    public double getValue(int n) {
        if (n < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.b == 3) {
            if (this.t != null && this.t.length > n) {
                return this.t[n];
            }
            if (this.q == null || this.r == null) {
                return -901.0;
            }
            Number number = this.s[n];
            if ((number = this.r.get(number)) == null) {
                return -901.0;
            }
            return (Double)number;
        }
        if (this.p == null || this.p.array == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.p.array.length <= n) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.p.array[n];
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            return;
        }
        if (this.b == 3) {
            if (this.t != null && this.t.length > n) {
                this.t[n] = d;
            }
            if (this.q == null || this.r == null) {
                return;
            }
            Integer n2 = this.s[n];
            this.r.put(n2, d);
            return;
        }
        if (this.p == null || this.p.array == null) {
            return;
        }
        if (this.p.array.length <= n) {
            return;
        }
        this.p.array[n] = d;
    }

    public boolean saveData() {
        boolean bl = true;
        if (this.b == 3) {
            if (this.q == null || this.r == null || this.t == null) {
                return false;
            }
            int n = this.t.length;
            for (int i = 0; i < n; ++i) {
                if (!RMAConst.isValidValue((double)this.t[i])) continue;
                Integer n2 = this.s[i];
                this.r.put(n2, this.t[i]);
            }
        } else if (this.o != null) {
            bl = this.o.writeTSData();
        }
        return bl;
    }

    public void refreshData() {
        OSVariableTSRef oSVariableTSRef = this;
        oSVariableTSRef.initCompute(oSVariableTSRef.x, this.y, this.c);
        if (this.o != null) {
            this.o.loadTSData(this.x.getRunTimeWindow().getLookbackTime(), this.x.getRunTimeWindow().getEndTime());
            if (this.b == 6 && this.o instanceof RssTSRecordImpl) {
                this.o = OSVariableTSRef.a((RssTSRecordImpl)this.o);
            }
            this.p = this.o.getTSContainer();
        }
    }

    public TSRecord getTSRecord() {
        return this.o;
    }

    public String getTSTextName(RssSystem rssSystem) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.d;
        if (n == 3) {
            stringBuffer.append(this.j);
        } else if (n == 2) {
            String string = "";
            if (rssSystem != null) {
                string = rssSystem.getNameForKeyString(this.i);
            }
            stringBuffer.append(string);
            stringBuffer.append(" " + RssModelVariableSet.getModelVariable((int)this.f).getName());
        } else if (4 == n) {
            StateVariable stateVariable = null;
            if (rssSystem != null) {
                stateVariable = rssSystem.getStateVariable(this.g);
            }
            if (stateVariable != null) {
                stringBuffer.append(stateVariable.getName());
            } else {
                stringBuffer.append(this.k);
            }
        } else {
            GlobalVariable globalVariable = null;
            if (rssSystem != null) {
                globalVariable = rssSystem.getGlobalVariable(this.h);
            }
            if (globalVariable != null) {
                stringBuffer.append(globalVariable.getName());
            } else {
                stringBuffer.append(this.l);
            }
        }
        return stringBuffer.toString();
    }

    public IndependentVariable getAsIndependentVariable(RssSystem rssSystem) {
        IndependentVariable independentVariable = new IndependentVariable(this.d);
        switch (this.d) {
            case 2: {
                TSRecordProxy tSRecordProxy = rssSystem.getTSRecordProxy(this.i, this.f);
                rssSystem = rssSystem.findElement(this.e);
                ModelVariable modelVariable = RssModelVariableSet.getModelVariable((int)this.f);
                independentVariable.setModalVariableInfo(tSRecordProxy, (Element)rssSystem, modelVariable);
                break;
            }
            case 3: {
                independentVariable.setTimeSeriesName(this.j);
                break;
            }
            case 4: {
                rssSystem = rssSystem.getStateVariable(this.g);
                independentVariable.setStateVariable((StateVariable)rssSystem);
                break;
            }
            case 6: {
                rssSystem = rssSystem.getGlobalVariable(this.h);
                independentVariable.setGlobalVariable((GlobalVariable)rssSystem);
            }
        }
        return independentVariable;
    }

    public void computeRecession(int n, double d, int n2, int n3, double d2) {
        int n4;
        if (this.p == null || this.p.array == null || this.p.array.length < n - 1) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        double d3 = this.p.array[n];
        int n5 = this.p.array.length;
        double d4 = (double)n3 / 1440.0;
        double d5 = 0.0;
        if (n2 == 1) {
            d5 = d;
        } else if (d > 0.0) {
            d5 = -Math.log(1.0 / d);
        }
        if (RMAConst.isValidValue((double)d2) && d4 > 0.0) {
            int n6 = (int)Math.ceil(d2 / d4);
            n5 = Math.min(this.p.array.length, n + n6);
        }
        if (n < 0) {
            n = 0;
        }
        for (n4 = n + 1; n4 < n5; ++n4) {
            this.p.array[n4] = d3 * Math.exp(-d5 * (double)(n4 - n) * d4);
        }
        for (n4 = n5; n4 < this.p.array.length; ++n4) {
            this.p.array[n4] = this.p.array[n5 - 1];
        }
    }

    public void setToObs(int n, OSVariableTSRef oSVariableTSRef) {
        if (oSVariableTSRef == null || oSVariableTSRef.getTSRecord() == null) {
            return;
        }
        if (this.p == null || this.p.array == null || this.p.array.length < n - 1) {
            return;
        }
        int n2 = this.p.array.length;
        if (n >= 0 && n < n2) {
            n2 = n + 1;
        }
        for (n = 0; n < n2; ++n) {
            double d = oSVariableTSRef.getValue(n);
            if (!RMAConst.isValidValue((double)d)) continue;
            this.p.array[n] = d;
        }
    }

    public void calcLocal(int n, OSVariableTSRef oSVariableTSRef, OSVariableTSRef oSVariableTSRef2) {
        if (oSVariableTSRef == null || oSVariableTSRef.getTSRecord() == null) {
            return;
        }
        if (oSVariableTSRef2 == null || oSVariableTSRef2.getTSRecord() == null) {
            return;
        }
        if (this.p == null || this.p.array == null || this.p.array.length < n - 1) {
            return;
        }
        int n2 = this.p.array.length;
        if (n >= 0 && n < n2) {
            n2 = n + 1;
        }
        for (n = 0; n < n2; ++n) {
            double d = oSVariableTSRef.getValue(n);
            double d2 = oSVariableTSRef2.getValue(n);
            if (!RMAConst.isValidValue((double)d) || !RMAConst.isValidValue((double)d2)) continue;
            int n3 = n;
            this.p.array[n3] = this.p.array[n3] + (d - d2) / this.w;
        }
    }

    public void clearTimeSeries(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (this.b == 3) {
            if (this.q == null || this.r == null) {
                return;
            }
            int n3 = this.s.length;
            if (n2 >= 0 && n2 < n3) {
                n3 = n2;
            }
            while (n < n3) {
                Integer n4 = this.s[n];
                this.r.remove(n4);
                if (this.t != null) {
                    this.t[n] = -901.0;
                }
                ++n;
            }
            return;
        }
        if (this.p == null || this.p.array == null || this.p.array.length < n - 1) {
            return;
        }
        int n5 = this.p.array.length;
        if (n2 >= 0 && n2 < n5) {
            n5 = n2;
        }
        while (n < n5) {
            this.p.array[n] = 0.0;
            ++n;
        }
    }

    public double[] getOvrdValues() {
        return this.t;
    }

    public boolean isLargest(double d) {
        OpSupportConfig opSupportConfig;
        int n;
        if (this.b == 3) {
            if (this.t == null) {
                return false;
            }
            n = this.t.length - 1;
        } else {
            if (this.p == null) {
                return false;
            }
            n = this.p.array.length - 1;
        }
        int n2 = 100000000;
        if (this.y != null && (opSupportConfig = this.y.getOsConfig()) != null) {
            n2 = opSupportConfig.getDecimalPrecision();
        }
        d = RmaMath.roundToSignificantDigits((double)d, (int)n2);
        for (int i = 0; i < n; ++i) {
            if (!RMAConst.isValidValue((double)this.getValue(i)) || !(d < RmaMath.roundToSignificantDigits((double)this.getValue(i), (int)n2))) continue;
            return false;
        }
        return true;
    }

    public boolean isSmallest(double d) {
        OpSupportConfig opSupportConfig;
        int n;
        if (this.b == 3) {
            if (this.t == null) {
                return false;
            }
            n = this.t.length - 1;
        } else {
            if (this.p == null) {
                return false;
            }
            n = this.p.array.length - 1;
        }
        int n2 = 100000000;
        if (this.y != null && (opSupportConfig = this.y.getOsConfig()) != null) {
            n2 = opSupportConfig.getDecimalPrecision();
        }
        d = RmaMath.roundToSignificantDigits((double)d, (int)n2);
        for (int i = 0; i < n; ++i) {
            if (!RMAConst.isValidValue((double)this.getValue(i)) || !(d > RmaMath.roundToSignificantDigits((double)this.getValue(i), (int)n2))) continue;
            return false;
        }
        return true;
    }

    public RssSystem getSystem() {
        if (this.y == null) {
            return null;
        }
        return this.y.getOsConfig().getRssSystem();
    }

    public Vector getActiveTSProxies(Vector vector, int n, RssAlt rssAlt) {
        if (rssAlt == null) {
            return vector;
        }
        if ((rssAlt = rssAlt.getSystem()) == null) {
            return vector;
        }
        if (vector == null) {
            vector = new Vector<TSRecordProxy>();
        }
        if (n == 1 && this.d == 3 && this.j != null) {
            if (this.v == null) {
                this.v = RssModelVariableSet.newTSRecordProxy((RssSystem)rssAlt, (TSLocation)this, (int)85);
                if (this.v != null) {
                    this.v.setName(this.j);
                }
            }
            if (this.v != null) {
                vector.addElement(this.v);
            }
        }
        return vector;
    }

    public TSDataSet getTSDataSet(boolean bl) {
        RssSystem rssSystem = this.getSystem();
        if (rssSystem == null) {
            return null;
        }
        if (bl) {
            return rssSystem.getInputTSDataSet();
        }
        return rssSystem.getOutputTSDataSet();
    }

    public TSRecordProxy getTSRecordProxy(int n) {
        if (n == 85) {
            return this.v;
        }
        return null;
    }
}

