/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.model;

import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.rss.plugins.opsupport.client.ActionOrScript;
import hec.rss.plugins.opsupport.client.OpSupportActionPanel;
import hec.rss.plugins.opsupport.model.AbstractType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import rma.util.RMAIO;

public class OpSupportActionsScripts {
    public static final String ACTIONS_BEGIN = "ActionsBegin";
    public static final String ACTIONS_END = "ActionsEnd";
    public static final String ACTION_NAME = "Action Name";
    public static final String SCRIPT_PATH = "Script Path";
    private List<ActionOrScript> a;
    private boolean b;
    private boolean c;

    public OpSupportActionsScripts(boolean bl) {
        this.c = bl;
        this.a = new ArrayList<ActionOrScript>();
        this.b = false;
    }

    public void initialize() {
        if (this.c) {
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Compute", "Compute"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Calculate All Locals", "calcWithObsTSData"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Calculate Selected Locals", "CalcLocal"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Hydrograph Recession", "Recession"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Clear Selection", "ClearTimeSeriesSelected"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Clear Below", "ClearTimeSeriesBelow"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Clear Variable", "ClearTimeSeriesVariable"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Clear All", "ClearTimeSeriesAll"));
            this.a.add(new ActionOrScript(AbstractType.ACTION, "Refresh Plot", "RefreshPlot"));
        }
    }

    public void resetList() {
        this.a.clear();
        this.initialize();
    }

    public void clearList() {
        this.a.clear();
    }

    public boolean noActionsValue() {
        return this.b;
    }

    public void setNoActionsValue(boolean bl) {
        this.b = bl;
    }

    public List<ActionOrScript> getList() {
        return this.a;
    }

    public void setList(List<ActionOrScript> list) {
        this.a.clear();
        if (list != null) {
            this.a.addAll(list);
        }
    }

    public void removeObject(ActionOrScript actionOrScript) {
        Iterator<ActionOrScript> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            ActionOrScript actionOrScript2 = iterator.next();
            if (!actionOrScript2.getValue().equals(actionOrScript.getValue())) continue;
            iterator.remove();
        }
    }

    public void addObject(ActionOrScript actionOrScript) {
        this.a.add(actionOrScript);
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public void moveObjectInList(ActionOrScript actionOrScript, boolean n) {
        block3: {
            if (n != 0) {
                for (n = 1; n < this.a.size(); ++n) {
                    ActionOrScript actionOrScript2 = this.a.get(n);
                    if (!actionOrScript2.getValue().equals(actionOrScript.getValue())) continue;
                    int n2 = n;
                    Collections.swap(this.a, n2, n2 - 1);
                    break block3;
                }
                return;
            }
            for (n = 0; n < this.a.size() - 1; ++n) {
                ActionOrScript actionOrScript3 = this.a.get(n);
                if (!actionOrScript3.getValue().equals(actionOrScript.getValue())) continue;
                int n3 = n;
                Collections.swap(this.a, n3, n3 + 1);
                return;
            }
        }
    }

    public void writeOut(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)ACTIONS_BEGIN);
        if (this.noActionsValue()) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"NoAction:true");
        } else {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"NoAction:false");
        }
        for (int i = 0; i < this.a.size(); ++i) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Type:" + this.a.get(i).getType().name()));
            if (this.a.get(i).getType() == AbstractType.ACTION) {
                RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Action Name:" + this.a.get(i).getValue()));
                continue;
            }
            if (this.a.get(i).getType() != AbstractType.SCRIPT) continue;
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Script Path:" + ClientApp.Workspace().getRelativePath(this.a.get(i).getValue())));
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)ACTIONS_END);
    }

    public void readIn(BufferedReader bufferedReader) throws IOException {
        Object object;
        OpSupportActionsScripts opSupportActionsScripts = new OpSupportActionsScripts(true);
        opSupportActionsScripts.initialize();
        while ((object = bufferedReader.readLine()) != null) {
            Object object2 = RMAIO.getType((String)object, (String)":");
            String string = RMAIO.getParam((String)object, (String)":");
            if (ACTIONS_END.equals(object)) {
                return;
            }
            if ("NoAction".equals(object2)) {
                if ("true".equals(string)) {
                    this.b = true;
                    continue;
                }
                this.b = false;
                continue;
            }
            if (!"Type".equals(object2)) continue;
            object = AbstractType.valueOf(string.toUpperCase());
            if (AbstractType.ACTION == object) {
                object = bufferedReader.readLine();
                if (object == null) {
                    return;
                }
                object2 = RMAIO.getType((String)object, (String)":");
                string = RMAIO.getParam((String)object, (String)":");
                if (!ACTION_NAME.equals(object2)) continue;
                object = opSupportActionsScripts.getList().iterator();
                while (object.hasNext()) {
                    object2 = (ActionOrScript)((Object)object.next());
                    if (!object2.getValue().equals(string)) continue;
                    object2 = new ActionOrScript(AbstractType.ACTION, object2.getKey(), string);
                    this.addObject((ActionOrScript)((Object)object2));
                }
                continue;
            }
            if (AbstractType.SCRIPT != object) continue;
            object = bufferedReader.readLine();
            if (object == null) {
                return;
            }
            object2 = RMAIO.getType((String)object, (String)":");
            string = RMAIO.getParam((String)object, (String)":");
            if (!SCRIPT_PATH.equals(object2)) continue;
            string = ClientApp.Workspace().makeAbsolutePath(string);
            object = new Identifier(ClientApp.Workspace().getRelativePath(string));
            object2 = OpSupportActionPanel.getScriptId((Identifier)object);
            if (object2 == null) continue;
            object2 = new ActionOrScript(AbstractType.SCRIPT, null, string);
            this.addObject((ActionOrScript)((Object)object2));
        }
    }
}

