/*
 * Decompiled with CFR 0.152.
 */
package hec.rss.plugins.opsupport.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.gfx2d.G2dLineProperties;
import hec.lang.NamedType;
import hec.model.RunTimeWindow;
import hec.model.TSRecord;
import hec.rss.client.RSimSimulationMode;
import hec.rss.model.RssAlt;
import hec.rss.model.RssRun;
import hec.rss.model.RssSystem;
import hec.rss.model.RssTSRecordImpl;
import hec.rss.plugins.opsupport.client.ActionOrScript;
import hec.rss.plugins.opsupport.model.OSAltPluginData;
import hec.rss.plugins.opsupport.model.OpSupportActionsScripts;
import hec.rss.plugins.opsupport.model.OpSupportModelVariable;
import hec.rss.plugins.opsupport.model.OpSupportObject;
import hec.rss.plugins.opsupport.model.OpSupportTabConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import rma.util.RMAIO;

public class OpSupportConfig
extends NamedType
implements OpSupportObject {
    public static final int INPUT_TSDATA = 0;
    public static final int OUTPUT_TSDATA = 1;
    public static final int OBS_TSDATA = 2;
    int _columnWidth = 100;
    int _decimalPrecision = 1;
    List<OpSupportTabConfig> _tabConfigList = new ArrayList<OpSupportTabConfig>();
    private transient RssSystem a;
    private transient OSAltPluginData b;
    private transient RssAlt c;
    private transient RssRun d;
    private transient TSDataSet e;
    private transient TSDataSet f;
    private transient TSDataSet g;
    private transient HashMap<String, double[]> h = new HashMap();
    private boolean _protectLookback;
    private boolean _protectLookbackDefault = true;
    private boolean _computeOnClear = true;
    private RSimSimulationMode _simMode;
    private OpSupportActionsScripts _actionsScriptsList = new OpSupportActionsScripts(true);
    private Map<String, G2dLineProperties> _lineProperties = new HashMap<String, G2dLineProperties>();

    public double[] getOverrideArray(String string, int n) {
        double[] dArray = this.h.get(string);
        if (dArray == null) {
            dArray = new double[n];
            this.h.put(string, dArray);
        }
        return dArray;
    }

    public List<ActionOrScript> getActionsScriptsList() {
        return this._actionsScriptsList.getList();
    }

    @Override
    public boolean getNoActionValue() {
        return this._actionsScriptsList.noActionsValue();
    }

    @Override
    public void setNoActionValue(boolean bl) {
        this._actionsScriptsList.setNoActionsValue(bl);
    }

    public void setActionsScriptsList(List<ActionOrScript> list) {
        this._actionsScriptsList.setList(list);
    }

    @Override
    public OpSupportActionsScripts getActionsScripts() {
        return this._actionsScriptsList;
    }

    @Override
    public List<ActionOrScript> getListNoHierarchy() {
        return this._actionsScriptsList.getList();
    }

    @Override
    public void moveObject(ActionOrScript actionOrScript, boolean bl) {
        this._actionsScriptsList.moveObjectInList(actionOrScript, bl);
    }

    @Override
    public void addObject(ActionOrScript actionOrScript) {
        this._actionsScriptsList.addObject(actionOrScript);
    }

    @Override
    public void removeObject(ActionOrScript actionOrScript) {
        this._actionsScriptsList.removeObject(actionOrScript);
    }

    @Override
    public void resetActions() {
        this._actionsScriptsList.resetList();
    }

    @Override
    public void clearActions() {
        this._actionsScriptsList.clearList();
    }

    @Override
    public void setActionsEnabled(boolean bl) {
        this._actionsScriptsList.setNoActionsValue(!bl);
    }

    public RssRun getRssRun() {
        return this.d;
    }

    public void setModified(boolean bl) {
        super.setModified(bl);
        if (bl && this.c != null) {
            this.c.setModified(bl);
        }
    }

    public void setTabConfigList(List<OpSupportTabConfig> list) {
        this._tabConfigList.clear();
        this._tabConfigList.addAll(list);
    }

    public OpSupportConfig clone() {
        try {
            Object object;
            OpSupportConfig opSupportConfig = (OpSupportConfig)super.clone();
            ((OpSupportConfig)super.clone())._columnWidth = this._columnWidth;
            opSupportConfig._decimalPrecision = this._decimalPrecision;
            opSupportConfig._actionsScriptsList = new OpSupportActionsScripts(true);
            opSupportConfig._actionsScriptsList.getList().addAll(this._actionsScriptsList.getList());
            if (this._tabConfigList != null) {
                opSupportConfig._tabConfigList = new ArrayList<OpSupportTabConfig>();
                for (OpSupportTabConfig opSupportTabConfig : this._tabConfigList) {
                    object = opSupportTabConfig.clone();
                    opSupportTabConfig.clone()._varList = new ArrayList<OpSupportModelVariable>();
                    ((OpSupportTabConfig)object).setOSConfig(opSupportConfig);
                    Object object22 = opSupportTabConfig.getListNoHierarchy();
                    ((OpSupportTabConfig)object).resetAndAddActionsOrScriptsList((List<ActionOrScript>)object22);
                    ((OpSupportTabConfig)object).setNoActionValue(opSupportTabConfig.getNoActionValue());
                    for (Object object22 : opSupportTabConfig.getModelVariableList()) {
                        OpSupportModelVariable opSupportModelVariable = ((OpSupportModelVariable)object22).clone();
                        opSupportModelVariable.setTabConfig((OpSupportTabConfig)object);
                        opSupportModelVariable.resetAndAddActionsOrScriptsList(((OpSupportModelVariable)object22).getListNoHierarchy());
                        opSupportModelVariable.setNoActionValue(((OpSupportModelVariable)object22).getNoActionValue());
                        ((OpSupportTabConfig)object)._varList.add(opSupportModelVariable);
                    }
                    opSupportConfig._tabConfigList.add((OpSupportTabConfig)object);
                }
            }
            opSupportConfig._lineProperties = new HashMap<String, G2dLineProperties>();
            Set<Map.Entry<String, G2dLineProperties>> set = this._lineProperties.entrySet();
            Iterator<Map.Entry<String, G2dLineProperties>> iterator = set.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                opSupportConfig._lineProperties.put((String)object.getKey(), ((G2dLineProperties)object.getValue()).clone());
            }
            return opSupportConfig;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("OpSupportConfig.clone: Error in clone " + String.valueOf(cloneNotSupportedException));
            return null;
        }
    }

    private void buildDefaultConfig() {
        this._tabConfigList.add(new OpSupportTabConfig(this, "Tributary Inflow"));
        this._tabConfigList.add(new OpSupportTabConfig(this, "Local Inflow"));
        this._tabConfigList.add(new OpSupportTabConfig(this, "Reservior Releases"));
    }

    public void read(BufferedReader bufferedReader) throws IOException {
        this._tabConfigList = new ArrayList<OpSupportTabConfig>();
        this._lineProperties = new HashMap<String, G2dLineProperties>();
        boolean bl = false;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (string.length() == 0) {
                string = bufferedReader.readLine();
                continue;
            }
            String string2 = RMAIO.getType((String)string, (String)":");
            String string3 = RMAIO.getParam((String)string, (String)":");
            if (string2.equals("OSConfigEnd")) {
                this.setModified(false);
                if (!bl) {
                    this._actionsScriptsList.initialize();
                }
                this.setModified(false);
                return;
            }
            if (string2.equals("SupportingLineStylesBegin")) {
                string = bufferedReader.readLine();
                while (!string.equals("SupportingLineStylesEnd:")) {
                    if (string.equals("SupportingLineStyleBegin:")) {
                        string = bufferedReader.readLine();
                        var6_6 = null;
                        G2dLineProperties g2dLineProperties = null;
                        while (!string.equals("SupportingLineStyleEnd:")) {
                            string2 = RMAIO.getType((String)string, (String)":");
                            string3 = RMAIO.getParam((String)string, (String)":");
                            if (string2.equals("Name")) {
                                var6_6 = string3;
                            } else if (string2.equals("LineProperties Begin")) {
                                g2dLineProperties = new G2dLineProperties();
                                g2dLineProperties.readProperties(bufferedReader, "LineProperties End:");
                            }
                            string = bufferedReader.readLine();
                        }
                        this._lineProperties.put((String)var6_6, g2dLineProperties);
                    }
                    string = bufferedReader.readLine();
                }
            } else if (string2.equals("ColumnWidth")) {
                this._columnWidth = Integer.parseInt(string3);
            } else if (string2.equals("DecimalPrecision")) {
                this._decimalPrecision = Integer.parseInt(string3);
            } else if (string2.equals("ProtectLookback")) {
                this._protectLookback = this._protectLookbackDefault = Boolean.parseBoolean(string3);
            } else if (string2.equals("OSTabConfig")) {
                var6_6 = new OpSupportTabConfig(this, string3);
                ((OpSupportTabConfig)var6_6).read(bufferedReader);
                this._tabConfigList.add((OpSupportTabConfig)var6_6);
            } else if ("ActionsBegin".equals(string)) {
                bl = true;
                this._actionsScriptsList.readIn(bufferedReader);
            }
            string = bufferedReader.readLine();
        }
    }

    public void write(BufferedWriter bufferedWriter) {
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ColumnWidth:" + Integer.toString(this._columnWidth)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("DecimalPrecision:" + Integer.toString(this._decimalPrecision)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)("ProtectLookback:" + Boolean.toString(this._protectLookbackDefault)));
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SupportingLineStylesBegin:");
        Iterator<OpSupportTabConfig> iterator = this._lineProperties.entrySet();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map.Entry object = (Map.Entry)iterator.next();
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SupportingLineStyleBegin:");
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("Name:" + (String)object.getKey()));
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"LineProperties Begin:");
            ((G2dLineProperties)object.getValue()).writeProperties(bufferedWriter, null);
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"LineProperties End:");
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SupportingLineStyleEnd:");
        }
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"SupportingLineStylesEnd:");
        if (this._tabConfigList == null) {
            return;
        }
        for (OpSupportTabConfig opSupportTabConfig : this._tabConfigList) {
            RMAIO.fout((BufferedWriter)bufferedWriter, (String)("OSTabConfig:" + opSupportTabConfig.getName()));
            opSupportTabConfig.write(bufferedWriter);
        }
        this._actionsScriptsList.writeOut(bufferedWriter);
        RMAIO.fout((BufferedWriter)bufferedWriter, (String)"OSConfigEnd");
        this.setModified(false);
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
        this.setModified(true);
    }

    public int getDecimalPrecision() {
        return this._decimalPrecision;
    }

    public void setDecimalPrecision(int n) {
        this._decimalPrecision = n;
        this.setModified(true);
    }

    public void setRssSystem(RssSystem rssSystem) {
        this.a = rssSystem;
    }

    public RssSystem getRssSystem() {
        return this.a;
    }

    public int getTabCount() {
        if (this._tabConfigList == null) {
            return 0;
        }
        return this._tabConfigList.size();
    }

    public OpSupportTabConfig getTabConfig(int n) {
        if (this._tabConfigList == null) {
            return null;
        }
        return this._tabConfigList.get(n);
    }

    public void deleteTab(int n) {
        if (n < 0 || n >= this._tabConfigList.size()) {
            return;
        }
        this._tabConfigList.remove(n);
        this.setModified(true);
    }

    public OpSupportTabConfig addTab(String string) {
        OpSupportTabConfig opSupportTabConfig = this.getTabConfig(string);
        if (opSupportTabConfig != null) {
            return opSupportTabConfig;
        }
        if (this._tabConfigList == null) {
            this._tabConfigList = new ArrayList<OpSupportTabConfig>();
        }
        opSupportTabConfig = new OpSupportTabConfig(this, string);
        this._tabConfigList.add(opSupportTabConfig);
        this.setModified(true);
        return opSupportTabConfig;
    }

    public OpSupportTabConfig getTabConfig(String string) {
        if (string == null || this._tabConfigList == null) {
            return null;
        }
        for (OpSupportTabConfig opSupportTabConfig : this._tabConfigList) {
            if (!string.equalsIgnoreCase(opSupportTabConfig.getName())) continue;
            return opSupportTabConfig;
        }
        return null;
    }

    public void setOSPluginData(OSAltPluginData oSAltPluginData) {
        this.b = oSAltPluginData;
    }

    public void setRssAlt(RssAlt rssAlt) {
        this.c = rssAlt;
    }

    public RssAlt getRssAlt() {
        return this.c;
    }

    public void setRssRun(RssRun rssRun) {
        this.d = rssRun;
    }

    public OSAltPluginData getOSAltPluginData() {
        return this.b;
    }

    public void initCompute(RssRun rssRun) {
        this.setRssRun(rssRun);
        this.initCompute();
    }

    public void initCompute() {
        RssRun rssRun = this.d;
        if (rssRun == null || this._tabConfigList == null) {
            return;
        }
        rssRun.clearInputTSData();
        rssRun.clearOutputTSData();
        this.f = rssRun.getInputTSData();
        if (this.f != null) {
            this.initTSDataSet(rssRun, this.f);
        }
        this.g = rssRun.getRegOutputTSData();
        if (this.g != null) {
            this.initTSDataSet(rssRun, this.g);
        }
        this.e = rssRun.getObservedTSData();
        if (this.e != null) {
            this.initTSDataSet(rssRun, this.e);
        }
        for (OpSupportTabConfig opSupportTabConfig : this._tabConfigList) {
            opSupportTabConfig.initCompute(rssRun);
        }
    }

    private void initTSDataSet(RssRun rssRun, TSDataSet object) {
        RunTimeWindow runTimeWindow = rssRun.getRunTimeWindow();
        object.initialize(runTimeWindow);
        object = object.getTSRecords();
        int n = object.size();
        for (int i = 0; i < n; ++i) {
            runTimeWindow = (TSRecord)object.get(i);
            if (!(runTimeWindow instanceof RssTSRecordImpl)) continue;
            ((RssTSRecordImpl)runTimeWindow).setRssRun(rssRun);
        }
    }

    public TSRecord loadTSProxy(TSRecordProxy tSRecordProxy, int n) {
        if (tSRecordProxy == null) {
            return null;
        }
        TSDataSet tSDataSet = null;
        switch (n) {
            case 0: {
                tSDataSet = this.f;
                break;
            }
            case 1: {
                tSDataSet = this.g;
                break;
            }
            case 2: {
                tSDataSet = this.e;
            }
        }
        if (tSDataSet == null) {
            return null;
        }
        try {
            TSRecord tSRecord = tSDataSet.getTSRecord(tSRecordProxy.getName(), tSRecordProxy.getVariableId());
            if (tSRecord == null) {
                return null;
            }
            tSRecord.loadTSData(this.d.getRunTimeWindow().getLookbackTime(), this.d.getRunTimeWindow().getEndTime());
            return tSRecord;
        }
        catch (Exception exception) {
            System.out.println("OpSupportConfig: Failed to get load ts record for run " + tSRecordProxy.getName());
            return null;
        }
    }

    public List<OpSupportTabConfig> getTabConfigList() {
        return this._tabConfigList;
    }

    public boolean getProtectLookback() {
        return this._protectLookback;
    }

    public void setProtectLookback(boolean bl) {
        this._protectLookback = bl;
    }

    public boolean getComputeOnClear() {
        return this._computeOnClear;
    }

    public void setComputeOnClear(boolean bl) {
        this._computeOnClear = bl;
    }

    public boolean getProtectLookbackDefault() {
        return this._protectLookbackDefault;
    }

    public void setProtectLookbackDefault(boolean bl) {
        this._protectLookbackDefault = bl;
        this.setModified(true);
    }

    public boolean stepIsInLookback(int n) {
        int n2 = this.getNumLookbackSteps();
        return n <= n2;
    }

    public int getNumLookbackSteps() {
        RssRun rssRun = this.getRssRun();
        if (rssRun == null) {
            return -1;
        }
        rssRun = rssRun.getRunTimeWindow();
        return rssRun.getNumLookbackSteps();
    }

    public G2dLineProperties getLineProperties(String string) {
        return this._lineProperties.get(string);
    }

    public Map<String, G2dLineProperties> getLinePropertiesMap() {
        return this._lineProperties;
    }

    public void setLineProperties(String string, G2dLineProperties g2dLineProperties) {
        if (string == null) {
            return;
        }
        if (g2dLineProperties == null) {
            this._lineProperties.remove(string);
            return;
        }
        this._lineProperties.put(string, g2dLineProperties);
    }

    public Vector getActiveTSProxies(Vector vector, int n, RssAlt rssAlt) {
        if (this._tabConfigList != null) {
            for (OpSupportTabConfig opSupportTabConfig : this._tabConfigList) {
                vector = opSupportTabConfig.getActiveTSProxies(vector, n, rssAlt);
            }
        }
        return vector;
    }
}

